/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTNotExists;
import org.apache.cayenne.exp.parser.ASTSubquery;
import org.apache.cayenne.exp.parser.AggregateConditionNode;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;

class ExistsExpressionTranslator {
    private final TranslatorContext context;
    private final Expression expressionToTranslate;
    private final boolean not;

    ExistsExpressionTranslator(TranslatorContext context, SimpleNode exists) {
        this.context = context;
        this.expressionToTranslate = exists;
        this.not = exists instanceof ASTNotExists;
    }

    Expression translate() {
        Object child = this.expressionToTranslate.getOperand(0);
        if (child instanceof ASTSubquery) {
            return this.expressionToTranslate;
        }
        if (!(child instanceof Expression)) {
            throw new IllegalArgumentException("Expected expression as a child, got " + String.valueOf(child));
        }
        Expression translatedExpression = (Expression)child;
        DbEntity entity = this.context.getRootDbEntity();
        ObjEntity objEntity = this.context.getMetadata().getObjEntity();
        if (objEntity != null) {
            translatedExpression = objEntity.translateToDbPath(translatedExpression);
        }
        if (translatedExpression instanceof ASTDbPath) {
            DbPathMarker marker = this.createPathMarker(entity, (ASTDbPath)translatedExpression);
            Expression pathExistExp = this.markerToExpression(marker);
            if (marker.relationship == null) {
                return pathExistExp;
            }
            return this.subqueryExpression(marker.relationship, pathExistExp);
        }
        Map<SimpleNode, Map<DbRelationship, List<DbPathMarker>>> parents = this.groupPathsByParentAndRelationship(translatedExpression = translatedExpression.transform(o -> o instanceof ASTDbPath ? this.createPathMarker(entity, (ASTDbPath)o) : o));
        if (parents.isEmpty()) {
            return translatedExpression;
        }
        List<RelationshipToNode> relationshipToNodes = this.uniqueNodes(parents);
        return this.generateSubqueriesAndReplace(translatedExpression, relationshipToNodes);
    }

    private Expression generateSubqueriesAndReplace(Expression expressionToTranslate, List<RelationshipToNode> relationshipToNodes) {
        Expression finalExpression = null;
        for (RelationshipToNode pair : relationshipToNodes) {
            Expression exp = this.nodeToExpression(pair.node);
            SimpleNode replacement = this.subqueryExpression(pair.relationship, exp);
            Node parent = pair.node.jjtGetParent();
            if (parent == null) {
                if (finalExpression != null) {
                    throw new IllegalStateException("Expected single root expression");
                }
                finalExpression = replacement;
                continue;
            }
            finalExpression = expressionToTranslate;
            for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                if (parent.jjtGetChild(i) != pair.node) continue;
                parent.jjtAddChild(replacement, i);
                replacement.jjtSetParent(parent);
            }
        }
        return finalExpression;
    }

    private SimpleNode subqueryExpression(DbRelationship relationship, Expression exp) {
        for (DbJoin join : relationship.getJoins()) {
            Expression joinMatchExp = ExpressionFactory.matchDbExp(join.getTargetName(), ExpressionFactory.enclosingObjectExp(ExpressionFactory.dbPathExp(join.getSourceName())));
            if (exp == null) {
                exp = joinMatchExp;
                continue;
            }
            exp = exp.andExp(joinMatchExp);
        }
        ObjectSelect select = (ObjectSelect)((ObjectSelect)ObjectSelect.query(Persistent.class).dbEntityName(relationship.getTargetEntityName())).where(exp);
        return (SimpleNode)(this.not ? ExpressionFactory.notExists(select) : ExpressionFactory.exists(select));
    }

    private Expression nodeToExpression(SimpleNode node) {
        if (node instanceof ParentMarker) {
            return null;
        }
        if (node instanceof DbPathMarker) {
            return this.markerToExpression((DbPathMarker)node);
        }
        return node.deepCopy();
    }

    private Expression markerToExpression(DbPathMarker marker) {
        if (marker.getPath().isEmpty()) {
            return null;
        }
        return ExpressionFactory.noMatchExp(marker, null);
    }

    private List<RelationshipToNode> uniqueNodes(Map<SimpleNode, Map<DbRelationship, List<DbPathMarker>>> parents) {
        ArrayList<RelationshipToNode> relationshipToNodes = new ArrayList<RelationshipToNode>(parents.size());
        parents.forEach((parent, relToPath) -> relToPath.forEach((rel, paths) -> {
            if (paths.size() != parent.jjtGetNumChildren()) {
                paths.forEach(p -> {
                    SimpleNode nearestCondition = this.getParentCondition((Expression)p);
                    relationshipToNodes.add(new RelationshipToNode((DbRelationship)rel, nearestCondition));
                });
            } else {
                relationshipToNodes.add(new RelationshipToNode((DbRelationship)rel, (SimpleNode)parent));
            }
        }));
        return relationshipToNodes;
    }

    private Map<SimpleNode, Map<DbRelationship, List<DbPathMarker>>> groupPathsByParentAndRelationship(Expression expressionToTranslate) {
        HashMap<SimpleNode, Map<DbRelationship, List<DbPathMarker>>> parents = new HashMap<SimpleNode, Map<DbRelationship, List<DbPathMarker>>>(4);
        expressionToTranslate.traverse((node, parentNode) -> {
            if (node instanceof DbPathMarker) {
                DbPathMarker marker = (DbPathMarker)node;
                if (marker.root()) {
                    return;
                }
                SimpleNode parent = this.getParentAggregateCondition(parentNode);
                parents.computeIfAbsent(parent, p -> new HashMap(4)).computeIfAbsent(marker.relationship, r -> new ArrayList(4)).add(marker);
            }
        });
        return parents;
    }

    private SimpleNode getParentAggregateCondition(Expression parentNode) {
        Node parent;
        for (parent = (Node)((Object)parentNode); parent != null && !(parent instanceof AggregateConditionNode); parent = parent.jjtGetParent()) {
        }
        if (parent == null) {
            parent = new ParentMarker();
        }
        return (SimpleNode)parent;
    }

    private SimpleNode getParentCondition(Expression parentNode) {
        Node parent;
        for (parent = (Node)((Object)parentNode); parent != null && !(parent instanceof ConditionNode); parent = parent.jjtGetParent()) {
        }
        if (parent == null) {
            parent = new ParentMarker();
        }
        return (SimpleNode)parent;
    }

    private DbPathMarker createPathMarker(DbEntity entity, ASTDbPath o) {
        DbRelationship relationship;
        CayennePath path = o.getPath();
        CayennePath newPath = CayennePath.EMPTY_PATH;
        if (path.length() > 1) {
            newPath = path.tail(1);
        }
        if ((relationship = (DbRelationship)entity.getRelationship(path.first().value())) == null) {
            newPath = path;
        }
        return new DbPathMarker(newPath, relationship);
    }

    static class DbPathMarker
    extends ASTDbPath {
        final DbRelationship relationship;

        DbPathMarker(CayennePath path, DbRelationship relationship) {
            super(path);
            this.relationship = relationship;
        }

        @Override
        public Expression shallowCopy() {
            return new DbPathMarker(this.getPath(), this.relationship);
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        boolean root() {
            return this.relationship == null;
        }
    }

    static class RelationshipToNode {
        final DbRelationship relationship;
        final SimpleNode node;

        RelationshipToNode(DbRelationship relationship, SimpleNode node) {
            this.relationship = relationship;
            this.node = node;
        }
    }

    static class ParentMarker
    extends ConditionNode {
        public ParentMarker() {
            super(0);
        }

        @Override
        public Expression shallowCopy() {
            return this;
        }

        @Override
        protected int getRequiredChildrenCount() {
            return 0;
        }

        @Override
        protected Boolean evaluateSubNode(Object o, Object[] evaluatedChildren) throws Exception {
            return null;
        }

        @Override
        protected String getExpressionOperator(int index) {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    static interface SimpleTraversalHandler
    extends TraversalHandler {
        @Override
        public void endNode(Expression var1, Expression var2);
    }
}

