/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiskFileItemSerializeTest {
    private static final File REPO = new File(System.getProperty("java.io.tmpdir"), "diskfileitemrepo");
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    private static final int THRESHOLD = 16;

    private void compareBytes(String text, byte[] origBytes, byte[] newBytes) {
        Assert.assertNotNull((String)"origBytes must not be null", (Object)origBytes);
        Assert.assertNotNull((String)"newBytes must not be null", (Object)newBytes);
        Assert.assertEquals((String)(text + " byte[] length"), (long)origBytes.length, (long)newBytes.length);
        for (int i = 0; i < origBytes.length; ++i) {
            Assert.assertEquals((String)(text + " byte[" + i + "]"), (long)origBytes[i], (long)newBytes[i]);
        }
    }

    private byte[] createContentBytes(int size) {
        StringBuilder buffer = new StringBuilder(size);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            buffer.append(count + "");
            count = (byte)(count + 1);
            if (count <= 9) continue;
            count = 0;
        }
        return buffer.toString().getBytes();
    }

    private FileItem createFileItem(byte[] contentBytes) throws IOException {
        return this.createFileItem(contentBytes, REPO);
    }

    private FileItem createFileItem(byte[] contentBytes, File repository) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, repository);
        String textFieldName = "textField";
        FileItem item = factory.createItem("textField", CONTENT_TYPE_TEXT, true, "My File Name");
        try (OutputStream os = item.getOutputStream();){
            os.write(contentBytes);
        }
        return item;
    }

    private Object deserialize(ByteArrayOutputStream baos) throws Exception {
        Object result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        result = ois.readObject();
        bais.close();
        return result;
    }

    private ByteArrayOutputStream serialize(Object target) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(target);
            oos.flush();
        }
        return baos;
    }

    @Before
    public void setUp() throws Exception {
        if (REPO.exists()) {
            FileUtils.deleteDirectory((File)REPO);
        }
        FileUtils.forceMkdir((File)REPO);
    }

    @After
    public void tearDown() throws IOException {
        for (File file : FileUtils.listFiles((File)REPO, null, (boolean)true)) {
            System.out.println("Found leftover file " + file);
        }
        FileUtils.deleteDirectory((File)REPO);
    }

    @Test
    public void testAboveThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(17);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertFalse((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        item.delete();
    }

    @Test
    public void testBelowThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(15);
        this.testInMemoryObject(testFieldValueBytes);
    }

    private void testInMemoryObject(byte[] testFieldValueBytes) throws IOException {
        this.testInMemoryObject(testFieldValueBytes, REPO);
    }

    private void testInMemoryObject(byte[] testFieldValueBytes, File repository) throws IOException {
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        Assert.assertTrue((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        item.delete();
    }

    @Test(expected=IOException.class)
    public void testInvalidRepository() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir"), "file");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        this.deserialize(this.serialize(item));
    }

    @Test(expected=InvalidPathException.class)
    public void testInvalidRepositoryWithNullChar() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir"), "\u0000");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        this.deserialize(this.serialize(item));
    }

    @Test
    public void testThreshold() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testValidRepository() throws IOException {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes, REPO);
    }
}

