/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import org.apache.commons.jci.AbstractTestCase;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.classes.ExtendedDump;
import org.apache.commons.jci.classes.SimpleDump;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.listeners.ReloadingListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReloadingClassLoaderTestCase
extends AbstractTestCase {
    private final Log log = LogFactory.getLog(ReloadingClassLoaderTestCase.class);
    private ReloadingClassLoader classloader;
    private ReloadingListener listener;
    private FilesystemAlterationMonitor fam;
    private final byte[] clazzSimple1 = SimpleDump.dump("Simple1");
    private final byte[] clazzSimple2 = SimpleDump.dump("Simple2");
    private final byte[] clazzExtended = ExtendedDump.dump();

    public ReloadingClassLoaderTestCase() throws Exception {
        ReloadingClassLoaderTestCase.assertTrue((this.clazzSimple1.length > 0 ? 1 : 0) != 0);
        ReloadingClassLoaderTestCase.assertTrue((this.clazzSimple2.length > 0 ? 1 : 0) != 0);
        ReloadingClassLoaderTestCase.assertTrue((this.clazzExtended.length > 0 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.classloader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.listener = new ReloadingListener();
        this.listener.addReloadNotificationListener((ReloadNotificationListener)this.classloader);
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(this.directory, (FilesystemAlterationListener)this.listener);
        this.fam.start();
    }

    public void testCreate() throws Exception {
        this.listener.waitForFirstCheck();
        this.log.debug((Object)"creating class");
        this.writeFile("jci/Simple.class", this.clazzSimple1);
        this.listener.waitForCheck();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
    }

    public void testChange() throws Exception {
        this.listener.waitForFirstCheck();
        this.log.debug((Object)"creating class");
        this.writeFile("jci/Simple.class", this.clazzSimple1);
        this.listener.waitForCheck();
        Object simple1 = this.classloader.loadClass("jci.Simple").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple1.toString());
        this.log.debug((Object)"changing class");
        this.writeFile("jci/Simple.class", this.clazzSimple2);
        this.listener.waitForEvent();
        Object simple2 = this.classloader.loadClass("jci.Simple").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Simple2", (String)simple2.toString());
    }

    public void testDelete() throws Exception {
        this.listener.waitForFirstCheck();
        this.log.debug((Object)"creating class");
        this.writeFile("jci/Simple.class", this.clazzSimple1);
        this.listener.waitForCheck();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        this.log.debug((Object)"deleting class");
        ReloadingClassLoaderTestCase.assertTrue((boolean)new File(this.directory, "jci/Simple.class").delete());
        this.listener.waitForEvent();
        try {
            this.classloader.loadClass("jci.Simple").newInstance();
            ReloadingClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException e) {
            ReloadingClassLoaderTestCase.assertEquals((String)"jci.Simple", (String)e.getMessage());
        }
    }

    public void testDeleteDependency() throws Exception {
        this.listener.waitForFirstCheck();
        this.log.debug((Object)"creating classes");
        this.writeFile("jci/Simple.class", this.clazzSimple1);
        this.writeFile("jci/Extended.class", this.clazzExtended);
        this.listener.waitForCheck();
        Object simple = this.classloader.loadClass("jci.Simple").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Simple1", (String)simple.toString());
        Object extended = this.classloader.loadClass("jci.Extended").newInstance();
        ReloadingClassLoaderTestCase.assertEquals((String)"Extended:Simple1", (String)extended.toString());
        this.log.debug((Object)"deleting class dependency");
        ReloadingClassLoaderTestCase.assertTrue((boolean)new File(this.directory, "jci/Simple.class").delete());
        this.listener.waitForEvent();
        try {
            this.classloader.loadClass("jci.Extended").newInstance();
            ReloadingClassLoaderTestCase.fail();
        }
        catch (NoClassDefFoundError e) {
            ReloadingClassLoaderTestCase.assertEquals((String)"jci/Simple", (String)e.getMessage());
        }
    }

    public void testClassNotFound() {
        try {
            this.classloader.loadClass("bla");
            ReloadingClassLoaderTestCase.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testDelegation() {
        this.classloader.clearAssertionStatus();
        this.classloader.setClassAssertionStatus("org.apache.commons.jci.ReloadingClassLoader", true);
        this.classloader.setDefaultAssertionStatus(false);
        this.classloader.setPackageAssertionStatus("org.apache.commons.jci", true);
    }

    protected void tearDown() throws Exception {
        this.fam.removeListener((FilesystemAlterationListener)this.listener);
        this.fam.stop();
        super.tearDown();
    }
}

