/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.monitor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jci.listeners.AbstractFilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilesystemAlterationMonitorTestCase
extends TestCase {
    private final Log log = LogFactory.getLog(FilesystemAlterationMonitorTestCase.class);
    private FilesystemAlterationMonitor fam;
    private MyFilesystemAlterationListener listener;
    private File directory;

    protected void setUp() throws Exception {
        this.directory = this.createTempDirectory();
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)this.directory.exists());
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)this.directory.isDirectory());
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.directory);
    }

    protected File createDirectory(String pName) throws Exception {
        File newDirectory = new File(this.directory, pName);
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)newDirectory.mkdir());
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)newDirectory.exists());
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)newDirectory.isDirectory());
        return newDirectory;
    }

    protected File writeFile(String pName, byte[] pData) throws Exception {
        File file = new File(this.directory, pName);
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("could not create" + parent);
        }
        this.log.debug((Object)("writing file " + pName + " (" + pData.length + " bytes)"));
        FileOutputStream os = new FileOutputStream(file);
        os.write(pData);
        os.close();
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)file.exists());
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)file.isFile());
        return file;
    }

    protected File writeFile(String pName, String pText) throws Exception {
        File file = new File(this.directory, pName);
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("could not create" + parent);
        }
        this.log.debug((Object)("writing " + file));
        FileWriter writer = new FileWriter(file);
        writer.write(pText);
        writer.close();
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)file.exists());
        FilesystemAlterationMonitorTestCase.assertTrue((boolean)file.isFile());
        return file;
    }

    protected File createTempDirectory() throws IOException {
        File tempFile = File.createTempFile("jci", null);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    protected void delay() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void start() throws Exception {
        this.fam = new FilesystemAlterationMonitor();
        this.listener = new MyFilesystemAlterationListener();
        this.fam.addListener(this.directory, (FilesystemAlterationListener)this.listener);
        this.fam.start();
        this.listener.waitForFirstCheck();
    }

    private void stop() {
        this.fam.stop();
    }

    public void testListenerDoublication() throws Exception {
        this.fam = new FilesystemAlterationMonitor();
        this.listener = new MyFilesystemAlterationListener();
        this.fam.addListener(this.directory, (FilesystemAlterationListener)this.listener);
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.fam.getListenersFor(this.directory).length);
        this.fam.addListener(this.directory, (FilesystemAlterationListener)this.listener);
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.fam.getListenersFor(this.directory).length);
        this.fam.removeListener((FilesystemAlterationListener)this.listener);
        FilesystemAlterationMonitorTestCase.assertEquals((int)0, (int)this.fam.getListenersFor(this.directory).length);
    }

    public void testDirectoryDoublication() throws Exception {
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(this.directory, (FilesystemAlterationListener)new MyFilesystemAlterationListener());
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.fam.getListenersFor(this.directory).length);
        this.fam.addListener(this.directory, (FilesystemAlterationListener)new MyFilesystemAlterationListener());
        FilesystemAlterationMonitorTestCase.assertEquals((int)2, (int)this.fam.getListenersFor(this.directory).length);
    }

    public void testCreateFileDetection() throws Exception {
        this.start();
        this.writeFile("file", "file");
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getCreatedFiles().size());
        this.stop();
    }

    public void testTimeout() throws Exception {
        this.listener = new MyFilesystemAlterationListener();
        try {
            this.listener.waitForFirstCheck();
            FilesystemAlterationMonitorTestCase.fail((String)"should be an timeout");
        }
        catch (Exception e) {
            FilesystemAlterationMonitorTestCase.assertEquals((String)"timeout", (String)e.getMessage());
        }
        this.start();
        try {
            this.listener.waitForEvent();
            FilesystemAlterationMonitorTestCase.fail((String)"should be an timeout");
        }
        catch (Exception e) {
            FilesystemAlterationMonitorTestCase.assertEquals((String)"timeout", (String)e.getMessage());
        }
        this.stop();
        try {
            this.listener.waitForCheck();
            FilesystemAlterationMonitorTestCase.fail((String)"should be an timeout");
        }
        catch (Exception e) {
            FilesystemAlterationMonitorTestCase.assertEquals((String)"timeout", (String)e.getMessage());
        }
    }

    public void testCreateDirectoryDetection() throws Exception {
        this.start();
        this.createDirectory("dir");
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getCreatedDirectories().size());
        this.stop();
    }

    public void testDeleteFileDetection() throws Exception {
        this.start();
        File file = this.writeFile("file", "file");
        FilesystemAlterationMonitorTestCase.assertTrue((String)"file should exist", (boolean)file.exists());
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((String)"expecting 1 file created", (int)1, (int)this.listener.getCreatedFiles().size());
        file.delete();
        FilesystemAlterationMonitorTestCase.assertFalse((String)"file should not exist", (boolean)file.exists());
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((String)"expecting 1 file deleted", (int)1, (int)this.listener.getDeletedFiles().size());
        this.stop();
    }

    public void testDeleteDirectoryDetection() throws Exception {
        this.start();
        File dir = this.createDirectory("dir");
        this.createDirectory("dir/sub");
        File file = this.writeFile("dir/sub/file", "file");
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)2, (int)this.listener.getCreatedDirectories().size());
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getCreatedFiles().size());
        this.delay();
        FileUtils.deleteDirectory((File)dir);
        FilesystemAlterationMonitorTestCase.assertTrue((!dir.exists() ? 1 : 0) != 0);
        FilesystemAlterationMonitorTestCase.assertTrue((!file.exists() ? 1 : 0) != 0);
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)2, (int)this.listener.getDeletedDirectories().size());
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getDeletedFiles().size());
        this.stop();
    }

    public void testModifyFileDetection() throws Exception {
        this.start();
        this.writeFile("file", "file");
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getCreatedFiles().size());
        this.delay();
        this.writeFile("file", "changed file");
        this.listener.waitForCheck();
        FilesystemAlterationMonitorTestCase.assertEquals((int)1, (int)this.listener.getChangedFiles().size());
        this.stop();
    }

    public void testCreatingLocalDirectoryChangesLastModified() throws Exception {
        long modified = this.directory.lastModified();
        this.delay();
        this.createDirectory("directory");
        this.delay();
        FilesystemAlterationMonitorTestCase.assertTrue((this.directory.lastModified() != modified ? 1 : 0) != 0);
    }

    public void testCreatingLocalFileChangesLastModified() throws Exception {
        long modified = this.directory.lastModified();
        this.delay();
        this.writeFile("file", "file");
        this.delay();
        FilesystemAlterationMonitorTestCase.assertTrue((this.directory.lastModified() != modified ? 1 : 0) != 0);
    }

    public void testCreatingSubDirectoryChangesLastModified() throws Exception {
        this.createDirectory("dir");
        long modified = this.directory.lastModified();
        this.delay();
        this.createDirectory("dir/sub");
        FilesystemAlterationMonitorTestCase.assertTrue((this.directory.lastModified() == modified ? 1 : 0) != 0);
    }

    public void testCreatingFileInSubDirectoryChangesLastModified() throws Exception {
        this.createDirectory("dir");
        long modified = this.directory.lastModified();
        this.delay();
        this.writeFile("dir/file", "file");
        FilesystemAlterationMonitorTestCase.assertTrue((this.directory.lastModified() == modified ? 1 : 0) != 0);
    }

    public void testInterval() throws Exception {
        long interval = 1000L;
        this.start();
        this.fam.setInterval(1000L);
        this.listener.waitForCheck();
        long t1 = System.currentTimeMillis();
        this.listener.waitForCheck();
        long t2 = System.currentTimeMillis();
        long diff = t2 - t1;
        FilesystemAlterationMonitorTestCase.assertTrue((String)("the interval was set to 1000 but the time difference was " + diff), (diff > 950L && diff < 1050L ? 1 : 0) != 0);
        this.stop();
    }

    private static class MyFilesystemAlterationListener
    extends AbstractFilesystemAlterationListener {
        private MyFilesystemAlterationListener() {
        }
    }
}

