/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.AbstractHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;

public abstract class AbstractMatcherContainer
extends AbstractHeaderMatcher {
    @ConfigComponent(desc="enclosed Matchers", type=ComponentType.PARAMETER, parameterType=IHeaderMatcher.class, required=true)
    private final Collection<IHeaderMatcher> enclosed;
    @ConfigComponent(desc="Resource to read matcher definitions from.", type=ComponentType.PARAMETER)
    private final String resource;

    public AbstractMatcherContainer(String id, Collection<? extends IHeaderMatcher> enclosed, String resource) {
        super(id);
        Objects.requireNonNull(enclosed, "The collection of IHeaderMatcher may not be null");
        this.enclosed = new ArrayList<IHeaderMatcher>(enclosed);
        this.resource = resource;
    }

    public AbstractMatcherContainer(Collection<? extends IHeaderMatcher> enclosed, String resource) {
        this(null, enclosed, resource);
    }

    @Override
    public void reset() {
        this.enclosed.forEach(IHeaderMatcher::reset);
    }

    public Collection<IHeaderMatcher> getEnclosed() {
        return Collections.unmodifiableCollection(this.enclosed);
    }

    public String getResource() {
        return this.resource;
    }
}

