/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.common.CommonConfiguration;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.plugin.storage.api.StorageConfiguration;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.registry.api.RegistryConfiguration;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskEngineDelegator;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistryClient;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Import;

@Import(value={CommonConfiguration.class, StorageConfiguration.class, RegistryConfiguration.class})
@SpringBootApplication
public class WorkerServer
implements IStoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    @Autowired
    private WorkerRegistryClient workerRegistryClient;
    @Autowired
    private WorkerRpcServer workerRpcServer;
    @Autowired
    private MetricsProvider metricsProvider;
    @Autowired
    private PhysicalTaskEngineDelegator physicalTaskEngineDelegator;

    public static void main(String[] args) {
        WorkerServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Worker-Server");
        SpringApplication.run(WorkerServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() {
        ServerLifeCycleManager.toRunning();
        this.workerRpcServer.start();
        TaskPluginManager.loadTaskPlugin();
        DataSourceProcessorProvider.initialize();
        this.workerRegistryClient.setRegistryStoppable(this);
        this.workerRegistryClient.start();
        this.physicalTaskEngineDelegator.start();
        WorkerServerMetrics.registerWorkerCpuUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getSystemCpuUsagePercentage();
        });
        WorkerServerMetrics.registerWorkerMemoryAvailableGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return (systemMetrics.getSystemMemoryMax() - systemMetrics.getSystemMemoryUsed()) / 1024.0 / 1024.0 / 1024.0;
        });
        WorkerServerMetrics.registerWorkerMemoryUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getJvmMemoryUsedPercentage();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!ServerLifeCycleManager.isStopped()) {
                this.close("WorkerServer shutdown hook");
            }
        }));
    }

    public void close(String cause) {
        if (!ServerLifeCycleManager.toStopped()) {
            log.warn("WorkerServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        try (PhysicalTaskEngineDelegator ignore1 = this.physicalTaskEngineDelegator;
             WorkerRpcServer ignore2 = this.workerRpcServer;
             WorkerRegistryClient ignore3 = this.workerRegistryClient;){
            log.info("Worker server is stopping, current cause : {}", (Object)cause);
        }
        catch (Exception e) {
            log.error("Worker server stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        log.info("Worker server stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
        System.exit(1);
    }
}

