/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    protected ConfigurableEnvironment environment;
    protected ConfigReloadProperties properties;
    protected ConfigurationUpdateStrategy strategy;

    public ConfigurationChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy) {
        this.environment = environment;
        this.properties = properties;
        this.strategy = strategy;
    }

    public void reloadProperties() {
        this.log.info((Object)("Reloading using strategy: " + this.strategy.getName()));
        this.strategy.reload();
    }

    public boolean changed(MapPropertySource left, MapPropertySource right) {
        Map rightMap;
        if (left == right) {
            return false;
        }
        if (left == null || right == null) {
            return true;
        }
        Map leftMap = (Map)left.getSource();
        return !Objects.equals(leftMap, rightMap = (Map)right.getSource());
    }

    public boolean changed(List<? extends MapPropertySource> left, List<? extends MapPropertySource> right) {
        if (left.size() != right.size()) {
            this.log.warn((Object)"The current number of ConfigMap PropertySources does not match the ones loaded from the Kubernetes - No reload will take place");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("source 1: %d", left.size()));
                left.forEach(item -> this.log.debug(item));
                this.log.debug((Object)String.format("source 2: %d", right.size()));
                right.forEach(item -> this.log.debug(item));
            }
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (!this.changed(left.get(i), right.get(i))) continue;
            return true;
        }
        return false;
    }

    protected <S extends PropertySource<?>> S findPropertySource(Class<S> sourceClass) {
        List<S> sources = this.findPropertySources(sourceClass);
        if (sources.size() == 0) {
            return null;
        }
        if (sources.size() > 1) {
            this.log.warn((Object)("Found more than one property source of type " + sourceClass));
        }
        return (S)((PropertySource)sources.get(0));
    }

    public <S extends PropertySource<?>> List<S> findPropertySources(Class<S> sourceClass) {
        LinkedList<S> managedSources = new LinkedList<S>();
        LinkedList<PropertySource> sources = this.toLinkedList((Iterable)this.environment.getPropertySources());
        this.log.debug((Object)"findPropertySources");
        this.log.debug((Object)String.format("environment: %s", this.environment));
        this.log.debug((Object)String.format("environment sources: %s", sources));
        while (!sources.isEmpty()) {
            PropertySource propertySource;
            PropertySource source = (PropertySource)sources.pop();
            if (source instanceof CompositePropertySource) {
                CompositePropertySource comp = (CompositePropertySource)source;
                sources.addAll(comp.getPropertySources());
                continue;
            }
            if (sourceClass.isInstance(source)) {
                managedSources.add(sourceClass.cast(source));
                continue;
            }
            if (!(source instanceof BootstrapPropertySource) || !sourceClass.isInstance(propertySource = ((BootstrapPropertySource)source).getDelegate())) continue;
            sources.add(propertySource);
        }
        return managedSources;
    }

    private <E> LinkedList<E> toLinkedList(Iterable<E> it) {
        LinkedList<E> list = new LinkedList<E>();
        for (E e : it) {
            list.add(e);
        }
        return list;
    }

    protected List<MapPropertySource> locateMapPropertySources(PropertySourceLocator propertySourceLocator, Environment environment) {
        ArrayList<MapPropertySource> result = new ArrayList<MapPropertySource>();
        PropertySource propertySource = propertySourceLocator.locate(environment);
        if (propertySource instanceof MapPropertySource) {
            result.add((MapPropertySource)propertySource);
        } else if (propertySource instanceof CompositePropertySource) {
            result.addAll(((CompositePropertySource)propertySource).getPropertySources().stream().filter(p -> p instanceof MapPropertySource).map(p -> (MapPropertySource)p).collect(Collectors.toList()));
        } else {
            this.log.debug((Object)("Found property source that cannot be handled: " + propertySource.getClass()));
        }
        this.log.debug((Object)"locateMapPropertySources");
        this.log.debug((Object)String.format("environment: %s", environment));
        this.log.debug((Object)String.format("sources: %s", result));
        return result;
    }
}

