/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.Restriction;
import com.azure.resourcemanager.storage.models.SkuCapability;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.SkuTier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SkuInformationInner {
    @JsonProperty(value="name", required=true)
    private SkuName name;
    @JsonProperty(value="tier", access=JsonProperty.Access.WRITE_ONLY)
    private SkuTier tier;
    @JsonProperty(value="resourceType", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceType;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private Kind kind;
    @JsonProperty(value="locations", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> locations;
    @JsonProperty(value="capabilities", access=JsonProperty.Access.WRITE_ONLY)
    private List<SkuCapability> capabilities;
    @JsonProperty(value="restrictions")
    private List<Restriction> restrictions;
    private static final ClientLogger LOGGER = new ClientLogger(SkuInformationInner.class);

    public SkuName name() {
        return this.name;
    }

    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Kind kind() {
        return this.kind;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    public SkuInformationInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model SkuInformationInner"));
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }
}

