/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.transfer.ImageAuditingImpl;
import com.qcloud.cos.transfer.ImageAuditingMonitor;
import com.qcloud.cos.transfer.Transfer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImageAuditingCallable
implements Callable<ImageAuditingResponse> {
    private static final Logger log = LoggerFactory.getLogger(ImageAuditingCallable.class);
    private final COS cos;
    private final CountDownLatch latch;
    private final ImageAuditingRequest req;
    private final ImageAuditingImpl imageAuditing;

    ImageAuditingCallable(COS cos, CountDownLatch latch, ImageAuditingRequest request, ImageAuditingImpl imageAuditing) {
        if (cos == null || latch == null || imageAuditing == null) {
            throw new IllegalArgumentException();
        }
        this.cos = cos;
        this.latch = latch;
        this.req = request;
        this.imageAuditing = imageAuditing;
    }

    @Override
    public ImageAuditingResponse call() throws Exception {
        ImageAuditingResponse imageAuditingResponse = null;
        try {
            this.latch.await();
            this.imageAuditing.setState(Transfer.TransferState.InProgress);
            imageAuditingResponse = this.cos.imageAuditing(this.req);
            if (imageAuditingResponse == null) {
                this.imageAuditing.setState(Transfer.TransferState.Canceled);
                this.imageAuditing.setMonitor(new ImageAuditingMonitor(this.imageAuditing, null));
            } else {
                this.imageAuditing.setResponse(imageAuditingResponse);
                this.imageAuditing.setState(Transfer.TransferState.Completed);
            }
            return imageAuditingResponse;
        }
        catch (Throwable t) {
            if (this.imageAuditing.getState() != Transfer.TransferState.Canceled) {
                this.imageAuditing.setState(Transfer.TransferState.Failed);
            }
            this.imageAuditing.setErrMsg(t.getMessage());
            return new ImageAuditingResponse();
        }
    }
}

