/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum InputType {
    DEFAULT(0, "default"),
    STATISTICS(1, "statistics"),
    COMPARISON(2, "comparison"),
    CHECK(3, "check");

    private final int code;
    private final String description;
    private static final Map<Integer, InputType> VALUES_MAP;

    private InputType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static InputType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, InputType>();
        for (InputType type : InputType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

