/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import it.unimi.dsi.fastutil.objects.Object2LongRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DistinctKeyCollector;
import org.apache.druid.msq.statistics.DistinctKeySnapshot;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.segment.column.RowSignature;

public class DistinctKeyCollectorFactory
implements KeyCollectorFactory<DistinctKeyCollector, DistinctKeySnapshot> {
    private final Comparator<RowKey> comparator;

    private DistinctKeyCollectorFactory(Comparator<RowKey> comparator) {
        this.comparator = comparator;
    }

    static DistinctKeyCollectorFactory create(ClusterBy clusterBy, RowSignature rowSignature) {
        return new DistinctKeyCollectorFactory(clusterBy.keyComparator(rowSignature));
    }

    @Override
    public DistinctKeyCollector newKeyCollector() {
        return new DistinctKeyCollector(this.comparator);
    }

    @Override
    public DistinctKeySnapshot toSnapshot(DistinctKeyCollector collector) {
        return new DistinctKeySnapshot(collector.getRetainedKeys().entrySet().stream().map(entry -> new SerializablePair((Object)((RowKey)entry.getKey()), (Object)((Long)entry.getValue()))).collect(Collectors.toList()), collector.getSpaceReductionFactor());
    }

    @Override
    public DistinctKeyCollector fromSnapshot(DistinctKeySnapshot snapshot) {
        Object2LongRBTreeMap retainedKeys = new Object2LongRBTreeMap(this.comparator);
        retainedKeys.putAll(snapshot.getKeysAsMap());
        return new DistinctKeyCollector(this.comparator, (Object2LongSortedMap<RowKey>)retainedKeys, snapshot.getSpaceReductionFactor());
    }
}

