/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.hadoop;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.hadoop.DatasourceIngestionSpec;
import org.apache.druid.indexer.hadoop.DatasourceInputFormat;
import org.apache.druid.indexer.hadoop.DatasourceInputSplit;
import org.apache.druid.indexer.hadoop.SegmentInputRow;
import org.apache.druid.indexer.hadoop.WindowedDataSegment;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.realtime.WindowedCursorFactory;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;

public class DatasourceRecordReader
extends RecordReader<NullWritable, InputRow> {
    private static final Logger logger = new Logger(DatasourceRecordReader.class);
    private DatasourceIngestionSpec spec;
    private SegmentReader segmentReader;
    private long rowNum;
    private Row currRow;
    private List<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
    private List<File> tmpSegmentDirs = new ArrayList<File>();
    private long numRows;

    public void initialize(InputSplit split, final TaskAttemptContext context) throws IOException {
        List<WindowedDataSegment> segments = ((DatasourceInputSplit)split).getSegments();
        String dataSource = (String)Iterators.getOnlyElement(segments.stream().map(s -> s.getSegment().getDataSource()).distinct().iterator());
        this.spec = DatasourceInputFormat.getIngestionSpec(context.getConfiguration(), dataSource);
        logger.info("load schema [%s]", new Object[]{this.spec});
        List adapters = Lists.transform(segments, (Function)new Function<WindowedDataSegment, WindowedCursorFactory>(){

            public WindowedCursorFactory apply(WindowedDataSegment segment) {
                try {
                    logger.info("Getting storage path for segment [%s]", new Object[]{segment.getSegment().getId()});
                    Path path = new Path(JobHelper.getURIFromSegment(segment.getSegment()));
                    logger.info("Fetch segment files from [%s]", new Object[]{path});
                    File dir = FileUtils.createTempDir();
                    DatasourceRecordReader.this.tmpSegmentDirs.add(dir);
                    logger.info("Locally storing fetched segment at [%s]", new Object[]{dir});
                    JobHelper.unzipNoGuava(path, context.getConfiguration(), dir, (Progressable)context, null);
                    logger.info("finished fetching segment files", new Object[0]);
                    QueryableIndex index = HadoopDruidIndexerConfig.INDEX_IO.loadIndex(dir);
                    DatasourceRecordReader.this.indexes.add(index);
                    DatasourceRecordReader.this.numRows += (long)index.getNumRows();
                    return new WindowedCursorFactory((CursorFactory)new QueryableIndexCursorFactory(index), segment.getInterval());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.segmentReader = new SegmentReader(adapters, this.spec.getTransformSpec(), this.spec.getDimensions(), this.spec.getMetrics(), this.spec.getFilter());
    }

    public boolean nextKeyValue() {
        if (this.segmentReader.hasMore()) {
            this.currRow = this.segmentReader.nextRow();
            ++this.rowNum;
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public InputRow getCurrentValue() {
        return this.currRow == null ? null : new SegmentInputRow(this.currRow, this.spec.getDimensions());
    }

    public float getProgress() {
        if (this.numRows > 0L) {
            return (float)this.rowNum * 1.0f / (float)this.numRows;
        }
        return 0.0f;
    }

    public void close() throws IOException {
        Closeables.close((Closeable)this.segmentReader, (boolean)true);
        for (QueryableIndex qi : this.indexes) {
            Closeables.close((Closeable)qi, (boolean)true);
        }
        for (File dir : this.tmpSegmentDirs) {
            FileUtils.deleteDirectory((File)dir);
        }
    }

    public static class SegmentReader
    implements Closeable {
        private final Transformer transformer;
        private Yielder<InputRow> rowYielder;

        public SegmentReader(List<WindowedCursorFactory> cursorFactories, TransformSpec transformSpec, final List<String> dims, final List<String> metrics, final DimFilter dimFilter) {
            this.transformer = transformSpec.toTransformer();
            Sequence rows = Sequences.concat((Iterable)Iterables.transform(cursorFactories, (Function)new Function<WindowedCursorFactory, Sequence<InputRow>>(){

                @Nullable
                public Sequence<InputRow> apply(WindowedCursorFactory windowed) {
                    CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(Filters.toFilter((DimFilter)dimFilter)).setInterval(windowed.getInterval()).build();
                    CursorHolder cursorHolder = windowed.getCursorFactory().makeCursorHolder(buildSpec);
                    final Cursor cursor = cursorHolder.asCursor();
                    if (cursor == null) {
                        return Sequences.empty();
                    }
                    ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                    HashMap<String, DimensionSelector> dimSelectors = new HashMap<String, DimensionSelector>();
                    for (String dim : dims) {
                        DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(dim, dim));
                        if (dimSelector == null) continue;
                        dimSelectors.put(dim, dimSelector);
                    }
                    HashMap<String, ColumnValueSelector> metSelectors = new HashMap<String, ColumnValueSelector>();
                    for (String metric : metrics) {
                        ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                        metSelectors.put(metric, metricSelector);
                    }
                    return Sequences.simple((Iterable)new Iterable<InputRow>(){
                        final /* synthetic */ BaseLongColumnValueSelector val$timestampColumnSelector;
                        final /* synthetic */ Map val$dimSelectors;
                        final /* synthetic */ Map val$metSelectors;
                        {
                            this.val$timestampColumnSelector = baseLongColumnValueSelector;
                            this.val$dimSelectors = map;
                            this.val$metSelectors = map2;
                        }

                        @Override
                        public Iterator<InputRow> iterator() {
                            return new Iterator<InputRow>(){

                                @Override
                                public boolean hasNext() {
                                    return !cursor.isDone();
                                }

                                @Override
                                public InputRow next() {
                                    DimensionSelector selector;
                                    LinkedHashMap theEvent = Maps.newLinkedHashMap();
                                    long timestamp = val$timestampColumnSelector.getLong();
                                    theEvent.put("timestamp", DateTimes.utc((long)timestamp));
                                    for (Map.Entry dimSelector : val$dimSelectors.entrySet()) {
                                        String dim = (String)dimSelector.getKey();
                                        selector = (DimensionSelector)dimSelector.getValue();
                                        IndexedInts vals = selector.getRow();
                                        int valsSize = vals.size();
                                        if (valsSize == 1) {
                                            String dimVal = selector.lookupName(vals.get(0));
                                            theEvent.put(dim, dimVal);
                                            continue;
                                        }
                                        if (valsSize <= 1) continue;
                                        ArrayList<String> dimVals = new ArrayList<String>(valsSize);
                                        for (int i = 0; i < valsSize; ++i) {
                                            dimVals.add(selector.lookupName(vals.get(i)));
                                        }
                                        theEvent.put(dim, dimVals);
                                    }
                                    for (Map.Entry metSelector : val$metSelectors.entrySet()) {
                                        String metric = (String)metSelector.getKey();
                                        selector = (BaseObjectColumnValueSelector)metSelector.getValue();
                                        Object value = selector.getObject();
                                        if (value == null) continue;
                                        theEvent.put(metric, value);
                                    }
                                    cursor.advance();
                                    return new MapBasedInputRow(timestamp, dims, (Map)theEvent);
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("Remove Not Supported");
                                }
                            };
                        }
                    }).withBaggage((Closeable)cursorHolder);
                }
            }));
            this.rowYielder = Yielders.each((Sequence)rows);
        }

        public boolean hasMore() {
            return !this.rowYielder.isDone();
        }

        @Nullable
        public InputRow nextRow() {
            InputRow inputRow = (InputRow)this.rowYielder.get();
            this.rowYielder = this.rowYielder.next(null);
            return this.transformer.transform(inputRow);
        }

        @Override
        public void close() throws IOException {
            this.rowYielder.close();
        }
    }
}

