/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CircularList<T>
implements Iterable<T> {
    private final List<T> elements = new ArrayList<T>();
    private int currentPosition;

    public CircularList(Set<T> elements, Comparator<? super T> comparator) {
        this.elements.addAll(elements);
        this.elements.sort(comparator);
        this.currentPosition = -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return CircularList.this.elements.size() > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advanceCursor();
                return CircularList.this.elements.get(CircularList.this.currentPosition);
            }

            private void advanceCursor() {
                if (++CircularList.this.currentPosition >= CircularList.this.elements.size()) {
                    CircularList.this.currentPosition = 0;
                }
            }
        };
    }

    public boolean equalsSet(Set<T> inputSet) {
        return new HashSet<T>(this.elements).equals(inputSet);
    }
}

