/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DelegatingBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueLongColumnValueSelector;

public class ObjectColumnLongBufferAggregatorWrapper
extends DelegatingBufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final long nullValue;
    private final SettableValueLongColumnValueSelector longSelector = new SettableValueLongColumnValueSelector();

    public ObjectColumnLongBufferAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseLongColumnValueSelector, BufferAggregator> delegateBuilder, long nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.longSelector);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null) {
            this.longSelector.setValue(this.nullValue);
            this.delegate.aggregate(buf, position);
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.longSelector.setValue(Numbers.tryParseLong(o, this.nullValue));
                this.delegate.aggregate(buf, position);
            }
        } else {
            this.longSelector.setValue(Numbers.tryParseLong(update, this.nullValue));
            this.delegate.aggregate(buf, position);
        }
    }
}

