/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.DimensionComparisonUtils;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.ValueType;

@NotThreadSafe
public class FixedWidthGroupByColumnSelectorStrategy<T>
implements GroupByColumnSelectorStrategy {
    final int keySizeBytes;
    final ColumnType columnType;
    final NullableTypeStrategy<T> nullableTypeStrategy;
    final Function<ColumnValueSelector<?>, T> valueGetter;
    final Function<ColumnValueSelector<?>, Boolean> nullityGetter;

    public FixedWidthGroupByColumnSelectorStrategy(int keySizeBytes, ColumnType columnType, Function<ColumnValueSelector<?>, T> valueGetter, Function<ColumnValueSelector<?>, Boolean> nullityGetter) {
        this.keySizeBytes = keySizeBytes;
        this.columnType = columnType;
        this.nullableTypeStrategy = columnType.getNullableStrategy();
        this.valueGetter = valueGetter;
        this.nullityGetter = nullityGetter;
    }

    @Override
    public int getGroupingKeySizeBytes() {
        return this.keySizeBytes;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        resultRow.set(selectorPlus.getResultRowPosition(), this.nullableTypeStrategy.read(key, keyBufferPosition));
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        valuess[columnIndex] = this.getValue(selector);
        return 0;
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        int written;
        if (rowObj == null) {
            written = this.nullableTypeStrategy.write(keyBuffer, keyBufferPosition, null, this.keySizeBytes);
            stack[dimensionIndex] = 0;
        } else {
            written = this.nullableTypeStrategy.write(keyBuffer, keyBufferPosition, rowObj, this.keySizeBytes);
            stack[dimensionIndex] = 1;
        }
        if (written < 0) {
            throw DruidException.defensive("Unable to serialize the value [%s] to buffer", rowObj);
        }
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        T value = this.getValue(selector);
        int written = this.nullableTypeStrategy.write(keyBuffer, keyBufferPosition, value, this.keySizeBytes);
        if (written < 0) {
            throw DruidException.defensive("Unable to serialize the value [%s] to buffer", value);
        }
        return 0;
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            T lhs = this.nullableTypeStrategy.read(lhsBuffer, lhsPosition + keyBufferPosition);
            T rhs = this.nullableTypeStrategy.read(rhsBuffer, rhsPosition + keyBufferPosition);
            if (stringComparator != null && !DimensionComparisonUtils.isNaturalComparator((ValueType)this.columnType.getType(), stringComparator)) {
                return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
            }
            return this.nullableTypeStrategy.compare(lhs, rhs);
        };
    }

    @Override
    public void reset() {
    }

    @Nullable
    private T getValue(ColumnValueSelector columnValueSelector) {
        if (this.nullityGetter.apply(columnValueSelector).booleanValue()) {
            return null;
        }
        return this.valueGetter.apply(columnValueSelector);
    }
}

