/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.rowsandcols.CursorFactoryRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.WrappedTimeBoundaryInspector;
import org.apache.druid.segment.join.HashJoinSegmentCursorFactory;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class HashJoinSegment
implements Segment {
    private static final Logger log = new Logger(HashJoinSegment.class);
    private final Segment baseSegment;
    private final Closeable referenceCloseable;
    @Nullable
    private final Filter baseFilter;
    private final List<JoinableClause> clauses;
    private final JoinFilterPreAnalysis joinFilterPreAnalysis;

    public HashJoinSegment(Segment baseSegment, @Nullable Filter baseFilter, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis, Closeable referenceCloseable) {
        this.baseSegment = baseSegment;
        this.baseFilter = baseFilter;
        this.clauses = clauses;
        this.joinFilterPreAnalysis = joinFilterPreAnalysis;
        this.referenceCloseable = referenceCloseable;
        if (clauses.isEmpty() && baseFilter == null) {
            CloseableUtils.closeAndWrapExceptions(this);
            throw new IAE("'clauses' and 'baseFilter' are both empty, no need to create HashJoinSegment", new Object[0]);
        }
    }

    @Override
    public SegmentId getId() {
        return this.baseSegment.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.baseSegment.getDataInterval();
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)new HashJoinSegmentCursorFactory(this.baseSegment.as(CursorFactory.class), this.baseFilter, this.clauses, this.joinFilterPreAnalysis);
        }
        if (CloseableShapeshifter.class.equals(clazz)) {
            return (T)new CursorFactoryRowsAndColumns(this.as(CursorFactory.class));
        }
        if (TimeBoundaryInspector.class.equals(clazz)) {
            return (T)WrappedTimeBoundaryInspector.create(this.baseSegment.as(TimeBoundaryInspector.class));
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(this.baseFilter == null && this.clauses.stream().allMatch(clause -> clause.getJoinType().isLefty() || clause.getCondition().isAlwaysTrue()));
        }
        return null;
    }

    @Override
    public void validateOrElseThrow(PolicyEnforcer policyEnforcer) {
        this.baseSegment.validateOrElseThrow(policyEnforcer);
    }

    @Override
    public String getDebugString() {
        return "join->" + this.baseSegment.getDebugString();
    }

    @Override
    public void close() throws IOException {
        this.baseSegment.close();
        this.referenceCloseable.close();
    }
}

