/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class DataSourcesSnapshot {
    private final DateTime snapshotTime;
    private final Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments;
    private final Map<String, SegmentTimeline> usedSegmentsTimelinesPerDataSource;
    private final ImmutableSet<DataSegment> overshadowedSegments;

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments) {
        return DataSourcesSnapshot.fromUsedSegments(segments, DateTimes.nowUtc());
    }

    public static DataSourcesSnapshot fromUsedSegments(Map<String, Set<DataSegment>> datasourceToUsedSegments, DateTime snapshotTime) {
        Map<String, String> properties = Map.of("created", snapshotTime.toString());
        HashMap<String, ImmutableDruidDataSource> dataSources = new HashMap<String, ImmutableDruidDataSource>();
        datasourceToUsedSegments.forEach((dataSource, segments) -> dataSources.put((String)dataSource, new ImmutableDruidDataSource((String)dataSource, properties, (Collection<DataSegment>)segments)));
        return new DataSourcesSnapshot(snapshotTime, dataSources);
    }

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments, DateTime snapshotTime) {
        ImmutableMap dataSourceProperties = ImmutableMap.of((Object)"created", (Object)DateTimes.nowUtc().toString());
        HashMap dataSources = new HashMap();
        segments.forEach(arg_0 -> DataSourcesSnapshot.lambda$fromUsedSegments$2(dataSources, (Map)dataSourceProperties, arg_0));
        return new DataSourcesSnapshot(snapshotTime, CollectionUtils.mapValues(dataSources, DruidDataSource::toImmutableDruidDataSource));
    }

    private DataSourcesSnapshot(DateTime snapshotTime, Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments) {
        this.snapshotTime = snapshotTime;
        this.dataSourcesWithAllUsedSegments = dataSourcesWithAllUsedSegments;
        this.usedSegmentsTimelinesPerDataSource = CollectionUtils.mapValues(dataSourcesWithAllUsedSegments, dataSource -> SegmentTimeline.forSegments(dataSource.getSegments()));
        this.overshadowedSegments = ImmutableSet.copyOf(this.determineOvershadowedSegments());
    }

    public DateTime getSnapshotTime() {
        return this.snapshotTime;
    }

    public Collection<ImmutableDruidDataSource> getDataSourcesWithAllUsedSegments() {
        return this.dataSourcesWithAllUsedSegments.values();
    }

    public Map<String, ImmutableDruidDataSource> getDataSourcesMap() {
        return this.dataSourcesWithAllUsedSegments;
    }

    @Nullable
    public ImmutableDruidDataSource getDataSource(String dataSourceName) {
        return this.dataSourcesWithAllUsedSegments.get(dataSourceName);
    }

    public Map<String, SegmentTimeline> getUsedSegmentsTimelinesPerDataSource() {
        return this.usedSegmentsTimelinesPerDataSource;
    }

    public ImmutableSet<DataSegment> getOvershadowedSegments() {
        return this.overshadowedSegments;
    }

    public Set<DataSegment> getAllUsedNonOvershadowedSegments(String dataSource, Interval interval) {
        SegmentTimeline timeline = this.usedSegmentsTimelinesPerDataSource.get(dataSource);
        if (timeline == null) {
            return Set.of();
        }
        return timeline.findNonOvershadowedObjectsInInterval(interval, Partitions.ONLY_COMPLETE);
    }

    public Iterable<DataSegment> iterateAllUsedSegmentsInSnapshot() {
        return () -> this.dataSourcesWithAllUsedSegments.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    private List<DataSegment> determineOvershadowedSegments() {
        ArrayList<DataSegment> overshadowedSegments = new ArrayList<DataSegment>();
        for (ImmutableDruidDataSource dataSource : this.dataSourcesWithAllUsedSegments.values()) {
            SegmentTimeline usedSegmentsTimeline = this.usedSegmentsTimelinesPerDataSource.get(dataSource.getName());
            for (DataSegment segment : dataSource.getSegments()) {
                if (!usedSegmentsTimeline.isOvershadowed(segment)) continue;
                overshadowedSegments.add(segment);
            }
        }
        return overshadowedSegments;
    }

    private static /* synthetic */ void lambda$fromUsedSegments$2(Map dataSources, Map dataSourceProperties, DataSegment segment) {
        dataSources.computeIfAbsent(segment.getDataSource(), dsName -> new DruidDataSource((String)dsName, dataSourceProperties)).addSegmentIfAbsent(segment);
    }
}

