/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentCountsPerInterval {
    private int totalSegments;
    private long totalSegmentBytes;
    private final Map<String, Object2IntMap<Interval>> datasourceIntervalToSegmentCount = new HashMap<String, Object2IntMap<Interval>>();
    private final Object2IntMap<Interval> intervalToTotalSegmentCount = new Object2IntOpenHashMap();
    private final Object2IntMap<String> datasourceToTotalSegmentCount = new Object2IntOpenHashMap();

    public void addSegment(DataSegment segment) {
        this.updateCountInInterval(segment, 1);
        this.totalSegmentBytes += segment.getSize();
    }

    public void removeSegment(DataSegment segment) {
        this.updateCountInInterval(segment, -1);
        this.totalSegmentBytes -= segment.getSize();
    }

    public int getTotalSegmentCount() {
        return this.totalSegments;
    }

    public long getTotalSegmentBytes() {
        return this.totalSegmentBytes;
    }

    public Object2IntMap<String> getDatasourceToTotalSegmentCount() {
        return this.datasourceToTotalSegmentCount;
    }

    public Object2IntMap<Interval> getIntervalToSegmentCount(String datasource) {
        return this.datasourceIntervalToSegmentCount.getOrDefault(datasource, (Object2IntMap<Interval>)Object2IntMaps.emptyMap());
    }

    public Object2IntMap<Interval> getIntervalToTotalSegmentCount() {
        return this.intervalToTotalSegmentCount;
    }

    private void updateCountInInterval(DataSegment segment, int delta) {
        this.totalSegments += delta;
        this.intervalToTotalSegmentCount.mergeInt((Object)segment.getInterval(), delta, Integer::sum);
        this.datasourceToTotalSegmentCount.mergeInt((Object)segment.getDataSource(), delta, Integer::sum);
        this.datasourceIntervalToSegmentCount.computeIfAbsent(segment.getDataSource(), ds -> new Object2IntOpenHashMap()).mergeInt((Object)segment.getInterval(), delta, Integer::sum);
    }
}

