/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.RetryableException;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;

public class KillCompactionConfig
extends MetadataCleanupDuty {
    private static final Logger log = new Logger(KillCompactionConfig.class);
    private static final int UPDATE_NUM_RETRY = 5;
    private final IndexerMetadataStorageCoordinator storageCoordinator;
    private final CoordinatorConfigManager configManager;

    public KillCompactionConfig(MetadataCleanupConfig config, IndexerMetadataStorageCoordinator storageCoordinator, CoordinatorConfigManager configManager) {
        super("compaction configs", config, Stats.Kill.COMPACTION_CONFIGS);
        this.storageCoordinator = storageCoordinator;
        this.configManager = configManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        try {
            return (Integer)RetryUtils.retry(this::tryDeleteCompactionConfigs, e -> e instanceof RetryableException, (int)5);
        }
        catch (Exception e2) {
            log.error((Throwable)e2, "Failed to kill compaction configurations", new Object[0]);
            return 0;
        }
    }

    private DruidCompactionConfig deleteConfigsForInactiveDatasources(DruidCompactionConfig current) {
        if (DruidCompactionConfig.empty().equals(current)) {
            return current;
        }
        Set<String> activeDatasources = this.storageCoordinator.retrieveAllDatasourceNames();
        Map updated = current.getCompactionConfigs().stream().filter(dataSourceCompactionConfig -> activeDatasources.contains(dataSourceCompactionConfig.getDataSource())).collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        return current.withDatasourceConfigs((List<DataSourceCompactionConfig>)ImmutableList.copyOf(updated.values()));
    }

    private int tryDeleteCompactionConfigs() throws RetryableException {
        AtomicInteger compactionConfigRemoved = new AtomicInteger(0);
        ConfigManager.SetResult result = this.configManager.getAndUpdateCompactionConfig(current -> {
            DruidCompactionConfig updated = this.deleteConfigsForInactiveDatasources((DruidCompactionConfig)current);
            int numCurrentConfigs = current.getCompactionConfigs() == null ? 0 : current.getCompactionConfigs().size();
            int numUpdatedConfigs = updated.getCompactionConfigs() == null ? 0 : updated.getCompactionConfigs().size();
            compactionConfigRemoved.set(Math.max(0, numCurrentConfigs - numUpdatedConfigs));
            return updated;
        }, new AuditInfo("KillCompactionConfig", "KillCompactionConfig", "CoordinatorDuty for automatic deletion of compaction config", ""));
        if (result.isOk()) {
            return compactionConfigRemoved.get();
        }
        if (result.isRetryable()) {
            throw new RetryableException((Throwable)result.getException());
        }
        log.error((Throwable)result.getException(), "Failed to kill compaction configurations", new Object[0]);
        return 0;
    }
}

