/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class ResponseCookieHandler<Intermediate, Final>
implements HttpResponseHandler<Intermediate, Final> {
    private static final Logger log = new Logger(ResponseCookieHandler.class);
    private final URI uri;
    private final CookieManager manager;
    private final HttpResponseHandler<Intermediate, Final> delegate;

    public ResponseCookieHandler(URI uri, CookieManager manager, HttpResponseHandler<Intermediate, Final> delegate) {
        this.uri = uri;
        this.manager = manager;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResponse<Intermediate> handleResponse(HttpResponse httpResponse, HttpResponseHandler.TrafficCop trafficCop) {
        try {
            final HttpHeaders headers = httpResponse.headers();
            this.manager.put(this.uri, Maps.asMap((Set)headers.names(), (Function)new Function<String, List<String>>(){

                public List<String> apply(String input) {
                    return headers.getAll(input);
                }
            }));
        }
        catch (IOException e) {
            log.error((Throwable)e, "Error while processing Cookies from header", new Object[0]);
        }
        finally {
            return this.delegate.handleResponse(httpResponse, trafficCop);
        }
    }

    public ClientResponse<Intermediate> handleChunk(ClientResponse<Intermediate> clientResponse, HttpChunk httpChunk, long chunkNum) {
        return this.delegate.handleChunk(clientResponse, httpChunk, chunkNum);
    }

    public ClientResponse<Final> done(ClientResponse<Intermediate> clientResponse) {
        return this.delegate.done(clientResponse);
    }

    public void exceptionCaught(ClientResponse<Intermediate> clientResponse, Throwable throwable) {
        this.delegate.exceptionCaught(clientResponse, throwable);
    }
}

