/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.common.task.Task;
import org.joda.time.Duration;

public class ClusterTestingTaskConfig {
    public static final ClusterTestingTaskConfig DEFAULT = new ClusterTestingTaskConfig(null, null, null, null);
    private final MetadataConfig metadataConfig;
    private final OverlordClientConfig overlordClientConfig;
    private final CoordinatorClientConfig coordinatorClientConfig;
    private final TaskActionClientConfig taskActionClientConfig;

    @JsonCreator
    public ClusterTestingTaskConfig(@JsonProperty(value="metadataConfig") @Nullable MetadataConfig metadataConfig, @JsonProperty(value="overlordClientConfig") @Nullable OverlordClientConfig overlordClientConfig, @JsonProperty(value="coordinatorClientConfig") @Nullable CoordinatorClientConfig coordinatorClientConfig, @JsonProperty(value="taskActionClientConfig") @Nullable TaskActionClientConfig taskActionClientConfig) {
        this.metadataConfig = (MetadataConfig)Configs.valueOrDefault((Object)metadataConfig, (Object)MetadataConfig.DEFAULT);
        this.overlordClientConfig = (OverlordClientConfig)Configs.valueOrDefault((Object)overlordClientConfig, (Object)OverlordClientConfig.DEFAULT);
        this.coordinatorClientConfig = (CoordinatorClientConfig)Configs.valueOrDefault((Object)coordinatorClientConfig, (Object)CoordinatorClientConfig.DEFAULT);
        this.taskActionClientConfig = (TaskActionClientConfig)Configs.valueOrDefault((Object)taskActionClientConfig, (Object)TaskActionClientConfig.DEFAULT);
    }

    public static ClusterTestingTaskConfig forTask(Task task, ObjectMapper mapper) throws JsonProcessingException {
        Map configAsMap = (Map)task.getContextValue("clusterTesting");
        String json = mapper.writeValueAsString((Object)configAsMap);
        ClusterTestingTaskConfig config = (ClusterTestingTaskConfig)mapper.readValue(json, ClusterTestingTaskConfig.class);
        return (ClusterTestingTaskConfig)Configs.valueOrDefault((Object)config, (Object)DEFAULT);
    }

    public MetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    public OverlordClientConfig getOverlordClientConfig() {
        return this.overlordClientConfig;
    }

    public CoordinatorClientConfig getCoordinatorClientConfig() {
        return this.coordinatorClientConfig;
    }

    public TaskActionClientConfig getTaskActionClientConfig() {
        return this.taskActionClientConfig;
    }

    public String toString() {
        return "{overlordClientConfig=" + String.valueOf(this.overlordClientConfig) + ", coordinatorClientConfig=" + String.valueOf(this.coordinatorClientConfig) + ", taskActionClientConfig=" + String.valueOf(this.taskActionClientConfig) + "}";
    }

    public static class MetadataConfig {
        private static final MetadataConfig DEFAULT = new MetadataConfig(null);
        private final boolean cleanupPendingSegments;

        @JsonCreator
        public MetadataConfig(@JsonProperty(value="cleanupPendingSegments") @Nullable Boolean cleanupPendingSegments) {
            this.cleanupPendingSegments = Configs.valueOrDefault((Boolean)cleanupPendingSegments, (boolean)true);
        }

        public boolean isCleanupPendingSegments() {
            return this.cleanupPendingSegments;
        }
    }

    public static class OverlordClientConfig {
        private static final OverlordClientConfig DEFAULT = new OverlordClientConfig();

        public String toString() {
            return "";
        }
    }

    public static class CoordinatorClientConfig {
        private static final CoordinatorClientConfig DEFAULT = new CoordinatorClientConfig(null);
        private final Duration minSegmentHandoffDelay;

        @JsonCreator
        public CoordinatorClientConfig(@JsonProperty(value="minSegmentHandoffDelay") @Nullable Duration minSegmentHandoffDelay) {
            this.minSegmentHandoffDelay = minSegmentHandoffDelay;
        }

        @Nullable
        public Duration getMinSegmentHandoffDelay() {
            return this.minSegmentHandoffDelay;
        }

        public String toString() {
            return "{minSegmentHandoffDelay=" + String.valueOf(this.minSegmentHandoffDelay) + "}";
        }
    }

    public static class TaskActionClientConfig {
        private static final TaskActionClientConfig DEFAULT = new TaskActionClientConfig(null, null);
        private final Duration segmentPublishDelay;
        private final Duration segmentAllocateDelay;

        @JsonCreator
        public TaskActionClientConfig(@JsonProperty(value="segmentAllocateDelay") @Nullable Duration segmentAllocateDelay, @JsonProperty(value="segmentPublishDelay") @Nullable Duration segmentPublishDelay) {
            this.segmentAllocateDelay = segmentAllocateDelay;
            this.segmentPublishDelay = segmentPublishDelay;
        }

        @Nullable
        public Duration getSegmentPublishDelay() {
            return this.segmentPublishDelay;
        }

        @Nullable
        public Duration getSegmentAllocateDelay() {
            return this.segmentAllocateDelay;
        }

        public String toString() {
            return "{segmentPublishDelay=" + String.valueOf(this.segmentPublishDelay) + ", segmentAllocateDelay=" + String.valueOf(this.segmentAllocateDelay) + "}";
        }
    }
}

