/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.generator.DataGenerator;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;

public class GeneratorInputSource
extends AbstractInputSource
implements SplittableInputSource<Long> {
    private static final int DEFAULT_NUM_ROWS = 1000;
    private static final int DEFAULT_NUM_SPLITS = 1;
    private static final long DEFAULT_SEED = 1024L;
    private static final long DEFAULT_START_TIME = DateTimes.nowUtc().minusDays(1).getMillis();
    private static final int DEFAULT_CONSECUTIVE_TIMESTAMPS = 100;
    private static final double DEFAULT_TIMESTAMP_INCREMENT = 1.0;
    private final String schemaName;
    private final List<GeneratorColumnSchema> schema;
    private final int numRows;
    private final Integer numSplits;
    private final Long seed;
    private final Long startTime;
    private final Integer numConsecutiveTimestamps;
    private final Double timestampIncrement;

    @JsonCreator
    public GeneratorInputSource(@JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="schema") @Nullable List<GeneratorColumnSchema> schema, @JsonProperty(value="numRows") Integer numRows, @JsonProperty(value="numSplits") Integer numSplits, @JsonProperty(value="seed") Long seed, @JsonProperty(value="startTime") Long startTime, @JsonProperty(value="numConsecutiveTimestamps") Integer numConsecutiveTimestamps, @JsonProperty(value="timestampIncrement") Double timestampIncrement) {
        Preconditions.checkArgument((schemaName != null || schema != null ? 1 : 0) != 0, (Object)"Must specify either 'schemaName' or 'schema'");
        this.schemaName = schemaName;
        this.schema = schema != null ? schema : ((GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get(schemaName)).getColumnSchemas();
        this.numRows = numRows != null ? numRows : 1000;
        this.numSplits = numSplits != null ? numSplits : 1;
        this.seed = seed != null ? seed : 1024L;
        this.startTime = startTime != null ? startTime : DEFAULT_START_TIME;
        this.numConsecutiveTimestamps = numConsecutiveTimestamps != null ? numConsecutiveTimestamps : 100;
        this.timestampIncrement = timestampIncrement != null ? timestampIncrement : 1.0;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton("generator");
    }

    public Stream<InputSplit<Long>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        Random r = new Random(this.seed);
        return LongStream.range(0L, this.numSplits.intValue()).mapToObj(i -> new InputSplit((Object)r.nextLong()));
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.numSplits;
    }

    public InputSource withSplit(InputSplit<Long> split) {
        return new GeneratorInputSource(this.schemaName, this.schema, this.numRows, 1, (Long)split.get(), this.startTime, this.numConsecutiveTimestamps, this.timestampIncrement);
    }

    public boolean needsFormat() {
        return false;
    }

    protected InputSourceReader fixedFormatReader(final InputRowSchema inputRowSchema, @Nullable File temporaryDirectory) {
        return new InputSourceReader(){

            public CloseableIterator<InputRow> read(InputStats inputStats) {
                return CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRow>(){
                    int rowCount = 0;
                    private final DataGenerator generator;
                    {
                        this.generator = GeneratorInputSource.this.makeGenerator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rowCount < GeneratorInputSource.this.numRows;
                    }

                    @Override
                    public InputRow next() {
                        ++this.rowCount;
                        return MapInputRowParser.parse((InputRowSchema)inputRowSchema, (Map)this.generator.nextRaw(inputRowSchema.getTimestampSpec().getTimestampColumn()));
                    }
                });
            }

            public CloseableIterator<InputRowListPlusRawValues> sample() {
                return CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRowListPlusRawValues>(){
                    int rowCount = 0;
                    private final DataGenerator generator;
                    {
                        this.generator = GeneratorInputSource.this.makeGenerator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rowCount < GeneratorInputSource.this.numRows;
                    }

                    @Override
                    public InputRowListPlusRawValues next() {
                        ++this.rowCount;
                        InputRow row = this.generator.nextRow();
                        return InputRowListPlusRawValues.of((InputRow)row, (Map)((MapBasedInputRow)row).getEvent());
                    }
                });
            }
        };
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public List<GeneratorColumnSchema> getSchema() {
        return this.schemaName == null ? this.schema : null;
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public Integer getNumSplits() {
        return this.numSplits;
    }

    @JsonProperty
    public Long getSeed() {
        return this.seed;
    }

    @JsonProperty
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Integer getNumConsecutiveTimestamps() {
        return this.numConsecutiveTimestamps;
    }

    @JsonProperty
    public Double getTimestampIncrement() {
        return this.timestampIncrement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GeneratorInputSource that = (GeneratorInputSource)((Object)o);
        return this.numRows == that.numRows && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.schema, that.schema) && Objects.equals(this.numSplits, that.numSplits) && Objects.equals(this.seed, that.seed) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.numConsecutiveTimestamps, that.numConsecutiveTimestamps) && Objects.equals(this.timestampIncrement, that.timestampIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.schema, this.numRows, this.numSplits, this.seed, this.startTime, this.numConsecutiveTimestamps, this.timestampIncrement);
    }

    private DataGenerator makeGenerator() {
        return new DataGenerator(this.schema, this.seed.longValue(), this.startTime.longValue(), this.numConsecutiveTimestamps.intValue(), this.timestampIncrement);
    }
}

