/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;
import org.joda.time.Period;

public class RemoteTaskRunnerConfig
extends WorkerTaskRunnerConfig {
    @JsonProperty
    @NotNull
    private Period taskAssignmentTimeout = new Period((Object)"PT5M");
    @JsonProperty
    @NotNull
    private Period taskCleanupTimeout = new Period((Object)"PT15M");
    @JsonProperty
    @HumanReadableBytesRange(min=10240L, max=0x7FFFFFFFL, message="maxZnodeBytes must be in the range of [10KiB, 2GiB)")
    private HumanReadableBytes maxZnodeBytes = HumanReadableBytes.valueOf((int)524288);
    @JsonProperty
    private Period taskShutdownLinkTimeout = new Period((Object)"PT1M");
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int pendingTasksRunnerNumThreads = 1;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int maxRetriesBeforeBlacklist = 5;
    @JsonProperty
    @NotNull
    private Period workerBlackListBackoffTime = new Period((Object)"PT15M");
    @JsonProperty
    @NotNull
    private Period workerBlackListCleanupPeriod = new Period((Object)"PT5M");
    @JsonProperty
    @Max(value=100L)
    @Min(value=0L)
    private @Max(value=100L) @Min(value=0L) int maxPercentageBlacklistWorkers = 20;

    public Period getTaskAssignmentTimeout() {
        return this.taskAssignmentTimeout;
    }

    public Period getTaskCleanupTimeout() {
        return this.taskCleanupTimeout;
    }

    public int getMaxZnodeBytes() {
        return this.maxZnodeBytes.getBytesInInt();
    }

    public Period getTaskShutdownLinkTimeout() {
        return this.taskShutdownLinkTimeout;
    }

    public int getPendingTasksRunnerNumThreads() {
        return this.pendingTasksRunnerNumThreads;
    }

    public int getMaxRetriesBeforeBlacklist() {
        return this.maxRetriesBeforeBlacklist;
    }

    public Period getWorkerBlackListBackoffTime() {
        return this.workerBlackListBackoffTime;
    }

    public Period getWorkerBlackListCleanupPeriod() {
        return this.workerBlackListCleanupPeriod;
    }

    public int getMaxPercentageBlacklistWorkers() {
        return this.maxPercentageBlacklistWorkers;
    }

    public void setMaxPercentageBlacklistWorkers(int maxPercentageBlacklistWorkers) {
        this.maxPercentageBlacklistWorkers = maxPercentageBlacklistWorkers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTaskRunnerConfig that = (RemoteTaskRunnerConfig)o;
        if (!this.maxZnodeBytes.equals((Object)that.maxZnodeBytes)) {
            return false;
        }
        if (this.pendingTasksRunnerNumThreads != that.pendingTasksRunnerNumThreads) {
            return false;
        }
        if (!this.taskAssignmentTimeout.equals((Object)that.taskAssignmentTimeout)) {
            return false;
        }
        if (!this.taskCleanupTimeout.equals((Object)that.taskCleanupTimeout)) {
            return false;
        }
        if (!this.getMinWorkerVersion().equals(that.getMinWorkerVersion())) {
            return false;
        }
        if (!this.taskShutdownLinkTimeout.equals((Object)that.taskShutdownLinkTimeout)) {
            return false;
        }
        if (this.maxRetriesBeforeBlacklist != that.maxRetriesBeforeBlacklist) {
            return false;
        }
        if (!this.workerBlackListBackoffTime.equals((Object)that.getWorkerBlackListBackoffTime())) {
            return false;
        }
        if (this.maxPercentageBlacklistWorkers != that.maxPercentageBlacklistWorkers) {
            return false;
        }
        return this.workerBlackListCleanupPeriod.equals((Object)that.workerBlackListCleanupPeriod);
    }

    public int hashCode() {
        int result = this.taskAssignmentTimeout.hashCode();
        result = 31 * result + this.taskCleanupTimeout.hashCode();
        result = 31 * result + this.getMinWorkerVersion().hashCode();
        result = 31 * result + this.maxZnodeBytes.hashCode();
        result = 31 * result + this.taskShutdownLinkTimeout.hashCode();
        result = 31 * result + this.pendingTasksRunnerNumThreads;
        result = 31 * result + this.maxRetriesBeforeBlacklist;
        result = 31 * result + this.workerBlackListBackoffTime.hashCode();
        result = 31 * result + this.workerBlackListCleanupPeriod.hashCode();
        result = 31 * result + this.maxPercentageBlacklistWorkers;
        return result;
    }

    public String toString() {
        return "RemoteTaskRunnerConfig{taskAssignmentTimeout=" + String.valueOf(this.taskAssignmentTimeout) + ", taskCleanupTimeout=" + String.valueOf(this.taskCleanupTimeout) + ", minWorkerVersion='" + this.getMinWorkerVersion() + "', maxZnodeBytes=" + String.valueOf(this.maxZnodeBytes) + ", taskShutdownLinkTimeout=" + String.valueOf(this.taskShutdownLinkTimeout) + ", pendingTasksRunnerNumThreads=" + this.pendingTasksRunnerNumThreads + ", maxRetriesBeforeBlacklist=" + this.maxRetriesBeforeBlacklist + ", taskBlackListBackoffTimeMillis=" + String.valueOf(this.workerBlackListBackoffTime) + ", taskBlackListCleanupPeriod=" + String.valueOf(this.workerBlackListCleanupPeriod) + ", maxPercentageBlacklistWorkers= " + this.maxPercentageBlacklistWorkers + "}";
    }
}

