/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.Objects;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.mutable.MutableBiRel;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class MutableCorrelate
extends MutableBiRel {
    public final CorrelationId correlationId;
    public final ImmutableBitSet requiredColumns;
    public final JoinRelType joinType;

    private MutableCorrelate(RelDataType rowType, MutableRel left, MutableRel right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        super(MutableRelType.CORRELATE, left.cluster, rowType, left, right);
        this.correlationId = correlationId;
        this.requiredColumns = requiredColumns;
        this.joinType = joinType;
    }

    public static MutableCorrelate of(RelDataType rowType, MutableRel left, MutableRel right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        return new MutableCorrelate(rowType, left, right, correlationId, requiredColumns, joinType);
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof MutableCorrelate && this.correlationId.equals(((MutableCorrelate)obj).correlationId) && this.requiredColumns.equals(((MutableCorrelate)obj).requiredColumns) && this.joinType == ((MutableCorrelate)obj).joinType && this.left.equals(((MutableCorrelate)obj).left) && this.right.equals(((MutableCorrelate)obj).right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.correlationId, this.requiredColumns, this.joinType});
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Correlate(correlationId: ").append(this.correlationId).append(", requiredColumns: ").append(this.requiredColumns).append(", joinType: ").append((Object)this.joinType).append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableCorrelate.of(this.rowType, this.left.clone(), this.right.clone(), this.correlationId, this.requiredColumns, this.joinType);
    }
}

