/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.base;

import java.util.Arrays;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public class EncryptionKey
extends KrbSequenceType {
    private int kvno = -1;
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(EncryptionKeyField.KEY_TYPE, Asn1Integer.class), new ExplicitField(EncryptionKeyField.KEY_VALUE, Asn1OctetString.class)};

    public EncryptionKey() {
        super(fieldInfos);
    }

    public EncryptionKey(int keyType, byte[] keyData) {
        this(keyType, keyData, -1);
    }

    public EncryptionKey(int keyType, byte[] keyData, int kvno) {
        this(EncryptionType.fromValue(keyType), keyData, kvno);
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyData) {
        this(keyType, keyData, -1);
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyData, int kvno) {
        this();
        this.setKeyType(keyType);
        this.setKeyData(keyData);
        this.setKvno(kvno);
    }

    public EncryptionType getKeyType() {
        Integer value = this.getFieldAsInteger(EncryptionKeyField.KEY_TYPE);
        return EncryptionType.fromValue(value);
    }

    public void setKeyType(EncryptionType keyType) {
        this.setFieldAsInt((EnumType)EncryptionKeyField.KEY_TYPE, keyType.getValue());
    }

    public byte[] getKeyData() {
        return this.getFieldAsOctets(EncryptionKeyField.KEY_VALUE);
    }

    public void setKeyData(byte[] keyData) {
        this.setFieldAsOctets(EncryptionKeyField.KEY_VALUE, keyData);
    }

    public void setKvno(int kvno) {
        this.kvno = kvno;
    }

    public int getKvno() {
        return this.kvno;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        if (this.kvno != -1 && that.kvno != -1 && this.kvno != that.kvno) {
            return false;
        }
        if (this.getKeyType() != that.getKeyType()) {
            return false;
        }
        return Arrays.equals(this.getKeyData(), that.getKeyData());
    }

    public int hashCode() {
        int result = this.kvno;
        if (this.getKeyType() != null) {
            result = 31 * result + this.getKeyType().hashCode();
        }
        if (this.getKeyData() != null) {
            result = 31 * result + Arrays.hashCode(this.getKeyData());
        }
        return result;
    }

    protected static enum EncryptionKeyField implements EnumType
    {
        KEY_TYPE,
        KEY_VALUE;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

