/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropMaterializedTable
extends SqlDrop {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP MATERIALIZED TABLE", SqlKind.DROP_TABLE);
    private final SqlIdentifier tableIdentifier;

    public SqlDropMaterializedTable(SqlParserPos pos, SqlIdentifier tableIdentifier, boolean ifExists) {
        super(OPERATOR, pos, ifExists);
        this.tableIdentifier = tableIdentifier;
    }

    public String[] fullTableName() {
        return this.tableIdentifier.names.toArray(new String[0]);
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableIdentifier);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP MATERIALIZED TABLE");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
    }
}

