/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.sink.StreamRecordTimestampInserter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@ExecNodeMetadata(name="batch-exec-match", version=1, producedTransformations={"timestamp-inserter", "match"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecMatch
extends CommonExecMatch
implements BatchExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    public BatchExecMatch(ReadableConfig tableConfig, MatchSpec matchSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecMatch.class), ExecNodeContext.newPersistedConfig(BatchExecMatch.class, tableConfig), matchSpec, Collections.singletonList(inputProperty), (LogicalType)outputType, description);
    }

    @JsonCreator
    public BatchExecMatch(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="matchSpec") MatchSpec matchSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, matchSpec, inputProperties, (LogicalType)outputType, description);
    }

    @Override
    public void checkOrderKeys(RowType inputRowType) {
        SortSpec orderKeys = this.matchSpec.getOrderKeys();
        if (orderKeys.getFieldSize() == 0) {
            throw new TableException("You must specify non-empty order by.");
        }
        SortSpec.SortFieldSpec timeOrderField = orderKeys.getFieldSpec(0);
        int timeOrderFieldIdx = timeOrderField.getFieldIndex();
        LogicalType timeOrderFieldType = inputRowType.getTypeAt(timeOrderFieldIdx);
        if (!TypeCheckUtils.isTimePoint((LogicalType)timeOrderFieldType)) {
            throw new TableException("You must specify time point for order by as the first one.");
        }
        if (!orderKeys.getAscendingOrders()[0]) {
            throw new TableException("Primary sort order of a table must be ascending on time.");
        }
    }

    @Override
    protected Transformation<RowData> translateOrder(PlannerBase planner, Transformation<RowData> inputTransform, RowType inputRowType, ExecEdge inputEdge, ExecNodeConfig config) {
        if (this.isProcTime(inputRowType)) {
            return inputTransform;
        }
        SortSpec.SortFieldSpec timeOrderField = this.matchSpec.getOrderKeys().getFieldSpec(0);
        int timeOrderFieldIdx = timeOrderField.getFieldIndex();
        LogicalType timeOrderFieldType = inputRowType.getTypeAt(timeOrderFieldIdx);
        int precision = LogicalTypeChecks.getPrecision((LogicalType)timeOrderFieldType);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta("timestamp-inserter", String.format("BatchRecordTimestampInserter(timestamp field: %s)", timeOrderFieldIdx), "BatchRecordTimestampInserter", config), new StreamRecordTimestampInserter(timeOrderFieldIdx, precision), inputTransform.getOutputType(), inputTransform.getParallelism(), false);
        if (this.inputsContainSingleton()) {
            transform.setParallelism(1);
            transform.setMaxParallelism(1);
        }
        return transform;
    }
}

