/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface SchemaChange {
    public static SchemaChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static SchemaChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class SetProperty
    implements SchemaChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RemoveProperty
    implements SchemaChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }
}

