/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.mergetree.compact.aggregate.factory.FieldAggregatorFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.ArrayUtils;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Projection;

public class AggregateMergeFunction
implements MergeFunction<KeyValue> {
    private final InternalRow.FieldGetter[] getters;
    private final FieldAggregator[] aggregators;
    private final boolean[] nullables;
    private KeyValue latestKv;
    private GenericRow row;
    private KeyValue reused;
    private boolean currentDeleteRow;
    private final boolean removeRecordOnDelete;

    public AggregateMergeFunction(InternalRow.FieldGetter[] getters, FieldAggregator[] aggregators, boolean removeRecordOnDelete, boolean[] nullables) {
        this.getters = getters;
        this.aggregators = aggregators;
        this.removeRecordOnDelete = removeRecordOnDelete;
        this.nullables = nullables;
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.row = new GenericRow(this.getters.length);
        Arrays.stream(this.aggregators).forEach(FieldAggregator::reset);
        this.currentDeleteRow = false;
    }

    @Override
    public void add(KeyValue kv) {
        this.latestKv = kv;
        boolean bl = this.currentDeleteRow = this.removeRecordOnDelete && kv.valueKind() == RowKind.DELETE;
        if (this.currentDeleteRow) {
            this.row = new GenericRow(this.getters.length);
            this.initRow(this.row, kv.value());
            return;
        }
        boolean isRetract = kv.valueKind().isRetract();
        for (int i = 0; i < this.getters.length; ++i) {
            FieldAggregator fieldAggregator = this.aggregators[i];
            Object accumulator = this.getters[i].getFieldOrNull((InternalRow)this.row);
            Object inputField = this.getters[i].getFieldOrNull(kv.value());
            Object mergedField = isRetract ? fieldAggregator.retract(accumulator, inputField) : fieldAggregator.agg(accumulator, inputField);
            this.row.setField(i, mergedField);
        }
    }

    private void initRow(GenericRow row, InternalRow value) {
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(value);
            if (this.nullables[i]) continue;
            if (field != null) {
                row.setField(i, field);
                continue;
            }
            throw new IllegalArgumentException("Field " + i + " can not be null");
        }
    }

    @Override
    public KeyValue getResult() {
        Preconditions.checkNotNull((Object)this.latestKv, (String)"Trying to get result from merge function without any input. This is unexpected.");
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        RowKind rowKind = this.currentDeleteRow ? RowKind.DELETE : RowKind.INSERT;
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), rowKind, (InternalRow)this.row);
    }

    @Override
    public boolean requireCopy() {
        return false;
    }

    public static MergeFunctionFactory<KeyValue> factory(Options conf, List<String> fieldNames, List<DataType> fieldTypes, List<String> primaryKeys) {
        return new Factory(conf, fieldNames, fieldTypes, primaryKeys);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final CoreOptions options;
        private final List<String> fieldNames;
        private final List<DataType> fieldTypes;
        private final List<String> primaryKeys;
        private final boolean removeRecordOnDelete;

        private Factory(Options conf, List<String> fieldNames, List<DataType> fieldTypes, List<String> primaryKeys) {
            this.options = new CoreOptions(conf);
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.primaryKeys = primaryKeys;
            this.removeRecordOnDelete = this.options.aggregationRemoveRecordOnDelete();
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            List fieldNames = this.fieldNames;
            List fieldTypes = this.fieldTypes;
            if (projection != null) {
                Projection project = Projection.of((int[][])projection);
                fieldNames = project.project(fieldNames);
                fieldTypes = project.project(fieldTypes);
            }
            FieldAggregator[] fieldAggregators = new FieldAggregator[fieldNames.size()];
            List sequenceFields = this.options.sequenceField();
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = (String)fieldNames.get(i);
                DataType fieldType = (DataType)fieldTypes.get(i);
                String aggFuncName = this.getAggFuncName(fieldName, sequenceFields);
                fieldAggregators[i] = FieldAggregatorFactory.create(fieldType, fieldName, aggFuncName, this.options);
            }
            return new AggregateMergeFunction(InternalRowUtils.createFieldGetters((List)fieldTypes), fieldAggregators, this.removeRecordOnDelete, ArrayUtils.toPrimitiveBoolean((Object[])fieldTypes.stream().map(DataType::isNullable).toArray(Boolean[]::new)));
        }

        private String getAggFuncName(String fieldName, List<String> sequenceFields) {
            if (sequenceFields.contains(fieldName)) {
                return "last_value";
            }
            if (this.primaryKeys.contains(fieldName)) {
                return "primary-key";
            }
            String aggFuncName = this.options.fieldAggFunc(fieldName);
            if (aggFuncName == null) {
                aggFuncName = this.options.fieldsDefaultFunc();
            }
            if (aggFuncName == null) {
                aggFuncName = "last_non_null_value";
            }
            return aggFuncName;
        }
    }
}

