/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.cache;

import java.time.Duration;
import java.time.LocalDateTime;

public class CacheItem {
    private boolean value;
    private LocalDateTime expiresAt;
    private Duration ttl;

    CacheItem() {
    }

    public CacheItem(boolean value, Duration ttl) {
        this.value = value;
        this.ttl = ttl;
        if (!ttl.isNegative()) {
            this.expiresAt = LocalDateTime.now().plus(ttl);
        }
    }

    public boolean isExpired() {
        return !this.ttl.isNegative() && LocalDateTime.now().isAfter(this.expiresAt);
    }

    public boolean getValue() {
        return this.value;
    }
}

