/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.client.MergeConfig;
import io.openlineage.client.transports.TransportConfig;
import java.util.Map;
import lombok.Generated;

public final class TransformConfig
implements TransportConfig,
MergeConfig<TransformConfig> {
    private TransportConfig transport;
    private String transformerClass;
    private Map<String, String> transformerProperties;

    @JsonCreator
    public TransformConfig(@JsonProperty(value="transport") Object transport, @JsonProperty(value="transformClass") String transformClass) {
        this.transformerClass = transformClass;
        this.transport = this.createTransportConfig((Map)transport);
    }

    private TransportConfig createTransportConfig(Map<String, Object> map) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonString = objectMapper.writeValueAsString(map);
            return (TransportConfig)objectMapper.readValue(jsonString, TransportConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error creating transport config", e);
        }
    }

    @Override
    public TransformConfig mergeWithNonNull(TransformConfig other) {
        TransportConfig mergedTransport = this.mergePropertyWith(this.transport, other.getTransport());
        String mergedTransformClass = this.mergePropertyWith(this.transformerClass, other.transformerClass);
        return new TransformConfig(mergedTransport, mergedTransformClass);
    }

    @Generated
    public String toString() {
        return "TransformConfig(transport=" + this.getTransport() + ", transformerClass=" + this.getTransformerClass() + ", transformerProperties=" + this.getTransformerProperties() + ")";
    }

    @Generated
    public TransformConfig() {
    }

    @Generated
    public TransportConfig getTransport() {
        return this.transport;
    }

    @Generated
    public void setTransport(TransportConfig transport) {
        this.transport = transport;
    }

    @Generated
    public String getTransformerClass() {
        return this.transformerClass;
    }

    @Generated
    public void setTransformerClass(String transformerClass) {
        this.transformerClass = transformerClass;
    }

    @Generated
    public Map<String, String> getTransformerProperties() {
        return this.transformerProperties;
    }

    @Generated
    public void setTransformerProperties(Map<String, String> transformerProperties) {
        this.transformerProperties = transformerProperties;
    }
}

