/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap.MemorySizeParser;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.buffersource.BufferSource;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.buffersource.OffHeapBufferSource;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.buffersource.TimingBufferSource;

public final class OffHeapStoreUtils {
    static final String PATH_PREFIX = "org.apache.hadoop.shaded.org.ehcache.offheap.config.";
    private static final long SLOW_DELAY = 3000L;
    private static final String SLOW_DELAY_PROPERTY = "slowAllocationDelay";
    private static final long CRITICAL_DELAY = 30000L;
    private static final String CRITICAL_DELAY_PROPERTY = "criticalAllocationDelay";
    private static final boolean HALT_ON_CRITICAL_DELAY = true;
    private static final String HALT_ON_CRITICAL_DELAY_PROPERTY = "haltOnCriticalAllocationDelay";

    private OffHeapStoreUtils() {
    }

    public static BufferSource getBufferSource() {
        long slowDelay = OffHeapStoreUtils.getAdvancedLongConfigProperty(SLOW_DELAY_PROPERTY, 3000L);
        long critDelay = OffHeapStoreUtils.getAdvancedLongConfigProperty(CRITICAL_DELAY_PROPERTY, 30000L);
        boolean haltOnCrit = OffHeapStoreUtils.getAdvancedBooleanConfigProperty(HALT_ON_CRITICAL_DELAY_PROPERTY, true);
        return new TimingBufferSource(new OffHeapBufferSource(), slowDelay, TimeUnit.MILLISECONDS, critDelay, TimeUnit.MILLISECONDS, haltOnCrit);
    }

    public static long getAdvancedMemorySizeConfigProperty(String property, long defaultValue) {
        String globalPropertyKey = PATH_PREFIX + property;
        return MemorySizeParser.parse(System.getProperty(globalPropertyKey, Long.toString(defaultValue)));
    }

    public static long getAdvancedLongConfigProperty(String property, long defaultValue) {
        String globalPropertyKey = PATH_PREFIX + property;
        return Long.parseLong(System.getProperty(globalPropertyKey, Long.toString(defaultValue)));
    }

    public static boolean getAdvancedBooleanConfigProperty(String property, boolean defaultValue) {
        String globalPropertyKey = PATH_PREFIX + property;
        return Boolean.parseBoolean(System.getProperty(globalPropertyKey, Boolean.toString(defaultValue)));
    }
}

