/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerDataColumn;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import microsoft.sql.DateTimeOffset;

public final class SQLServerDataTable {
    int rowCount = 0;
    int columnCount = 0;
    Map<Integer, SQLServerDataColumn> columnMetadata = new LinkedHashMap<Integer, SQLServerDataColumn>();
    Map<Integer, Object[]> rows = new HashMap<Integer, Object[]>();
    private String tvpName = null;

    public synchronized void clear() {
        this.rowCount = 0;
        this.columnCount = 0;
        this.columnMetadata.clear();
        this.rows.clear();
    }

    public synchronized Iterator<Map.Entry<Integer, Object[]>> getIterator() {
        if (null != this.rows && null != this.rows.entrySet()) {
            return this.rows.entrySet().iterator();
        }
        return null;
    }

    public synchronized void addColumnMetadata(String columnName, int sqlType) throws SQLServerException {
        Util.checkDuplicateColumnName(columnName, this.columnMetadata);
        this.columnMetadata.put(this.columnCount++, new SQLServerDataColumn(columnName, sqlType));
    }

    public synchronized void addColumnMetadata(SQLServerDataColumn column) throws SQLServerException {
        Util.checkDuplicateColumnName(column.columnName, this.columnMetadata);
        this.columnMetadata.put(this.columnCount++, column);
    }

    public synchronized void addRow(Object ... values) throws SQLServerException {
        try {
            int columnCount = this.columnMetadata.size();
            if (null != values && values.length > columnCount) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_moreDataInRowThanColumnInTVP"));
                Object[] msgArgs = new Object[]{};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
            Iterator<Map.Entry<Integer, SQLServerDataColumn>> columnsIterator = this.columnMetadata.entrySet().iterator();
            Object[] rowValues = new Object[columnCount];
            int currentColumn = 0;
            block17: while (columnsIterator.hasNext()) {
                Object val = null;
                if (null != values && currentColumn < values.length && null != values[currentColumn]) {
                    val = null == values[currentColumn] ? null : values[currentColumn];
                }
                ++currentColumn;
                Map.Entry<Integer, SQLServerDataColumn> pair = columnsIterator.next();
                SQLServerDataColumn currentColumnMetadata = pair.getValue();
                JDBCType jdbcType = JDBCType.of(pair.getValue().javaSqlType);
                boolean isColumnMetadataUpdated = false;
                switch (jdbcType) {
                    case BIGINT: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Long.valueOf(Long.parseLong(val.toString()));
                        continue block17;
                    }
                    case BIT: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Boolean.valueOf(Boolean.parseBoolean(val.toString()));
                        continue block17;
                    }
                    case INTEGER: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Integer.valueOf(Integer.parseInt(val.toString()));
                        continue block17;
                    }
                    case SMALLINT: 
                    case TINYINT: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Short.valueOf(Short.parseShort(val.toString()));
                        continue block17;
                    }
                    case DECIMAL: 
                    case NUMERIC: {
                        BigDecimal bd = null;
                        if (null != val) {
                            int numberOfDigitsIntegerPart;
                            bd = new BigDecimal(val.toString());
                            int precision = Util.getValueLengthBaseOnJavaType(bd, JavaType.of(bd), null, null, jdbcType);
                            if (bd.scale() > currentColumnMetadata.scale) {
                                currentColumnMetadata.scale = bd.scale();
                                isColumnMetadataUpdated = true;
                            }
                            if (precision > currentColumnMetadata.precision) {
                                currentColumnMetadata.precision = precision;
                                isColumnMetadataUpdated = true;
                            }
                            if ((numberOfDigitsIntegerPart = precision - bd.scale()) > currentColumnMetadata.numberOfDigitsIntegerPart) {
                                currentColumnMetadata.numberOfDigitsIntegerPart = numberOfDigitsIntegerPart;
                                isColumnMetadataUpdated = true;
                            }
                            if (isColumnMetadataUpdated) {
                                currentColumnMetadata.precision = currentColumnMetadata.scale + currentColumnMetadata.numberOfDigitsIntegerPart;
                                this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                            }
                        }
                        rowValues[pair.getKey().intValue()] = bd;
                        continue block17;
                    }
                    case DOUBLE: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Double.valueOf(Double.parseDouble(val.toString()));
                        continue block17;
                    }
                    case FLOAT: 
                    case REAL: {
                        rowValues[pair.getKey().intValue()] = null == val ? null : Float.valueOf(Float.parseFloat(val.toString()));
                        continue block17;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: 
                    case TIME_WITH_TIMEZONE: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                    }
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: 
                    case DATETIMEOFFSET: {
                        if (null == val) {
                            rowValues[pair.getKey().intValue()] = null;
                            continue block17;
                        }
                        if (val instanceof Date) {
                            rowValues[pair.getKey().intValue()] = val.toString();
                            continue block17;
                        }
                        if (val instanceof DateTimeOffset) {
                            rowValues[pair.getKey().intValue()] = val.toString();
                            continue block17;
                        }
                        if (val instanceof OffsetDateTime) {
                            rowValues[pair.getKey().intValue()] = val.toString();
                            continue block17;
                        }
                        if (val instanceof OffsetTime) {
                            rowValues[pair.getKey().intValue()] = val.toString();
                            continue block17;
                        }
                        rowValues[pair.getKey().intValue()] = null == val ? null : (String)val;
                        continue block17;
                    }
                    case BINARY: 
                    case VARBINARY: 
                    case LONGVARBINARY: {
                        int nValueLen;
                        boolean bValueNull = null == val;
                        int n = nValueLen = bValueNull ? 0 : ((byte[])val).length;
                        if (nValueLen > currentColumnMetadata.precision) {
                            currentColumnMetadata.precision = nValueLen;
                            this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                        }
                        rowValues[pair.getKey().intValue()] = bValueNull ? null : (byte[])val;
                        continue block17;
                    }
                    case CHAR: {
                        if (val instanceof UUID && val != null) {
                            val = val.toString();
                        }
                    }
                    case VARCHAR: 
                    case NCHAR: 
                    case NVARCHAR: 
                    case LONGVARCHAR: 
                    case LONGNVARCHAR: 
                    case SQLXML: {
                        int nValueLen;
                        boolean bValueNull = null == val;
                        int n = nValueLen = bValueNull ? 0 : 2 * ((String)val).length();
                        if (nValueLen > currentColumnMetadata.precision) {
                            currentColumnMetadata.precision = nValueLen;
                            this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                        }
                        rowValues[pair.getKey().intValue()] = bValueNull ? null : (String)val;
                        continue block17;
                    }
                }
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedDataTypeTVP"));
                Object[] msgArgs = new Object[]{jdbcType};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
            this.rows.put(this.rowCount++, rowValues);
        }
        catch (NumberFormatException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
    }

    public synchronized Map<Integer, SQLServerDataColumn> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getTvpName() {
        return this.tvpName;
    }

    public void setTvpName(String tvpName) {
        this.tvpName = tvpName;
    }
}

