/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.runtime;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRNoProtocolMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMetaClassBody;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.ir.runtime.IRWrappedLambdaReturnValue;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.runtime.callsite.ProfilingCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class IRRuntimeHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(IRRuntimeHelpers.class);
    private static final InvalidKeyException INVALID_KEY_EXCEPTION = new InvalidKeyException();
    private static final RubyHash.VisitorWithState<StaticScope> CheckUnwantedKeywordsVisitor = new RubyHash.VisitorWithState<StaticScope>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            String javaName = key2.asJavaString();
            if (!scope.keywordExists(javaName)) {
                throw INVALID_KEY_EXCEPTION;
            }
        }
    };

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    public static boolean inNonMethodBodyLambda(StaticScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.isArgumentScope();
    }

    public static boolean inMethod(Block.Type blockType) {
        return blockType == null;
    }

    public static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    @Interp
    @JIT
    public static void checkForLJE(ThreadContext context, DynamicScope currentScope, boolean definedWithinMethod, Block block) {
        if (IRRuntimeHelpers.inLambda(block.type)) {
            return;
        }
        DynamicScope returnToScope = IRRuntimeHelpers.getContainingReturnToScope(currentScope);
        if (returnToScope == null || !context.scopeExistsOnCallStack(returnToScope)) {
            throw IRException.RETURN_LocalJumpError.getException(context.runtime);
        }
    }

    private static DynamicScope getContainingLambda(DynamicScope dynamicScope) {
        for (DynamicScope scope = dynamicScope; scope != null && scope.getStaticScope().isBlockScope(); scope = scope.getParentScope()) {
            if (!scope.isLambda() || scope.getStaticScope().isArgumentScope()) continue;
            return scope;
        }
        return null;
    }

    @JIT
    @Interp
    public static IRubyObject initiateNonLocalReturn(DynamicScope currentScope, Block block, IRubyObject returnValue) {
        if (block != null && IRRuntimeHelpers.inLambda(block.type)) {
            throw new IRWrappedLambdaReturnValue(returnValue);
        }
        DynamicScope returnToScope = IRRuntimeHelpers.getContainingLambda(currentScope);
        if (returnToScope == null) {
            returnToScope = IRRuntimeHelpers.getContainingReturnToScope(currentScope);
        }
        assert (returnToScope != null) : "accidental return scope";
        throw IRReturnJump.create(currentScope.getStaticScope(), returnToScope, returnValue);
    }

    private static DynamicScope getContainingReturnToScope(DynamicScope returnLocationScope) {
        for (DynamicScope current2 = returnLocationScope; current2 != null; current2 = current2.getParentScope()) {
            if (!current2.isReturnTarget()) continue;
            return current2;
        }
        return null;
    }

    @JIT
    public static IRubyObject handleNonlocalReturn(DynamicScope currentScope, Object rjExc) throws RuntimeException {
        if (!(rjExc instanceof IRReturnJump)) {
            Helpers.throwException((Throwable)rjExc);
            return null;
        }
        IRReturnJump rj = (IRReturnJump)rjExc;
        if (rj.isReturnToScope(currentScope)) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + currentScope);
            }
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    private static IRScopeType ensureScopeIsClosure(ThreadContext context, DynamicScope dynamicScope) {
        IRScopeType scopeType = dynamicScope.getStaticScope().getScopeType();
        if (!scopeType.isClosureType()) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        return scopeType;
    }

    @JIT
    public static IRubyObject initiateBreak(ThreadContext context, DynamicScope dynScope, IRubyObject breakValue, Block block) throws RuntimeException {
        if (IRRuntimeHelpers.inLambda(block.type)) {
            throw new IRWrappedLambdaReturnValue(breakValue, true);
        }
        IRScopeType scopeType = IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
        DynamicScope parentScope = dynScope.getParentScope();
        if (block.isEscaped()) {
            throw Helpers.newLocalJumpErrorForBreak(context.runtime, breakValue);
        }
        throw IRBreakJump.create(parentScope, breakValue, scopeType.isEval());
    }

    private static boolean inReturnToScope(Block.Type blockType, IRReturnJump exception2, DynamicScope currentScope) {
        return (IRRuntimeHelpers.inMethod(blockType) || IRRuntimeHelpers.inLambda(blockType)) && exception2.isReturnToScope(currentScope);
    }

    @JIT
    public static IRubyObject handleBreakAndReturnsInLambdas(ThreadContext context, DynamicScope dynScope, Object exc, Block block) throws RuntimeException {
        if (exc instanceof IRWrappedLambdaReturnValue) {
            return ((IRWrappedLambdaReturnValue)exc).returnValue;
        }
        if (exc instanceof IRReturnJump && dynScope != null && IRRuntimeHelpers.inReturnToScope(block.type, (IRReturnJump)exc, dynScope)) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + dynScope);
            }
            return (IRubyObject)((IRReturnJump)exc).returnValue;
        }
        context.setSavedExceptionInLambda((Throwable)exc);
        return null;
    }

    @JIT
    public static IRubyObject returnOrRethrowSavedException(ThreadContext context, IRubyObject value2) {
        Throwable exc = context.getSavedExceptionInLambda();
        if (exc != null) {
            context.setSavedExceptionInLambda(null);
            Helpers.throwException(exc);
        }
        return value2;
    }

    @JIT
    public static IRubyObject handlePropagatedBreak(ThreadContext context, DynamicScope dynScope, Object bjExc) {
        if (!(bjExc instanceof IRBreakJump)) {
            Helpers.throwException((Throwable)bjExc);
            return null;
        }
        IRBreakJump bj = (IRBreakJump)bjExc;
        if (bj.breakInEval) {
            IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
            bj.breakInEval = false;
            throw bj;
        }
        if (bj.scopeToReturnTo == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Break reached target in scope: " + dynScope);
            }
            return bj.breakValue;
        }
        throw bj;
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg, DynamicScope currDynScope, IRubyObject self2) {
        String name2;
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        String string2 = name2 = nameArg instanceof String ? (String)nameArg : nameArg.toString();
        if (module == null) {
            throw context.runtime.newTypeError("No class to undef method '" + name2 + "'.");
        }
        module.undef(context, name2);
        return context.nil;
    }

    @JIT
    public static double unboxFloat(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return ((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getDoubleValue();
    }

    @JIT
    public static long unboxFixnum(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return (long)((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getLongValue();
    }

    public static boolean flt(double v1, double v2) {
        return v1 < v2;
    }

    public static boolean fgt(double v1, double v2) {
        return v1 > v2;
    }

    public static boolean feq(double v1, double v2) {
        return v1 == v2;
    }

    public static boolean ilt(long v1, long v2) {
        return v1 < v2;
    }

    public static boolean igt(long v1, long v2) {
        return v1 > v2;
    }

    public static boolean ieq(long v1, long v2) {
        return v1 == v2;
    }

    public static Object unwrapRubyException(Object excObj) {
        if (excObj instanceof Unrescuable) {
            Helpers.throwException((Throwable)excObj);
        }
        return excObj instanceof RaiseException ? ((RaiseException)excObj).getException() : excObj;
    }

    private static boolean isJavaExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj, boolean arrayCheck) {
        if (!(excObj instanceof Throwable)) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        Throwable ex = (Throwable)excObj;
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isJavaExceptionHandled(context, testType, ex, true)) continue;
                IRubyObject exception2 = n == 1 ? IRRuntimeHelpers.wrapJavaException(context, testType, ex) : Helpers.wrapJavaException(runtime2, ex);
                runtime2.getGlobalVariables().set("$!", exception2);
                return true;
            }
        } else {
            IRubyObject exception3 = IRRuntimeHelpers.wrapJavaException(context, excType, ex);
            if (Helpers.checkJavaException(exception3, ex, excType, context)) {
                runtime2.getGlobalVariables().set("$!", exception3);
                return true;
            }
        }
        return false;
    }

    private static IRubyObject wrapJavaException(ThreadContext context, IRubyObject excType, Throwable throwable) {
        Ruby runtime2 = context.runtime;
        if (excType == runtime2.getNativeException()) {
            return IRRuntimeHelpers.wrapWithNativeException(context, throwable, runtime2);
        }
        return Helpers.wrapJavaException(runtime2, throwable);
    }

    private static IRubyObject wrapWithNativeException(ThreadContext context, Throwable throwable, Ruby runtime2) {
        NativeException exception2 = new NativeException(runtime2, runtime2.getNativeException(), throwable);
        exception2.prepareIntegratedBacktrace(context, throwable.getStackTrace());
        return exception2;
    }

    private static boolean isRubyExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isRubyExceptionHandled(context, testType, excObj)) continue;
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        } else if (excObj instanceof IRubyObject) {
            if (!(excType instanceof RubyModule)) {
                throw context.runtime.newTypeError("class or module required for rescue clause. Found: " + excType);
            }
            if (excType.callMethod(context, "===", (IRubyObject)excObj).isTrue()) {
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        }
        return false;
    }

    public static IRubyObject isExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        boolean ret = IRRuntimeHelpers.isRubyExceptionHandled(context, excType, excObj = IRRuntimeHelpers.unwrapRubyException(excObj)) || IRRuntimeHelpers.isJavaExceptionHandled(context, excType, excObj, false);
        return RubyBoolean.newBoolean(context, ret);
    }

    public static IRubyObject isEQQ(ThreadContext context, IRubyObject receiver2, IRubyObject value2, CallSite callSite, boolean splattedValue) {
        boolean isUndefValue;
        boolean bl = isUndefValue = value2 == UndefinedValue.UNDEFINED;
        if (splattedValue && receiver2 instanceof RubyArray) {
            RubyArray testVals = (RubyArray)receiver2;
            int n = testVals.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object eqqVal;
                Object v = testVals.eltInternal(i2);
                Object object = eqqVal = isUndefValue ? v : callSite.call(context, (IRubyObject)v, (IRubyObject)v, value2);
                if (!eqqVal.isTrue()) continue;
                return eqqVal;
            }
            return context.fals;
        }
        if (isUndefValue) {
            return receiver2;
        }
        return callSite.call(context, receiver2, receiver2, value2);
    }

    public static IRubyObject newProc(Ruby runtime2, Block block) {
        return block == Block.NULL_BLOCK ? runtime2.getNil() : runtime2.newProc(Block.Type.PROC, block);
    }

    @JIT
    public static IRubyObject newProc(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        return block == Block.NULL_BLOCK ? runtime2.getNil() : runtime2.newProc(Block.Type.PROC, block);
    }

    @JIT
    public static RubyProc newLambdaProc(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        return runtime2.newProc(Block.Type.LAMBDA, block);
    }

    @JIT
    public static IRubyObject yield(ThreadContext context, Block b2, IRubyObject yieldVal, boolean unwrapArray) {
        return unwrapArray && yieldVal instanceof RubyArray ? b2.yieldArray(context, yieldVal, null) : b2.yield(context, yieldVal);
    }

    @JIT
    public static IRubyObject yieldSpecific(ThreadContext context, Block b2) {
        return b2.yieldSpecific(context);
    }

    @JIT
    public static IRubyObject yieldValues(ThreadContext context, Block blk, IRubyObject[] args2) {
        return blk.yieldValues(context, args2);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, IRubyObject value2, Signature signature) {
        switch (signature.arityValue()) {
            case -1: {
                IRubyObject[] iRubyObjectArray;
                if (signature.opt() > 1 && value2 instanceof RubyArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArray();
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
            case 0: 
            case 1: {
                return new IRubyObject[]{value2};
            }
        }
        return IRBlockBody.toAry(context, value2);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, RubyArray array2, Signature signature) {
        switch (signature.arityValue()) {
            case -1: {
                return array2.toJavaArray();
            }
            case 0: 
            case 1: {
                return new IRubyObject[]{array2};
            }
        }
        return IRRuntimeHelpers.singleBlockArgToArray(Helpers.aryToAry(context, (IRubyObject)(array2.size() == 1 ? array2.eltInternal(0) : array2)));
    }

    @JIT
    public static Block getBlockFromObject(ThreadContext context, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof RubySymbol) {
            block = ((RubyProc)((RubySymbol)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        return block;
    }

    @JIT
    public static Block getRefinedBlockFromObject(ThreadContext context, StaticScope scope, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof RubySymbol) {
            block = ((RubyProc)((RubySymbol)value2).toRefinedProc(context, scope)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        return block;
    }

    public static void checkArity(ThreadContext context, StaticScope scope, Object[] args2, int required, int opt, boolean rest2, boolean receivesKwargs, int restKey, Block block) {
        IRubyObject lastArg;
        int argsLength = args2.length;
        RubyHash keywordArgs = IRRuntimeHelpers.extractKwargsHash(context, args2, required, receivesKwargs);
        if (restKey == -1 && keywordArgs != null) {
            IRRuntimeHelpers.checkForExtraUnwantedKeywordArgs(context, scope, keywordArgs);
        }
        if (keywordArgs != null) {
            --argsLength;
        }
        if (!rest2 && argsLength > required + opt && (lastArg = (IRubyObject)args2[argsLength - 1]) instanceof RubyHash && ((RubyHash)lastArg).isKeywordRestArguments()) {
            ((RubyHash)lastArg).setKeywordRestArguments(false);
            --argsLength;
        }
        if ((block == null || block.type.checkArity) && (argsLength < required || !rest2 && argsLength > required + opt)) {
            Arity.raiseArgumentError(context.runtime, argsLength, required, rest2 ? -1 : required + opt);
        }
    }

    @JIT
    public static IRubyObject[] frobnicateKwargsArgument(ThreadContext context, IRubyObject[] args2, int requiredArgsCount) {
        if (args2 == null) {
            return args2;
        }
        int length2 = args2.length;
        if (length2 <= requiredArgsCount) {
            return args2;
        }
        IRubyObject maybeKwargs = IRRuntimeHelpers.toHash(context, args2[length2 - 1]);
        if (maybeKwargs != null) {
            if (maybeKwargs.isNil()) {
                return ArraySupport.newCopy(args2, RubyHash.newSmallHash(context.runtime));
            }
            RubyHash kwargs = (RubyHash)maybeKwargs;
            if (kwargs.allSymbols()) {
                args2[length2 - 1] = kwargs.dupFast(context);
            } else {
                args2 = IRRuntimeHelpers.homogenizeKwargs(context, args2, kwargs);
            }
        }
        return args2;
    }

    private static IRubyObject[] homogenizeKwargs(ThreadContext context, IRubyObject[] args2, RubyHash kwargs) {
        DivvyKeywordsVisitor visitor = new DivvyKeywordsVisitor();
        kwargs.visitAll(context, visitor, null);
        if (visitor.syms == null) {
            visitor.syms = RubyHash.newSmallHash(context.runtime);
        }
        if (visitor.others != null) {
            args2 = ArraySupport.newCopy(args2, args2.length + 1);
            args2[args2.length - 2] = visitor.others;
        }
        args2[args2.length - 1] = visitor.syms;
        return args2;
    }

    public static boolean shouldPrintIR(Ruby runtime2) {
        boolean booting = runtime2.isBooting();
        boolean print2 = Options.IR_PRINT.load();
        boolean printAll = Options.IR_PRINT_ALL.load();
        return !booting && print2 || booting && printAll;
    }

    public static boolean shouldPrintScope(IRScope scope) {
        String pattern = Options.IR_PRINT_PATTERN.load();
        return pattern.equals("<NO_PATTERN>") || scope.getId().matches(pattern);
    }

    public static void updateCoverage(ThreadContext context, String filename2, int line) {
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.isCoverageEnabled()) {
            data2.coverLine(filename2, line);
        }
    }

    public static IRubyObject isHashEmpty(ThreadContext context, IRubyObject hashArg) {
        return hashArg instanceof RubyHash && ((RubyHash)hashArg).size() == 0 ? context.tru : context.fals;
    }

    private static IRubyObject toHash(ThreadContext context, IRubyObject lastArg) {
        if (lastArg instanceof RubyHash) {
            return (RubyHash)lastArg;
        }
        if (lastArg.respondsTo("to_hash")) {
            if ((lastArg = lastArg.callMethod(context, "to_hash")) == context.nil) {
                return lastArg;
            }
            TypeConverter.checkType(context, lastArg, context.runtime.getHash());
            return (RubyHash)lastArg;
        }
        return null;
    }

    public static RubyHash extractKwargsHash(ThreadContext context, Object[] args2, int requiredArgsCount, boolean receivesKwargs) {
        IRubyObject returnValue;
        if (!receivesKwargs) {
            return null;
        }
        if (args2.length <= requiredArgsCount) {
            return null;
        }
        Object lastArg = args2[args2.length - 1];
        if (lastArg instanceof IRubyObject && (returnValue = IRRuntimeHelpers.toHash(context, (IRubyObject)lastArg)) instanceof RubyHash) {
            return (RubyHash)returnValue;
        }
        return null;
    }

    @Deprecated
    public static RubyHash extractKwargsHash(Object[] args2, int requiredArgsCount, boolean receivesKwargs) {
        IRubyObject returnValue;
        if (!receivesKwargs) {
            return null;
        }
        if (args2.length <= requiredArgsCount) {
            return null;
        }
        Object lastArg = args2[args2.length - 1];
        if (lastArg instanceof IRubyObject && (returnValue = IRRuntimeHelpers.toHash(((IRubyObject)lastArg).getRuntime().getCurrentContext(), (IRubyObject)lastArg)) instanceof RubyHash) {
            return (RubyHash)returnValue;
        }
        return null;
    }

    public static void checkForExtraUnwantedKeywordArgs(ThreadContext context, StaticScope scope, RubyHash keywordArgs) {
        try {
            keywordArgs.visitAll(context, CheckUnwantedKeywordsVisitor, scope);
        }
        catch (InvalidKeyException ike) {
            GatherUnwantedKeywordsVisitor visitor = new GatherUnwantedKeywordsVisitor();
            keywordArgs.visitAll(context, visitor, scope);
            visitor.raiseIfError(context);
        }
    }

    @JIT
    public static DynamicScope prepareScriptScope(ThreadContext context, StaticScope scope) {
        DynamicScope tlbScope;
        IRScope irScope = scope.getIRScope();
        if (irScope != null && irScope.isScriptScope() && (tlbScope = ((IRScriptBody)irScope).getScriptDynamicScope()) != null) {
            context.preScopedBody(tlbScope);
            tlbScope.growIfNeeded();
            return tlbScope;
        }
        DynamicScope dynScope = DynamicScope.newDynamicScope(scope);
        context.pushScope(dynScope);
        return dynScope;
    }

    public static IRubyObject match3(ThreadContext context, RubyRegexp regexp2, IRubyObject argValue) {
        if (argValue instanceof RubyString) {
            return regexp2.op_match(context, argValue);
        }
        return argValue.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject extractOptionalArgument(RubyArray rubyArray, int minArgsLength, int index2) {
        int n = rubyArray.getLength();
        return minArgsLength < n ? rubyArray.entry(index2) : UndefinedValue.UNDEFINED;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedBackref(ThreadContext context, IRubyObject definedMessage) {
        return RubyMatchData.class.isInstance(context.getBackRef()) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedGlobal(ThreadContext context, String name2, IRubyObject definedMessage) {
        return context.runtime.getGlobalVariables().isDefined(name2) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedNthRef(ThreadContext context, int matchNumber, IRubyObject definedMessage) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData && !((RubyMatchData)backref).group(matchNumber).isNil()) {
            return definedMessage;
        }
        return context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedClassVar(ThreadContext context, RubyModule receiver2, String name2, IRubyObject definedMessage) {
        RubyBasicObject attached;
        boolean defined = receiver2.isClassVarDefined(name2);
        if (!defined && receiver2.isSingleton() && (attached = ((MetaClass)receiver2).getAttached()) instanceof RubyModule) {
            defined = ((RubyModule)attached).isClassVarDefined(name2);
        }
        return defined ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedInstanceVar(ThreadContext context, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        return receiver2.getInstanceVariables().hasInstanceVariable(name2) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        IRubyObject boundValue = Helpers.getDefinedCall(context, self2, receiver2, name2, definedMessage);
        return boundValue == null ? context.nil : boundValue;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedConstantOrMethod(ThreadContext context, IRubyObject receiver2, RubyString name2, IRubyObject definedConstantMessage, IRubyObject definedMethodMessage) {
        IRubyObject definedType = Helpers.getDefinedConstantOrBoundMethod(receiver2, name2.intern().idString(), definedConstantMessage, definedMethodMessage);
        return definedType == null ? context.nil : definedType;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedMethod(ThreadContext context, IRubyObject receiver2, String name2, boolean checkIfPublic, IRubyObject definedMessage) {
        boolean defined;
        DynamicMethod method2 = receiver2.getMetaClass().searchMethod(name2);
        boolean bl = defined = !method2.isUndefined();
        defined = defined ? !checkIfPublic || method2.getVisibility() == Visibility.PUBLIC : receiver2.respondsToMissing(name2, checkIfPublic);
        return defined ? definedMessage : context.nil;
    }

    @Interp
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, IRubyObject definedMessage) {
        return IRRuntimeHelpers.isDefinedSuper(context, receiver2, context.getFrameName(), context.getFrameKlazz(), definedMessage);
    }

    @JIT
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, String frameName, RubyModule frameClass, IRubyObject definedMessage) {
        boolean defined = frameName != null && frameClass != null && frameClass.getSuperClass() != null && frameClass.getSuperClass().isMethodBound(frameName, false);
        return defined ? definedMessage : context.nil;
    }

    public static IRubyObject nthMatch(ThreadContext context, int matchNumber) {
        return RubyRegexp.nth_match(matchNumber, context.getBackRef());
    }

    public static void defineAlias(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, IRubyObject newName, IRubyObject oldName) {
        if (self2 == null || self2 instanceof RubyFixnum || self2 instanceof RubySymbol) {
            throw context.runtime.newTypeError("no class to make alias");
        }
        IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2).alias_method(context, newName, oldName);
    }

    public static RubyModule getCurrentClassBase(ThreadContext context, IRubyObject self2) {
        return IRRuntimeHelpers.getModuleFromScope(context, context.getCurrentStaticScope(), self2);
    }

    public static RubyModule getModuleFromScope(ThreadContext context, StaticScope scope, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyModule rubyClass = scope.getModule();
        while (scope != null && (rubyClass.isSingleton() || rubyClass == runtime2.getDummy())) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime2.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        if (scope == null && arg2 != null) {
            rubyClass = arg2.getMetaClass();
        }
        if (rubyClass == null) {
            throw context.runtime.newTypeError("no class/module to define class variable");
        }
        return rubyClass;
    }

    @JIT
    @Interp
    public static IRubyObject mergeKeywordArguments(ThreadContext context, IRubyObject restKwarg, IRubyObject explicitKwarg) {
        RubyHash hash2 = (RubyHash)TypeConverter.checkHashType(context.runtime, restKwarg).dup();
        hash2.modify();
        hash2.setKeywordRestArguments(true);
        RubyHash otherHash = explicitKwarg.convertToHash();
        if (otherHash.empty_p(context).isTrue()) {
            return hash2;
        }
        otherHash.visitAll(context, new KwargMergeVisitor(hash2), Block.NULL_BLOCK);
        return hash2;
    }

    public static RubyModule findInstanceMethodContainer(ThreadContext context, DynamicScope currDynScope, IRubyObject self2) {
        boolean inBindingEval = currDynScope.inBindingEval();
        if (!inBindingEval && self2 == context.runtime.getTopSelf()) {
            return self2.getType();
        }
        DynamicScope ds = currDynScope;
        while (ds != null) {
            IRScopeType scopeType = ds.getStaticScope().getScopeType();
            switch (ds.getEvalType()) {
                case MODULE_EVAL: {
                    return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                }
                case INSTANCE_EVAL: {
                    return self2.getSingletonClass();
                }
                case BINDING_EVAL: {
                    ds = ds.getParentScope();
                    break;
                }
                case NONE: {
                    if (scopeType == null || scopeType.isClosureType()) {
                        ds = ds.getParentScope();
                        break;
                    }
                    if (inBindingEval) {
                        return ds.getStaticScope().getModule();
                    }
                    switch (scopeType) {
                        case CLASS_METHOD: 
                        case MODULE_BODY: 
                        case CLASS_BODY: 
                        case METACLASS_BODY: {
                            return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                        }
                        case INSTANCE_METHOD: 
                        case SCRIPT_BODY: {
                            return self2.getMetaClass();
                        }
                    }
                    throw new RuntimeException("Should not get here! scopeType is " + (Object)((Object)scopeType));
                }
            }
        }
        throw new RuntimeException("Should not get here!");
    }

    public static RubyBoolean isBlockGiven(ThreadContext context, Object blk) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        return RubyBoolean.newBoolean(context, ((Block)blk).isGiven());
    }

    public static IRubyObject receiveRestArg(ThreadContext context, Object[] args2, int required, int argIndex, boolean acceptsKeywordArguments) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, required, acceptsKeywordArguments);
        return IRRuntimeHelpers.constructRestArg(context, args2, keywordArguments, required, argIndex);
    }

    public static IRubyObject receiveRestArg(ThreadContext context, IRubyObject[] args2, int required, int argIndex, boolean acceptsKeywordArguments) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, required, acceptsKeywordArguments);
        return IRRuntimeHelpers.constructRestArg(context, args2, keywordArguments, required, argIndex);
    }

    public static IRubyObject constructRestArg(ThreadContext context, Object[] args2, RubyHash keywordArguments, int required, int argIndex) {
        int argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return context.runtime.newEmptyArray();
        }
        return RubyArray.newArrayMayCopy(context.runtime, (IRubyObject[])args2, argIndex, remainingArguments);
    }

    private static IRubyObject constructRestArg(ThreadContext context, IRubyObject[] args2, RubyHash keywordArguments, int required, int argIndex) {
        int argsLength;
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (required == 0 && argsLength == args2.length) {
            return RubyArray.newArray(context.runtime, args2);
        }
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return context.runtime.newEmptyArray();
        }
        return RubyArray.newArrayMayCopy(context.runtime, args2, argIndex, remainingArguments);
    }

    @JIT
    @Interp
    public static IRubyObject receivePostReqdArg(ThreadContext context, IRubyObject[] args2, int pre, int opt, boolean rest2, int post, int argIndex, boolean acceptsKeywordArgument) {
        int required = pre + post;
        boolean kwargs = IRRuntimeHelpers.extractKwargsHash(context, args2, required, acceptsKeywordArgument) != null;
        int n = kwargs ? args2.length - 1 : args2.length;
        int remaining = n - pre;
        if (remaining < post) {
            if (pre + argIndex >= n) {
                return context.nil;
            }
            return args2[pre + argIndex];
        }
        if (rest2) {
            return args2[n - post + argIndex];
        }
        if (n > required + opt) {
            return args2[pre + opt + argIndex];
        }
        return args2[n - post + argIndex];
    }

    @JIT
    public static IRubyObject receiveOptArg(ThreadContext context, IRubyObject[] args2, int requiredArgs, int preArgs, int argIndex, boolean acceptsKeywordArgument) {
        int argsLength;
        int optArgIndex = argIndex;
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, requiredArgs, acceptsKeywordArgument);
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (requiredArgs + optArgIndex >= argsLength) {
            return UndefinedValue.UNDEFINED;
        }
        return args2[preArgs + optArgIndex];
    }

    @Deprecated
    public static IRubyObject receiveOptArg(IRubyObject[] args2, int requiredArgs, int preArgs, int argIndex, boolean acceptsKeywordArgument) {
        int argsLength;
        int optArgIndex = argIndex;
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, requiredArgs, acceptsKeywordArgument);
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (requiredArgs + optArgIndex >= argsLength) {
            return UndefinedValue.UNDEFINED;
        }
        return args2[preArgs + optArgIndex];
    }

    public static IRubyObject getPreArgSafe(ThreadContext context, IRubyObject[] args2, int argIndex) {
        IRubyObject result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
        return result2;
    }

    public static IRubyObject receiveKeywordArg(ThreadContext context, IRubyObject[] args2, int required, String id2, boolean acceptsKeywordArgument) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, required, acceptsKeywordArgument);
        if (keywordArguments == null) {
            return UndefinedValue.UNDEFINED;
        }
        RubySymbol keywordName = context.runtime.newSymbol(id2);
        if (keywordArguments.fastARef(keywordName) == null) {
            return UndefinedValue.UNDEFINED;
        }
        return keywordArguments.delete(context, keywordName, Block.NULL_BLOCK);
    }

    public static IRubyObject receiveKeywordArg(ThreadContext context, IRubyObject[] args2, int required, RubySymbol key2, boolean acceptsKeywordArgument) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, required, acceptsKeywordArgument);
        if (keywordArguments == null) {
            return UndefinedValue.UNDEFINED;
        }
        if (keywordArguments.fastARef(key2) == null) {
            return UndefinedValue.UNDEFINED;
        }
        return keywordArguments.delete(context, key2, Block.NULL_BLOCK);
    }

    public static IRubyObject receiveKeywordRestArg(ThreadContext context, IRubyObject[] args2, int required, boolean keywordArgumentSupplied) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(context, args2, required, keywordArgumentSupplied);
        return keywordArguments == null ? RubyHash.newSmallHash(context.runtime) : keywordArguments;
    }

    public static IRubyObject setCapturedVar(ThreadContext context, IRubyObject matchRes, String id2) {
        if (matchRes.isNil()) {
            return context.nil;
        }
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.nth_match(((RubyMatchData)backref).getNameToBackrefNumber(id2), backref);
    }

    @JIT
    public static IRubyObject instanceSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject instanceSuperIterSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuperIter(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject instanceSuper(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        CacheEntry entry = IRRuntimeHelpers.getSuperMethodEntry(id2, definingModule);
        DynamicMethod method2 = entry.method;
        if (method2 instanceof InstanceMethodInvoker && self2 instanceof JavaProxy) {
            return IRRuntimeHelpers.javaProxySuper(context, (JavaProxy)self2, id2, (RubyClass)definingModule, args2, (InstanceMethodInvoker)method2);
        }
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), id2, CallType.SUPER, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, id2, args2, block);
    }

    private static IRubyObject javaProxySuper(ThreadContext context, JavaProxy self2, String id2, RubyClass definingModule, IRubyObject[] args2, InstanceMethodInvoker superMethod) {
        JavaProxyMethod jpm;
        Object javaInvokee = self2.getObject();
        JavaMethod javaMethod = (JavaMethod)superMethod.findCallable(self2, id2, args2, args2.length);
        Object[] newArgs = RubyToJavaInvoker.convertArguments(javaMethod, args2);
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(context.runtime, definingModule);
        if (jpc != null && (jpm = jpc.getMethod(id2, javaMethod.getParameterTypes())) != null && jpm.hasSuperImplementation()) {
            return javaMethod.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, newArgs);
        }
        return javaMethod.invokeDirectWithExceptionHandling(context, javaMethod.getValue(), javaInvokee, newArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject instanceSuperIter(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.instanceSuper(context, self2, id2, definingModule, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static CacheEntry getSuperMethodEntry(String id2, RubyModule definingModule) {
        RubyClass superClass = definingModule.getMethodLocation().getSuperClass();
        return superClass != null ? superClass.searchWithCache(id2) : CacheEntry.NULL_CACHE;
    }

    @JIT
    public static IRubyObject classSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject classSuperIterSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuperIter(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject classSuper(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        CacheEntry entry = IRRuntimeHelpers.getSuperMethodEntry(id2, definingModule.getMetaClass());
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), id2, CallType.SUPER, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, id2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject classSuperIter(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.classSuper(context, self2, id2, definingModule, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @JIT
    public static IRubyObject unresolvedSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject unresolvedSuperIterSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuperIter(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject unresolvedSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String methodName = context.getFrameName();
        Helpers.checkSuperDisabledOrOutOfMethod(context, klazz, methodName);
        RubyClass superClass = IRRuntimeHelpers.searchNormalSuperclass(klazz);
        CacheEntry entry = superClass != null ? superClass.searchWithCache(methodName) : CacheEntry.NULL_CACHE;
        IRubyObject rVal = entry.method.isUndefined() ? Helpers.callMethodMissing(context, self2, entry.method.getVisibility(), methodName, CallType.SUPER, args2, block) : entry.method.call(context, self2, entry.sourceModule, methodName, args2, block);
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject unresolvedSuperIter(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static RubyClass searchNormalSuperclass(RubyModule klazz) {
        if (klazz.isIncluded() && klazz.getOrigin().isRefinement()) {
            klazz = klazz.getOrigin();
        }
        klazz = klazz.getMethodLocation();
        return klazz.getSuperClass();
    }

    public static IRubyObject zSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    public static IRubyObject zSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    public static IRubyObject[] splatArguments(IRubyObject[] args2, boolean[] splatMap) {
        if (splatMap != null && splatMap.length > 0) {
            int count2 = 0;
            for (int i2 = 0; i2 < splatMap.length; ++i2) {
                count2 += splatMap[i2] && args2[i2] instanceof RubyArray ? ((RubyArray)args2[i2]).size() : 1;
            }
            IRubyObject[] newArgs = new IRubyObject[count2];
            int actualOffset = 0;
            for (int i3 = 0; i3 < splatMap.length; ++i3) {
                if (splatMap[i3] && args2[i3] instanceof RubyArray) {
                    RubyArray ary = (RubyArray)args2[i3];
                    for (int j = 0; j < ary.size(); ++j) {
                        newArgs[actualOffset++] = ary.eltOk(j);
                    }
                    continue;
                }
                newArgs[actualOffset++] = args2[i3];
            }
            args2 = newArgs;
        }
        return args2;
    }

    public static String encodeSplatmap(boolean[] splatmap) {
        if (splatmap == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (boolean b2 : splatmap) {
            builder.append(b2 ? (char)'1' : '0');
        }
        return builder.toString();
    }

    public static boolean[] decodeSplatmap(String splatmapString) {
        boolean[] splatMap;
        if (splatmapString.length() > 0) {
            splatMap = new boolean[splatmapString.length()];
            for (int i2 = 0; i2 < splatmapString.length(); ++i2) {
                if (splatmapString.charAt(i2) != '1') continue;
                splatMap[i2] = true;
            }
        } else {
            splatMap = null;
        }
        return splatMap;
    }

    public static boolean[] buildSplatMap(Operand[] args2) {
        boolean[] splatMap = null;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            if (!(operand instanceof Splat)) continue;
            if (splatMap == null) {
                splatMap = new boolean[args2.length];
            }
            splatMap[i2] = true;
        }
        return splatMap;
    }

    public static boolean anyTrue(boolean[] booleans) {
        for (boolean b2 : booleans) {
            if (!b2) continue;
            return true;
        }
        return false;
    }

    public static boolean needsSplatting(boolean[] splatmap) {
        return splatmap != null && splatmap.length > 0 && IRRuntimeHelpers.anyTrue(splatmap);
    }

    public static final Type[] typesFromSignature(com.headius.invokebinder.Signature signature) {
        Type[] types = new Type[signature.argCount()];
        for (int i2 = 0; i2 < signature.argCount(); ++i2) {
            types[i2] = Type.getType(signature.argType(i2));
        }
        return types;
    }

    @JIT
    public static RubyString newFrozenStringFromRaw(ThreadContext context, String str, String encoding2, int cr, String file2, int line) {
        return IRRuntimeHelpers.newFrozenString(context, IRRuntimeHelpers.newByteListFromRaw(context.runtime, str, encoding2), cr, file2, line);
    }

    @JIT
    public static final ByteList newByteListFromRaw(Ruby runtime2, String str, String encoding2) {
        return new ByteList(RubyEncoding.encodeISO(str), runtime2.getEncodingService().getEncodingFromString(encoding2), false);
    }

    @JIT
    public static RubyEncoding retrieveEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().getEncoding(IRRuntimeHelpers.retrieveJCodingsEncoding(context, name2));
    }

    @JIT
    public static Encoding retrieveJCodingsEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().findEncodingOrAliasEntry(name2.getBytes()).getEncoding();
    }

    @JIT
    public static RubyHash constructHashFromArray(Ruby runtime2, IRubyObject[] pairs) {
        int length2 = pairs.length / 2;
        boolean useSmallHash = length2 <= 10;
        RubyHash hash2 = useSmallHash ? RubyHash.newSmallHash(runtime2) : RubyHash.newHash(runtime2);
        int i2 = 0;
        while (i2 < pairs.length) {
            if (useSmallHash) {
                hash2.fastASetSmall(runtime2, pairs[i2++], pairs[i2++], true);
                continue;
            }
            hash2.fastASet(runtime2, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static RubyHash dupKwargsHashAndPopulateFromArray(ThreadContext context, RubyHash dupHash, IRubyObject[] pairs) {
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = dupHash.dupFast(context);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASetCheckString(runtime2, pairs[i2++], pairs[i2++]);
        }
        return hash2;
    }

    @JIT
    public static IRubyObject searchConst(ThreadContext context, StaticScope staticScope, String constName, boolean noPrivateConsts) {
        RubyClass object = context.runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(constName) : staticScope.getConstantInner(constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        }
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(constName));
        }
        return constant;
    }

    @JIT
    public static IRubyObject inheritedSearchConst(ThreadContext context, IRubyObject cmVal, String constName, boolean noPrivateConsts) {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    @JIT
    public static IRubyObject lexicalSearchConst(ThreadContext context, StaticScope staticScope, String constName) {
        IRubyObject constant = staticScope.getConstantInner(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    public static IRubyObject setInstanceVariable(IRubyObject self2, IRubyObject value2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    @Interp
    public static DynamicMethod newInterpretedMetaClass(Ruby runtime2, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(runtime2, metaClassBody.getStaticScope(), obj, metaClassBody.maybeUsingRefinements());
        return new InterpretedIRMetaClassBody(metaClassBody, singletonClass);
    }

    @JIT
    public static DynamicMethod newCompiledMetaClass(ThreadContext context, MethodHandle handle, StaticScope scope, IRubyObject obj, int line, boolean refinements, boolean dynscopeEliminated) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(context.runtime, scope, obj, refinements);
        return new CompiledIRNoProtocolMethod(handle, scope, scope.getFile(), line, singletonClass, !dynscopeEliminated);
    }

    private static RubyClass newMetaClassFromIR(Ruby runtime2, StaticScope scope, IRubyObject obj, boolean refinements) {
        RubyClass singletonClass = Helpers.getSingletonClass(runtime2, obj);
        scope.setModule(singletonClass);
        if (refinements) {
            scope.captureParentRefinements(runtime2.getCurrentContext());
        }
        return singletonClass;
    }

    @JIT
    public static DynamicMethod newCompiledModuleBody(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, Object rubyContainer, boolean maybeRefined) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, id2, scope, rubyContainer, maybeRefined);
        return new CompiledIRMethod(handle, id2, line, scope, Visibility.PUBLIC, newRubyModule);
    }

    @Interp
    @JIT
    public static RubyModule newRubyModuleFromIR(ThreadContext context, String id2, StaticScope scope, Object rubyContainer, boolean maybeRefined) {
        if (!(rubyContainer instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        RubyModule newRubyModule = ((RubyModule)rubyContainer).defineOrGetModuleUnder(id2);
        scope.setModule(newRubyModule);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        return newRubyModule;
    }

    @JIT
    public static DynamicMethod newCompiledClassBody(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, Object container, Object superClass, boolean maybeRefined) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, id2, scope, superClass, container, maybeRefined);
        return new CompiledIRMethod(handle, id2, line, scope, Visibility.PUBLIC, newRubyClass);
    }

    @Interp
    @JIT
    public static RubyModule newRubyClassFromIR(Ruby runtime2, String id2, StaticScope scope, Object superClass, Object container, boolean maybeRefined) {
        RubyClass sc;
        if (!(container instanceof RubyModule)) {
            throw runtime2.newTypeError("no outer class/module");
        }
        if (superClass == UndefinedValue.UNDEFINED) {
            sc = null;
        } else {
            RubyClass.checkInheritable((IRubyObject)superClass);
            sc = (RubyClass)superClass;
        }
        RubyClass newRubyClass = ((RubyModule)container).defineOrGetClassUnder(id2, sc);
        scope.setModule(newRubyClass);
        if (maybeRefined) {
            scope.captureParentRefinements(runtime2.getCurrentContext());
        }
        return newRubyClass;
    }

    @Interp
    public static void defInterpretedClassMethod(ThreadContext context, IRScope method2, IRubyObject obj) {
        String id2 = method2.getId();
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (method2.maybeUsingRefinements()) {
            method2.getStaticScope().captureParentRefinements(context);
        }
        AbstractIRMethod newMethod = context.runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method2, Visibility.PUBLIC, rubyClass) : new MixedModeIRMethod(method2, Visibility.PUBLIC, rubyClass);
        rubyClass.addMethod(id2, newMethod);
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", method2.getName());
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, IRubyObject obj, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        rubyClass.addMethod(id2, new CompiledIRMethod(handle, null, -1, id2, line, scope, Visibility.PUBLIC, rubyClass, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.newSymbol(id2));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, IRubyObject obj, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        rubyClass.addMethod(id2, new CompiledIRMethod(variable, specific, specificArity, id2, line, scope, Visibility.PUBLIC, rubyClass, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.newSymbol(id2));
        }
    }

    private static RubyClass checkClassForDef(ThreadContext context, String id2, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol || obj instanceof RubyFloat) {
            throw context.runtime.newTypeError(RubyStringBuilder.str(context.runtime, "can't define singleton method \"", RubyStringBuilder.ids(context.runtime, id2), "\" for ", obj.getMetaClass().rubyBaseName()));
        }
        return obj.getSingletonClass();
    }

    @Interp
    public static void defInterpretedInstanceMethod(ThreadContext context, IRScope method2, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        RubySymbol methodName = method2.getName();
        RubyModule rubyClass = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime2, rubyClass, methodName, currVisibility);
        if (method2.maybeUsingRefinements()) {
            method2.getStaticScope().captureParentRefinements(context);
        }
        AbstractIRMethod newMethod = runtime2.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method2, newVisibility, rubyClass) : new MixedModeIRMethod(method2, newVisibility, rubyClass);
        Helpers.addInstanceMethod(rubyClass, methodName, (DynamicMethod)newMethod, currVisibility, context, runtime2);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, DynamicScope currDynScope, IRubyObject self2, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        Ruby runtime2 = context.runtime;
        RubySymbol methodName = runtime2.newSymbol(id2);
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime2, clazz, methodName, currVisibility);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        CompiledIRMethod newMethod = new CompiledIRMethod(handle, null, -1, id2, line, scope, newVisibility, clazz, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer);
        Helpers.addInstanceMethod(clazz, methodName, (DynamicMethod)newMethod, currVisibility, context, runtime2);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, DynamicScope currDynScope, IRubyObject self2, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        Ruby runtime2 = context.runtime;
        RubySymbol methodName = runtime2.newSymbol(id2);
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime2, clazz, methodName, currVisibility);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        CompiledIRMethod newMethod = new CompiledIRMethod(variable, specific, specificArity, id2, line, scope, newVisibility, clazz, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer);
        Helpers.addInstanceMethod(clazz, methodName, (DynamicMethod)newMethod, currVisibility, context, runtime2);
    }

    @JIT
    public static IRubyObject invokeModuleBody(ThreadContext context, DynamicMethod method2, Block block) {
        RubyModule implClass = method2.getImplementationClass();
        return method2.call(context, (IRubyObject)implClass, implClass, "", block);
    }

    @JIT
    public static IRubyObject invokeModuleBody(ThreadContext context, DynamicMethod method2) {
        RubyModule implClass = method2.getImplementationClass();
        return method2.call(context, (IRubyObject)implClass, implClass, "", Block.NULL_BLOCK);
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject[] pieces, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, pieces);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2, arg3);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2, arg3, arg4);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, RegexpOptions options2) {
        RubyRegexp re = RubyRegexp.newRegexp(context.runtime, source2, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, int embeddedOptions) {
        return IRRuntimeHelpers.newLiteralRegexp(context, source2, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    @JIT
    public static RubyArray irSplat(ThreadContext context, IRubyObject ary) {
        Ruby runtime2 = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, runtime2.getArray(), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        tmp = tmp.isNil() ? runtime2.newArray(ary) : ((RubyArray)tmp).aryDup();
        return (RubyArray)tmp;
    }

    @JIT
    @Interp
    public static RubyArray splatArray(ThreadContext context, IRubyObject ary, boolean dupArray) {
        Ruby runtime2 = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, runtime2.getArray(), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        if (tmp.isNil()) {
            tmp = runtime2.newArray(ary);
        } else if (dupArray) {
            tmp = ((RubyArray)tmp).aryDup();
        }
        return (RubyArray)tmp;
    }

    public static IRubyObject irToAry(ThreadContext context, IRubyObject value2) {
        return value2 instanceof RubyArray ? value2 : RubyArray.aryToAry(context, value2);
    }

    public static int irReqdArgMultipleAsgnIndex(int n, int preArgsCount, int index2, int postArgsCount) {
        if (preArgsCount == -1) {
            return index2 < n ? index2 : -1;
        }
        int remaining = n - preArgsCount;
        if (remaining <= index2) {
            return -1;
        }
        return remaining > postArgsCount ? n - postArgsCount + index2 : preArgsCount + index2;
    }

    public static IRubyObject irReqdArgMultipleAsgn(ThreadContext context, RubyArray rubyArray, int preArgsCount, int index2, int postArgsCount) {
        int i2 = IRRuntimeHelpers.irReqdArgMultipleAsgnIndex(rubyArray.getLength(), preArgsCount, index2, postArgsCount);
        return i2 == -1 ? context.nil : rubyArray.entry(i2);
    }

    public static IRubyObject irNot(ThreadContext context, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, !obj.isTrue());
    }

    @JIT
    public static RaiseException newRequiredKeywordArgumentError(ThreadContext context, String id2) {
        return context.runtime.newArgumentError(RubyStringBuilder.str(context.runtime, "missing keyword: ", RubyStringBuilder.ids(context.runtime, id2)));
    }

    public static void pushExitBlock(ThreadContext context, Block blk) {
        context.runtime.pushEndBlock(context.runtime.newProc(Block.Type.LAMBDA, blk));
    }

    @JIT
    public static void pushExitBlock(ThreadContext context, Object blk) {
        context.runtime.pushEndBlock(context.runtime.newProc(Block.Type.LAMBDA, IRRuntimeHelpers.getBlockFromObject(context, blk)));
    }

    @JIT
    public static FunctionalCachingCallSite newFunctionalCachingCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static ProfilingCachingCallSite newProfilingCachingCallSite(CallType callType, String name2, IRScope scope, long callSiteId) {
        return new ProfilingCachingCallSite(callType, name2, scope, callSiteId);
    }

    @JIT
    public static MonomorphicCallSite newMonomorphicCallSite(String name2) {
        return new MonomorphicCallSite(name2);
    }

    @JIT
    public static VariableCachingCallSite newVariableCachingCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    @JIT
    public static RefinedCachingCallSite newRefinedCachingCallSite(String name2, StaticScope scope, String callType) {
        return new RefinedCachingCallSite(name2, scope, CallType.valueOf(callType));
    }

    @JIT
    public static IRScope decodeScopeFromBytes(Ruby runtime2, byte[] scopeBytes, String filename2) {
        try {
            return IRReader.load(runtime2.getIRManager(), new IRReaderStream(runtime2.getIRManager(), scopeBytes, filename2));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @JIT
    public static VariableAccessor getVariableAccessorForRead(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForRead(name2);
    }

    @JIT
    public static VariableAccessor getVariableAccessorForWrite(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForWrite(name2);
    }

    @JIT
    public static IRubyObject getVariableWithAccessor(IRubyObject self2, VariableAccessor accessor, ThreadContext context, String name2) {
        Ruby runtime2 = context.runtime;
        IRubyObject result2 = (IRubyObject)accessor.get(self2);
        if (result2 == null) {
            if (runtime2.isVerbose()) {
                runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, RubyStringBuilder.str(runtime2, "instance variable ", RubyStringBuilder.ids(runtime2, name2), " not initialized"));
            }
            result2 = context.nil;
        }
        return result2;
    }

    @JIT
    public static void setVariableWithAccessor(IRubyObject self2, IRubyObject value2, VariableAccessor accessor) {
        accessor.set(self2, value2);
    }

    @JIT
    public static RubyFixnum getArgScopeDepth(ThreadContext context, StaticScope currScope) {
        int i2 = 0;
        while (!currScope.isArgumentScope()) {
            currScope = currScope.getEnclosingScope();
            ++i2;
        }
        return context.runtime.newFixnum(i2);
    }

    public static IRubyObject[] toAry(ThreadContext context, IRubyObject[] args2) {
        IRubyObject ary;
        if (args2.length == 1 && (ary = Helpers.aryOrToAry(context, args2[0])) != context.nil) {
            if (ary instanceof RubyArray) {
                args2 = ((RubyArray)ary).toJavaArray();
            } else {
                throw context.runtime.newTypeError(args2[0].getType().getName() + "#to_ary should return Array");
            }
        }
        return args2;
    }

    private static IRubyObject[] prepareProcArgs(ThreadContext context, Block b2, IRubyObject[] args2) {
        if (args2.length != 1) {
            return args2;
        }
        return IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], b2.getBody().getSignature());
    }

    private static IRubyObject[] prepareBlockArgsInternal(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                Signature sig = block.getBody().getSignature();
                if (sig.arityValue() != -1 && sig.required() != 1) {
                    args2 = IRRuntimeHelpers.toAry(context, args2);
                }
                sig.checkArity(context.runtime, args2);
                return args2;
            }
            case PROC: {
                return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
            }
        }
        Signature sig = block.getBody().getSignature();
        int arityValue = sig.arityValue();
        if (!sig.hasKwargs() && arityValue >= -1 && arityValue <= 1) {
            return args2;
        }
        args2 = IRRuntimeHelpers.toAry(context, args2);
        int needsKwargs = sig.hasKwargs() ? 1 - sig.getRequiredKeywordForArityCount() : 0;
        int required = sig.required();
        int actual = args2.length;
        if (needsKwargs == 0 || required > actual) {
            return args2;
        }
        if (sig.isFixed() && required > 0 && required + needsKwargs != actual) {
            int len = required + needsKwargs;
            IRubyObject[] newArgs = ArraySupport.newCopy(args2, len);
            newArgs[len - 1] = actual < len ? RubyHash.newHash(context.runtime) : args2[args2.length - 1];
            args2 = newArgs;
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareNoBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        if (block.type == Block.Type.LAMBDA) {
            block.getSignature().checkArity(context.runtime, args2);
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareSingleBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                block.getBody().getSignature().checkArity(context.runtime, args2);
                return args2;
            }
            case PROC: {
                args2 = args2.length == 0 ? context.runtime.getSingleNilArray() : (args2.length == 1 ? IRRuntimeHelpers.prepareProcArgs(context, block, args2) : new IRubyObject[]{args2[0]});
            }
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareFixedBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                block.getBody().getSignature().checkArity(context.runtime, args2);
                return args2;
            }
            case PROC: {
                return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
            }
        }
        return IRRuntimeHelpers.toAry(context, args2);
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareBlockArgs(ThreadContext context, Block block, IRubyObject[] args2, boolean usesKwArgs) {
        args2 = IRRuntimeHelpers.prepareBlockArgsInternal(context, block, args2);
        if (usesKwArgs) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, block.getBody().getSignature().required());
        }
        return args2;
    }

    private static DynamicScope getNewBlockScope(Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = block.getBinding().getDynamicScope();
        if (pushNewDynScope) {
            return block.allocScope(newScope);
        }
        if (reuseParentDynScope) {
            return newScope;
        }
        return null;
    }

    @Interp
    public static DynamicScope pushBlockDynamicScopeIfNeeded(ThreadContext context, Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = IRRuntimeHelpers.getNewBlockScope(block, pushNewDynScope, reuseParentDynScope);
        if (newScope != null) {
            context.pushScope(newScope);
        }
        return newScope;
    }

    @JIT
    public static DynamicScope pushBlockDynamicScopeNew(ThreadContext context, Block block) {
        DynamicScope newScope = block.allocScope(block.getBinding().getDynamicScope());
        context.pushScope(newScope);
        return newScope;
    }

    @JIT
    public static DynamicScope pushBlockDynamicScopeReuse(ThreadContext context, Block block) {
        DynamicScope newScope = block.getBinding().getDynamicScope();
        context.pushScope(newScope);
        return newScope;
    }

    @Interp
    @JIT
    public static IRubyObject updateBlockState(Block block, IRubyObject self2) {
        if (self2 == null || block.getEvalType() == EvalType.BINDING_EVAL) {
            self2 = IRRuntimeHelpers.useBindingSelf(block.getBinding());
        }
        return self2;
    }

    public static IRubyObject useBindingSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    @JIT
    public static RubyProc newSymbolProc(ThreadContext context, ByteList value2) {
        RubySymbol symbol = RubySymbol.newSymbol(context.runtime, value2);
        return IRRuntimeHelpers.newSymbolProc(context, symbol);
    }

    @Interp
    public static RubyProc newSymbolProc(ThreadContext context, RubySymbol symbol) {
        return (RubyProc)symbol.to_proc(context);
    }

    @JIT
    public static IRubyObject[] singleBlockArgToArray(IRubyObject value2) {
        IRubyObject[] iRubyObjectArray;
        if (value2 instanceof RubyArray) {
            iRubyObjectArray = ((RubyArray)value2).toJavaArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = value2;
        }
        return iRubyObjectArray;
    }

    @JIT
    public static Block prepareBlock(ThreadContext context, IRubyObject self2, DynamicScope scope, BlockBody body) {
        Binding binding2 = IRRuntimeHelpers.newFrameScopeBinding(context, self2, scope);
        return new Block(body, binding2);
    }

    public static Binding newFrameScopeBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        Frame frame = context.getCurrentFrame().capture();
        Binding binding2 = new Binding(self2, frame, frame.getVisibility(), scope);
        binding2.setMethod(frame.getName());
        return binding2;
    }

    public static RubyString newFrozenString(ThreadContext context, ByteList bytelist, int coderange, String file2, int line) {
        Ruby runtime2 = context.runtime;
        RubyString string2 = RubyString.newString(runtime2, bytelist, coderange);
        if (runtime2.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            RubyArray info = (RubyArray)runtime2.newArray(runtime2.newString(file2).freeze(context), (IRubyObject)runtime2.newFixnum(line)).freeze(context);
            string2.setInstanceVariable("@debug_created_info", info);
            string2.setFrozen(true);
        } else {
            string2 = runtime2.freezeAndDedupString(string2);
        }
        return string2;
    }

    @JIT
    @Interp
    public static RubyString freezeLiteralString(RubyString string2) {
        string2.setFrozen(true);
        return string2;
    }

    @JIT
    @Interp
    public static RubyString freezeLiteralString(RubyString string2, ThreadContext context, String file2, int line) {
        Ruby runtime2 = context.runtime;
        if (runtime2.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            RubyArray info = (RubyArray)runtime2.newArray(runtime2.newString(file2).freeze(context), (IRubyObject)runtime2.newFixnum(line)).freeze(context);
            string2.setInstanceVariable("@debug_created_info", info);
        }
        return IRRuntimeHelpers.freezeLiteralString(string2);
    }

    @JIT
    public static IRubyObject callOptimizedAref(ThreadContext context, IRubyObject caller2, IRubyObject target, RubyString keyStr, CallSite site) {
        if (target instanceof RubyHash && ((CachingCallSite)site).isBuiltin(target)) {
            return ((RubyHash)target).op_aref(context, keyStr);
        }
        return site.call(context, caller2, target, (IRubyObject)keyStr.strDup(context.runtime));
    }

    @JIT
    public static RubyString asString(ThreadContext context, IRubyObject caller2, IRubyObject target, CallSite site) {
        IRubyObject str = site.call(context, caller2, target);
        if (!(str instanceof RubyString)) {
            return (RubyString)target.anyToString();
        }
        if (target.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @JIT
    public static RubyArray newArray(ThreadContext context) {
        return RubyArray.newEmptyArray(context.runtime);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj) {
        return RubyArray.newArray(context.runtime, obj);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj0, IRubyObject obj1) {
        return RubyArray.newArray(context.runtime, obj0, obj1);
    }

    @JIT
    @Interp
    public static RubyString getFileNameStringFromScope(ThreadContext context, StaticScope currScope) {
        String file2 = currScope.getFile();
        return context.runtime.newString(file2);
    }

    @JIT
    public static void callTrace(ThreadContext context, RubyEvent event2, String name2, String filename2, int line) {
        if (context.runtime.hasEventHooks()) {
            int linenumber = line == -1 ? context.getLine() : line;
            context.trace(event2, name2, context.getFrameKlazz(), filename2, linenumber);
        }
    }

    public static void warnSetConstInRefinement(ThreadContext context, IRubyObject self2) {
        if (self2 instanceof RubyModule && ((RubyModule)self2).isRefinement()) {
            context.runtime.getWarnings().warn("not defined at the refinement, but at the outer class/module");
        }
    }

    @JIT
    public static void putConst(ThreadContext context, IRubyObject self2, RubyModule module, String id2, IRubyObject value2) {
        IRRuntimeHelpers.warnSetConstInRefinement(context, self2);
        module.setConstant(id2, value2);
    }

    @JIT
    public static void putClassVariable(ThreadContext context, IRubyObject self2, RubyModule module, String id2, IRubyObject value2) {
        IRRuntimeHelpers.warnSetConstInRefinement(context, self2);
        module.setClassVar(id2, value2);
    }

    @JIT
    public static RubyRational newRationalCanonicalize(ThreadContext context, IRubyObject num, IRubyObject den) {
        return (RubyRational)RubyRational.newRationalCanonicalize(context, num, den);
    }

    @JIT
    public static RubyComplex newComplexRaw(ThreadContext context, IRubyObject i2) {
        return RubyComplex.newComplexRawImage(context.runtime, i2);
    }

    @JIT
    public static RubySymbol newDSymbol(ThreadContext context, IRubyObject symbol) {
        return context.runtime.newSymbol(symbol.asString().getByteList());
    }

    @JIT
    public static RubyClass getStandardError(ThreadContext context) {
        return context.runtime.getStandardError();
    }

    @JIT
    public static RubyClass getObject(ThreadContext context) {
        return context.runtime.getObject();
    }

    @JIT
    @Interp
    public static IRubyObject svalue(ThreadContext context, Object val) {
        return val instanceof RubyArray ? (RubyArray)val : context.nil;
    }

    @JIT
    public static void aliasGlobalVariable(Ruby runtime2, Object newName, Object oldName) {
        runtime2.getGlobalVariables().alias(newName.toString(), oldName.toString());
    }

    private static JavaSites.IRRuntimeHelpersSites sites(ThreadContext context) {
        return context.sites.IRRuntimeHelpers;
    }

    private static class KwargMergeVisitor
    extends RubyHash.VisitorWithState<Block> {
        final RubyHash target;

        KwargMergeVisitor(RubyHash target) {
            this.target = target;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            TypeConverter.checkType(context, key2, context.runtime.getSymbol());
            this.target.op_aset(context, key2, value2);
        }
    }

    private static class GatherUnwantedKeywordsVisitor
    extends RubyHash.VisitorWithState<StaticScope> {
        ArrayList invalidKwargs;

        private GatherUnwantedKeywordsVisitor() {
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            String javaName = key2.asJavaString();
            if (!scope.keywordExists(javaName)) {
                if (this.invalidKwargs == null) {
                    this.invalidKwargs = new ArrayList();
                }
                this.invalidKwargs.add(javaName);
            }
        }

        public void raiseIfError(ThreadContext context) {
            if (this.invalidKwargs != null) {
                String invalidKwargs = this.invalidKwargs.toString();
                throw context.runtime.newArgumentError((this.invalidKwargs.size() == 1 ? "unknown keyword: " : "unknown keywords: ") + invalidKwargs.substring(1, invalidKwargs.length() - 1));
            }
        }
    }

    private static class InvalidKeyException
    extends RuntimeException {
        private InvalidKeyException() {
        }
    }

    private static class DivvyKeywordsVisitor
    extends RubyHash.VisitorWithState {
        RubyHash syms;
        RubyHash others;

        private DivvyKeywordsVisitor() {
        }

        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Object unused2) {
            if (key2 instanceof RubySymbol) {
                if (this.syms == null) {
                    this.syms = RubyHash.newSmallHash(context.runtime);
                }
                this.syms.fastASetSmall(key2, value2);
            } else {
                if (this.others == null) {
                    this.others = RubyHash.newSmallHash(context.runtime);
                }
                this.others.fastASetSmall(key2, value2);
            }
        }
    }
}

