/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestModifyTableProcedureWithRecovery
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyTableProcedureWithRecovery.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.snapshot.before.destructive.action.enabled", true);
        TestTableDDLProcedureBase.setupCluster();
    }

    @Test
    public void testRecoverySnapshotRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf1 = "cf1";
        String cf2 = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf2");
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], "cf1", "cf2");
        UTIL.getAdmin().disableTable(tableName);
        TableDescriptor originalHtd = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor modifiedHtd = TableDescriptorBuilder.newBuilder((TableDescriptor)originalHtd).removeColumnFamily("cf2".getBytes()).build();
        long procId = procExec.submitProcedure((Procedure)new FailingModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedHtd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((String)"Procedure should have failed", (boolean)result.isFailed());
        boolean snapshotFound = false;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            snapshotFound = true;
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should have been cleaned up during rollback", (!snapshotFound ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverySnapshotAndRestore() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName restoredTableName = TableName.valueOf((String)(this.name.getMethodName() + "_restored"));
        String cf1 = "cf1";
        String cf2 = "cf2";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf2");
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], "cf1", "cf2");
        UTIL.getAdmin().disableTable(tableName);
        TableDescriptor originalHtd = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor modifiedHtd = TableDescriptorBuilder.newBuilder((TableDescriptor)originalHtd).removeColumnFamily("cf2".getBytes()).build();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedHtd));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((String)"Should have one column family", (long)1L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertTrue((String)"Should only have cf1", (boolean)currentHtd.hasColumnFamily("cf1".getBytes()));
        String recoverySnapshotName = null;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            recoverySnapshotName = snapshot.getName();
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should exist", (recoverySnapshotName != null ? 1 : 0) != 0);
        UTIL.getAdmin().cloneSnapshot(recoverySnapshotName, restoredTableName);
        UTIL.waitUntilAllRegionsAssigned(restoredTableName);
        TableDescriptor restoredHtd = UTIL.getAdmin().getDescriptor(restoredTableName);
        Assert.assertEquals((String)"Should have two column families", (long)2L, (long)restoredHtd.getColumnFamilyNames().size());
        Assert.assertTrue((String)"Should have cf1", (boolean)restoredHtd.hasColumnFamily("cf1".getBytes()));
        Assert.assertTrue((String)"Should have cf2", (boolean)restoredHtd.hasColumnFamily("cf2".getBytes()));
        UTIL.getAdmin().disableTable(restoredTableName);
        UTIL.getAdmin().deleteTable(restoredTableName);
    }

    public static class FailingModifyTableProcedure
    extends ModifyTableProcedure {
        private boolean failOnce = false;

        public FailingModifyTableProcedure() {
        }

        public FailingModifyTableProcedure(MasterProcedureEnv env, TableDescriptor newTableDescriptor) throws HBaseIOException {
            super(env, newTableDescriptor);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws InterruptedException {
            if (!this.failOnce && state == MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_CLOSE_EXCESS_REPLICAS) {
                this.failOnce = true;
                throw new RuntimeException("Simulated failure");
            }
            return super.executeFromState(env, state);
        }
    }
}

