/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.gax.rpc.ApiException;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReaderFactory;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryStorageStreamBundleSource<@UnknownKeyFor T>
extends OffsetBasedSource<T> {
    private final @UnknownKeyFor @NonNull @Initialized ReadSession readSession;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ReadStream> streamBundle;
    private final @UnknownKeyFor @NonNull @Initialized String jsonTableSchema;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;

    public static <T> @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleSource<T> create(@UnknownKeyFor @NonNull @Initialized ReadSession readSession, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ReadStream> streamBundle, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        return new BigQueryStorageStreamBundleSource<T>(readSession, streamBundle, BigQueryHelpers.toJsonString(Preconditions.checkArgumentNotNull((Object)tableSchema, (Object)"tableSchema")), parseFn, outputCoder, bqServices, minBundleSize);
    }

    public @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleSource<T> fromExisting(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ReadStream> newStreamBundle) {
        return new BigQueryStorageStreamBundleSource<T>(this.readSession, newStreamBundle, this.jsonTableSchema, this.parseFn, this.outputCoder, this.bqServices, this.getMinBundleSize());
    }

    private BigQueryStorageStreamBundleSource(@UnknownKeyFor @NonNull @Initialized ReadSession readSession, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ReadStream> streamBundle, @UnknownKeyFor @NonNull @Initialized String jsonTableSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        super(0L, (long)streamBundle.size(), minBundleSize);
        this.readSession = (ReadSession)Preconditions.checkArgumentNotNull((Object)readSession, (Object)"readSession");
        this.streamBundle = (List)Preconditions.checkArgumentNotNull(streamBundle, (Object)"streams");
        this.jsonTableSchema = (String)Preconditions.checkArgumentNotNull((Object)jsonTableSchema, (Object)"jsonTableSchema");
        this.parseFn = (SerializableFunction)Preconditions.checkArgumentNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)Preconditions.checkArgumentNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)Preconditions.checkArgumentNotNull((Object)bqServices, (Object)"bqServices");
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", (String)this.readSession.getTable()).withLabel("Table")).add(DisplayData.item((String)"readSession", (String)this.readSession.getName()).withLabel("Read session"));
        for (ReadStream readStream : this.streamBundle) {
            builder.add(DisplayData.item((String)"stream", (String)readStream.getName()).withLabel("Stream"));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return 0L;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return ImmutableList.of((Object)((Object)this));
    }

    public @UnknownKeyFor @NonNull @Initialized long getMaxEndOffset(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.streamBundle.size();
    }

    public @UnknownKeyFor @NonNull @Initialized OffsetBasedSource<T> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        List<ReadStream> newStreamBundle = this.streamBundle.subList((int)start, (int)end);
        return this.fromExisting(newStreamBundle);
    }

    public @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new BigQueryStorageStreamBundleReader(this, (BigQueryOptions)options.as(BigQueryOptions.class));
    }

    public static class BigQueryStorageStreamBundleReader<@UnknownKeyFor T>
    extends OffsetBasedSource.OffsetBasedReader<T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageStreamBundleReader.class);
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageReader reader;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryServices.StorageClient storageClient;
        private final @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema;
        private @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleSource<T> source;
        private @Nullable @UnknownKeyFor @Initialized BigQueryServices.BigQueryServerStream<@UnknownKeyFor @NonNull @Initialized ReadRowsResponse> responseStream = null;
        private @Nullable @UnknownKeyFor @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ReadRowsResponse> responseIterator = null;
        private @Nullable T current = null;
        private @UnknownKeyFor @NonNull @Initialized int currentStreamBundleIndex;
        private @UnknownKeyFor @NonNull @Initialized long currentStreamOffset;
        private @UnknownKeyFor @NonNull @Initialized double fractionOfStreamBundleConsumed;
        private @UnknownKeyFor @NonNull @Initialized double progressAtResponseStart;
        private @UnknownKeyFor @NonNull @Initialized double progressAtResponseEnd;
        private @UnknownKeyFor @NonNull @Initialized long rowsConsumedFromCurrentResponse;
        private @UnknownKeyFor @NonNull @Initialized long totalRowsInCurrentResponse;
        private @Nullable @UnknownKeyFor @Initialized TableReference tableReference;
        private @Nullable @UnknownKeyFor @Initialized ServiceCallMetric serviceCallMetric;

        private BigQueryStorageStreamBundleReader(@UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleSource<T> source, @UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            super(source);
            this.source = source;
            this.reader = BigQueryStorageReaderFactory.getReader(((BigQueryStorageStreamBundleSource)source).readSession);
            this.parseFn = ((BigQueryStorageStreamBundleSource)source).parseFn;
            this.storageClient = ((BigQueryStorageStreamBundleSource)source).bqServices.getStorageClient(options);
            this.tableSchema = BigQueryHelpers.fromJsonString(((BigQueryStorageStreamBundleSource)source).jsonTableSchema, TableSchema.class);
            this.currentStreamBundleIndex = 0;
            this.fractionOfStreamBundleConsumed = 0.0;
            this.progressAtResponseStart = 0.0;
            this.progressAtResponseEnd = 0.0;
            this.rowsConsumedFromCurrentResponse = 0L;
            this.totalRowsInCurrentResponse = 0L;
        }

        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.currentStreamBundleIndex;
        }

        protected @UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.currentStreamOffset == 0L;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean startImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.readNextStream();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advanceImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkStateNotNull(this.responseIterator);
            this.currentStreamOffset += this.totalRowsInCurrentResponse;
            return this.readNextRecord();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean readNextStream() throws @UnknownKeyFor @NonNull @Initialized IOException {
            OffsetBasedSource source = this.getCurrentSource();
            if (this.currentStreamBundleIndex == ((BigQueryStorageStreamBundleSource)source).streamBundle.size()) {
                this.fractionOfStreamBundleConsumed = 1.0;
                return false;
            }
            ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(((ReadStream)((BigQueryStorageStreamBundleSource)source).streamBundle.get(this.currentStreamBundleIndex)).getName()).build();
            this.tableReference = BigQueryUtils.toTableReference(((BigQueryStorageStreamBundleSource)source).readSession.getTable());
            this.serviceCallMetric = BigQueryUtils.readCallMetric(this.tableReference);
            LOG.info("Started BigQuery Storage API read from stream {}.", (Object)((ReadStream)((BigQueryStorageStreamBundleSource)source).streamBundle.get(this.currentStreamBundleIndex)).getName());
            this.responseStream = this.storageClient.readRows(request, ((BigQueryStorageStreamBundleSource)source).readSession.getTable());
            this.responseIterator = this.responseStream.iterator();
            return this.readNextRecord();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresNonNull(value={"responseIterator"})
        private @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Iterator<ReadRowsResponse> responseIterator = this.responseIterator;
            if (responseIterator == null) {
                LOG.info("Received null responseIterator for stream {}", (Object)this.currentStreamBundleIndex);
                return false;
            }
            while (this.reader.readyForNextReadResponse()) {
                ReadRowsResponse response;
                if (!responseIterator.hasNext()) {
                    BigQueryStorageStreamBundleReader bigQueryStorageStreamBundleReader = this;
                    synchronized (bigQueryStorageStreamBundleReader) {
                        this.currentStreamOffset = 0L;
                        ++this.currentStreamBundleIndex;
                    }
                    return this.readNextStream();
                }
                try {
                    response = responseIterator.next();
                    if (this.serviceCallMetric != null) {
                        this.serviceCallMetric.call("ok");
                    }
                }
                catch (ApiException e) {
                    if (this.serviceCallMetric != null) {
                        this.serviceCallMetric.call(e.getStatusCode().getCode().name());
                    }
                    throw e;
                }
                this.progressAtResponseStart = response.getStats().getProgress().getAtResponseStart();
                this.progressAtResponseEnd = response.getStats().getProgress().getAtResponseEnd();
                this.totalRowsInCurrentResponse = response.getRowCount();
                this.rowsConsumedFromCurrentResponse = 0L;
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.totalRowsInCurrentResponse >= 0L ? 1 : 0) != 0, (String)"Row count from current response (%s) must be non-negative.", (long)this.totalRowsInCurrentResponse);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((0.0 <= this.progressAtResponseStart && this.progressAtResponseStart <= 1.0 ? 1 : 0) != 0, (String)"Progress at response start (%s) is not in the range [0.0, 1.0].", (Object)this.progressAtResponseStart);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((0.0 <= this.progressAtResponseEnd && this.progressAtResponseEnd <= 1.0 ? 1 : 0) != 0, (String)"Progress at response end (%s) is not in the range [0.0, 1.0].", (Object)this.progressAtResponseEnd);
                this.reader.processReadRowsResponse(response);
            }
            SchemaAndRecord schemaAndRecord = new SchemaAndRecord(this.reader.readSingleRecord(), this.tableSchema);
            this.current = this.parseFn.apply((Object)schemaAndRecord);
            ++this.rowsConsumedFromCurrentResponse;
            double fractionOfCurrentStreamConsumed = this.progressAtResponseStart + (this.progressAtResponseEnd - this.progressAtResponseStart) * ((double)this.rowsConsumedFromCurrentResponse * 1.0 / (double)this.totalRowsInCurrentResponse);
            this.fractionOfStreamBundleConsumed = ((double)this.currentStreamBundleIndex + fractionOfCurrentStreamConsumed) / (double)((BigQueryStorageStreamBundleSource)this.source).streamBundle.size();
            return true;
        }

        public synchronized void close() {
            Preconditions.checkStateNotNull((Object)this.storageClient);
            Preconditions.checkStateNotNull((Object)this.reader);
            this.storageClient.close();
            this.reader.close();
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamBundleSource<T> getCurrentSource() {
            return this.source;
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            return this.fractionOfStreamBundleConsumed;
        }
    }
}

