/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import org.apache.hop.beam.transforms.bigtable.BeamBigtableInputMeta;
import org.apache.hop.beam.transforms.bigtable.BigtableSourceColumn;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamBigtableInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamBigtableInputDialog.class;
    private final BeamBigtableInputMeta input;
    private TextVar wProjectId;
    private TextVar wInstanceId;
    private TextVar wTableId;
    private TextVar wKeyField;
    private TableView wColumns;

    public BeamBigtableInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamBigtableInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlProjectId = new Label((Composite)this.shell, 131072);
        wlProjectId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.ProjectId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProjectId);
        FormData fdlProjectId = new FormData();
        fdlProjectId.left = new FormAttachment(0, 0);
        fdlProjectId.top = new FormAttachment((Control)lastControl, margin);
        fdlProjectId.right = new FormAttachment(middle, -margin);
        wlProjectId.setLayoutData((Object)fdlProjectId);
        this.wProjectId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wProjectId);
        FormData fdProjectId = new FormData();
        fdProjectId.left = new FormAttachment(middle, 0);
        fdProjectId.top = new FormAttachment((Control)wlProjectId, 0, 0x1000000);
        fdProjectId.right = new FormAttachment(100, 0);
        this.wProjectId.setLayoutData((Object)fdProjectId);
        lastControl = this.wProjectId;
        Label wlInstanceId = new Label((Composite)this.shell, 131072);
        wlInstanceId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.InstanceId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInstanceId);
        FormData fdlInstanceId = new FormData();
        fdlInstanceId.left = new FormAttachment(0, 0);
        fdlInstanceId.top = new FormAttachment((Control)lastControl, margin);
        fdlInstanceId.right = new FormAttachment(middle, -margin);
        wlInstanceId.setLayoutData((Object)fdlInstanceId);
        this.wInstanceId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wInstanceId);
        FormData fdInstanceId = new FormData();
        fdInstanceId.left = new FormAttachment(middle, 0);
        fdInstanceId.top = new FormAttachment((Control)wlInstanceId, 0, 0x1000000);
        fdInstanceId.right = new FormAttachment(100, 0);
        this.wInstanceId.setLayoutData((Object)fdInstanceId);
        lastControl = this.wInstanceId;
        Label wlTableId = new Label((Composite)this.shell, 131072);
        wlTableId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.TableId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTableId);
        FormData fdlTableId = new FormData();
        fdlTableId.left = new FormAttachment(0, 0);
        fdlTableId.top = new FormAttachment((Control)lastControl, margin);
        fdlTableId.right = new FormAttachment(middle, -margin);
        wlTableId.setLayoutData((Object)fdlTableId);
        this.wTableId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTableId);
        FormData fdTableId = new FormData();
        fdTableId.left = new FormAttachment(middle, 0);
        fdTableId.top = new FormAttachment((Control)wlTableId, 0, 0x1000000);
        fdTableId.right = new FormAttachment(100, 0);
        this.wTableId.setLayoutData((Object)fdTableId);
        lastControl = this.wTableId;
        Label wlKeyField = new Label((Composite)this.shell, 131072);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.KeyField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyField);
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)lastControl, margin);
        fdlKeyField.right = new FormAttachment(middle, -margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wKeyField);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(middle, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        lastControl = this.wKeyField;
        Label wlColumns = new Label((Composite)this.shell, 16384);
        wlColumns.setText(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.Columns", (String[])new String[0]));
        PropsUi.setLook((Widget)wlColumns);
        FormData fdlColumns = new FormData();
        fdlColumns.left = new FormAttachment(0, 0);
        fdlColumns.top = new FormAttachment((Control)lastControl, margin);
        fdlColumns.right = new FormAttachment(100, 0);
        wlColumns.setLayoutData((Object)fdlColumns);
        lastControl = wlColumns;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.Column.Qualifier", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.Column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableInputDialog.Column.TargetName", (String[])new String[0]), 1, false, false)};
        columns[0].setUsingVariables(false);
        columns[1].setUsingVariables(false);
        columns[2].setUsingVariables(false);
        this.wColumns = new TableView(this.variables, (Composite)this.shell, 2048, columns, this.input.getSourceColumns().size(), null, this.props);
        FormData fdColumns = new FormData();
        fdColumns.left = new FormAttachment(0, 0);
        fdColumns.top = new FormAttachment((Control)lastControl, margin);
        fdColumns.right = new FormAttachment(100, 0);
        fdColumns.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wColumns.setLayoutData((Object)fdColumns);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wProjectId.setText(Const.NVL((String)this.input.getProjectId(), (String)""));
        this.wInstanceId.setText(Const.NVL((String)this.input.getInstanceId(), (String)""));
        this.wTableId.setText(Const.NVL((String)this.input.getTableId(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.input.getKeyField(), (String)""));
        for (int i = 0; i < this.input.getSourceColumns().size(); ++i) {
            BigtableSourceColumn column = this.input.getSourceColumns().get(i);
            TableItem item = this.wColumns.table.getItem(i);
            item.setText(1, Const.NVL((String)column.getQualifier(), (String)""));
            item.setText(2, Const.NVL((String)column.getTargetType(), (String)""));
            item.setText(3, Const.NVL((String)column.getTargetFieldName(), (String)""));
        }
        this.wColumns.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamBigtableInputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setProjectId(this.wProjectId.getText());
        in.setInstanceId(this.wInstanceId.getText());
        in.setTableId(this.wTableId.getText());
        in.setKeyField(this.wKeyField.getText());
        in.getSourceColumns().clear();
        for (TableItem item : this.wColumns.getNonEmptyItems()) {
            String qualifier = item.getText(1);
            String type = item.getText(2);
            String name = item.getText(3);
            in.getSourceColumns().add(new BigtableSourceColumn(qualifier, type, name));
        }
        this.input.setChanged();
    }
}

