/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.AbstractStrategyHolder;
import org.apache.cassandra.db.compaction.CompactionLogger;
import org.apache.cassandra.db.compaction.CompactionStrategyHolder;
import org.apache.cassandra.db.compaction.CompactionTasks;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.PendingRepairHolder;
import org.apache.cassandra.db.compaction.PendingRepairManager;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableMetadataChanged;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.apache.cassandra.repair.consistent.admin.CleanupSummary;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionStrategyManager
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CompactionStrategyManager.class);
    public final CompactionLogger compactionLogger;
    private final ColumnFamilyStore cfs;
    private final boolean partitionSSTablesByTokenRange;
    private final Supplier<DiskBoundaries> boundariesSupplier;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final PendingRepairHolder transientRepairs;
    private final PendingRepairHolder pendingRepairs;
    private final CompactionStrategyHolder repaired;
    private final CompactionStrategyHolder unrepaired;
    private final ImmutableList<AbstractStrategyHolder> holders;
    private volatile CompactionParams params;
    private DiskBoundaries currentBoundaries;
    private volatile boolean enabled;
    private volatile boolean isActive = true;
    private volatile CompactionParams schemaCompactionParams;
    private volatile boolean supportsEarlyOpen;
    private volatile int fanout;
    private volatile long maxSSTableSizeBytes;
    private volatile String name;

    public CompactionStrategyManager(ColumnFamilyStore cfs) {
        this(cfs, cfs::getDiskBoundaries, cfs.getPartitioner().splitter().isPresent());
    }

    @VisibleForTesting
    public CompactionStrategyManager(ColumnFamilyStore cfs, Supplier<DiskBoundaries> boundariesSupplier, boolean partitionSSTablesByTokenRange) {
        AbstractStrategyHolder.DestinationRouter router = new AbstractStrategyHolder.DestinationRouter(){

            @Override
            public int getIndexForSSTable(SSTableReader sstable) {
                return CompactionStrategyManager.this.compactionStrategyIndexFor(sstable);
            }

            @Override
            public int getIndexForSSTableDirectory(Descriptor descriptor) {
                return CompactionStrategyManager.this.compactionStrategyIndexForDirectory(descriptor);
            }
        };
        this.transientRepairs = new PendingRepairHolder(cfs, router, true);
        this.pendingRepairs = new PendingRepairHolder(cfs, router, false);
        this.repaired = new CompactionStrategyHolder(cfs, router, true);
        this.unrepaired = new CompactionStrategyHolder(cfs, router, false);
        this.holders = ImmutableList.of((Object)this.transientRepairs, (Object)this.pendingRepairs, (Object)this.repaired, (Object)this.unrepaired);
        cfs.getTracker().subscribe(this);
        logger.trace("{} subscribed to the data tracker.", (Object)this);
        this.cfs = cfs;
        this.compactionLogger = new CompactionLogger(cfs, this);
        this.boundariesSupplier = boundariesSupplier;
        this.partitionSSTablesByTokenRange = partitionSSTablesByTokenRange;
        this.params = cfs.metadata().params.compaction;
        this.enabled = this.params.isEnabled();
        this.reload(cfs.metadata().params.compaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (!this.isEnabled()) {
                AbstractCompactionTask abstractCompactionTask = null;
                return abstractCompactionTask;
            }
            int numPartitions = this.getNumTokenPartitions();
            AbstractCompactionTask repairFinishedTask = this.pendingRepairs.getNextRepairFinishedTask();
            if (repairFinishedTask != null) {
                AbstractCompactionTask abstractCompactionTask = repairFinishedTask;
                return abstractCompactionTask;
            }
            repairFinishedTask = this.transientRepairs.getNextRepairFinishedTask();
            if (repairFinishedTask != null) {
                AbstractCompactionTask abstractCompactionTask = repairFinishedTask;
                return abstractCompactionTask;
            }
            ArrayList<AbstractStrategyHolder.TaskSupplier> suppliers = new ArrayList<AbstractStrategyHolder.TaskSupplier>(numPartitions * this.holders.size());
            for (AbstractStrategyHolder holder : this.holders) {
                suppliers.addAll(holder.getBackgroundTaskSuppliers(gcBefore));
            }
            Collections.sort(suppliers);
            for (AbstractStrategyHolder.TaskSupplier supplier : suppliers) {
                AbstractCompactionTask task = supplier.getTask();
                if (task == null) continue;
                AbstractCompactionTask abstractCompactionTask = task;
                return abstractCompactionTask;
            }
            Object var5_8 = null;
            return var5_8;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    AbstractCompactionTask findUpgradeSSTableTask() {
        if (!this.isEnabled() || !DatabaseDescriptor.automaticSSTableUpgrade()) {
            return null;
        }
        Set<SSTableReader> compacting = this.cfs.getTracker().getCompacting();
        List potentialUpgrade = this.cfs.getLiveSSTables().stream().filter(s -> !compacting.contains(s) && !s.descriptor.version.isLatestVersion()).sorted((o1, o2) -> {
            File f1 = new File(o1.descriptor.filenameFor(Component.DATA));
            File f2 = new File(o2.descriptor.filenameFor(Component.DATA));
            return Longs.compare((long)f1.lastModified(), (long)f2.lastModified());
        }).collect(Collectors.toList());
        for (SSTableReader sstable : potentialUpgrade) {
            LifecycleTransaction txn = this.cfs.getTracker().tryModify(sstable, OperationType.UPGRADE_SSTABLES);
            if (txn == null) continue;
            logger.debug("Running automatic sstable upgrade for {}", (Object)sstable);
            return this.getCompactionStrategyFor(sstable).getCompactionTask(txn, Integer.MIN_VALUE, Long.MAX_VALUE);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled && this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void resume() {
        this.writeLock.lock();
        try {
            this.isActive = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void pause() {
        this.writeLock.lock();
        try {
            this.isActive = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startup() {
        this.writeLock.lock();
        try {
            for (SSTableReader sstable : this.cfs.getSSTables(SSTableSet.CANONICAL)) {
                if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                this.compactionStrategyFor(sstable).addSSTable(sstable);
            }
            this.holders.forEach(AbstractStrategyHolder::startup);
            this.supportsEarlyOpen = this.repaired.first().supportsEarlyOpen();
            this.fanout = this.repaired.first() instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.repaired.first()).getLevelFanoutSize() : 10;
            this.maxSSTableSizeBytes = this.repaired.first().getMaxSSTableBytes();
            this.name = this.repaired.first().getName();
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.repaired.first().logAll) {
            this.compactionLogger.enable();
        }
    }

    public AbstractCompactionStrategy getCompactionStrategyFor(SSTableReader sstable) {
        this.maybeReloadDiskBoundaries();
        return this.compactionStrategyFor(sstable);
    }

    @VisibleForTesting
    AbstractCompactionStrategy compactionStrategyFor(SSTableReader sstable) {
        this.readLock.lock();
        try {
            AbstractCompactionStrategy abstractCompactionStrategy = this.getHolder(sstable).getStrategyFor(sstable);
            return abstractCompactionStrategy;
        }
        finally {
            this.readLock.unlock();
        }
    }

    int compactionStrategyIndexFor(SSTableReader sstable) {
        this.readLock.lock();
        try {
            if (!this.partitionSSTablesByTokenRange) {
                int n = 0;
                return n;
            }
            int n = this.currentBoundaries.getDiskIndex(sstable);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private int compactionStrategyIndexForDirectory(Descriptor descriptor) {
        this.readLock.lock();
        try {
            int n = this.partitionSSTablesByTokenRange ? this.currentBoundaries.getBoundariesFromSSTableDirectory(descriptor) : 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    CompactionStrategyHolder getRepairedUnsafe() {
        return this.repaired;
    }

    @VisibleForTesting
    CompactionStrategyHolder getUnrepairedUnsafe() {
        return this.unrepaired;
    }

    @VisibleForTesting
    PendingRepairHolder getPendingRepairsUnsafe() {
        return this.pendingRepairs;
    }

    @VisibleForTesting
    PendingRepairHolder getTransientRepairsUnsafe() {
        return this.transientRepairs;
    }

    public boolean hasDataForPendingRepair(TimeUUID sessionID) {
        this.readLock.lock();
        try {
            boolean bl = this.pendingRepairs.hasDataForSession(sessionID) || this.transientRepairs.hasDataForSession(sessionID);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void shutdown() {
        this.writeLock.lock();
        try {
            this.isActive = false;
            this.holders.forEach(AbstractStrategyHolder::shutdown);
            this.compactionLogger.disable();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void maybeReload(TableMetadata metadata) {
        if (metadata.params.compaction.equals(this.schemaCompactionParams)) {
            return;
        }
        this.writeLock.lock();
        try {
            if (metadata.params.compaction.equals(this.schemaCompactionParams)) {
                return;
            }
            this.reload(metadata.params.compaction);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    protected void maybeReloadDiskBoundaries() {
        if (!this.currentBoundaries.isOutOfDate()) {
            return;
        }
        this.writeLock.lock();
        try {
            if (!this.currentBoundaries.isOutOfDate()) {
                return;
            }
            this.reload(this.params);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void reload(CompactionParams newCompactionParams) {
        boolean disabledWithJMX;
        boolean enabledWithJMX = this.enabled && !this.shouldBeEnabled();
        boolean bl = disabledWithJMX = !this.enabled && this.shouldBeEnabled();
        if (this.currentBoundaries != null) {
            if (!newCompactionParams.equals(this.schemaCompactionParams)) {
                logger.debug("Recreating compaction strategy - compaction parameters changed for {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
            } else if (this.currentBoundaries.isOutOfDate()) {
                logger.debug("Recreating compaction strategy - disk boundaries are out of date for {}.{}.", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
            }
        }
        if (this.currentBoundaries == null || this.currentBoundaries.isOutOfDate()) {
            this.currentBoundaries = this.boundariesSupplier.get();
        }
        this.setStrategy(newCompactionParams);
        this.schemaCompactionParams = this.cfs.metadata().params.compaction;
        if (disabledWithJMX || !this.shouldBeEnabled() && !enabledWithJMX) {
            this.disable();
        } else {
            this.enable();
        }
        this.startup();
    }

    private Iterable<AbstractCompactionStrategy> getAllStrategies() {
        return Iterables.concat((Iterable)Iterables.transform(this.holders, AbstractStrategyHolder::allStrategies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnleveledSSTables() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (this.repaired.first() instanceof LeveledCompactionStrategy) {
                int count = 0;
                for (AbstractCompactionStrategy strategy : this.getAllStrategies()) {
                    count += ((LeveledCompactionStrategy)strategy).getLevelSize(0);
                }
                int n = count;
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return 0;
    }

    public int getLevelFanoutSize() {
        return this.fanout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSSTableCountPerLevel() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (this.repaired.first() instanceof LeveledCompactionStrategy) {
                int[] res = new int[9];
                for (AbstractCompactionStrategy strategy : this.getAllStrategies()) {
                    int[] repairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSize();
                    res = CompactionStrategyManager.sumArrays(res, repairedCountPerLevel);
                }
                Object object = res;
                return object;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getPerLevelSizeBytes() {
        this.readLock.lock();
        try {
            if (this.repaired.first() instanceof LeveledCompactionStrategy) {
                long[] res = new long[9];
                for (AbstractCompactionStrategy strategy : this.getAllStrategies()) {
                    long[] repairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSizeBytes();
                    res = CompactionStrategyManager.sumArrays(res, repairedCountPerLevel);
                }
                Object object = res;
                return object;
            }
            long[] lArray = null;
            return lArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static int[] sumArrays(int[] a, int[] b) {
        int[] res = new int[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    static long[] sumArrays(long[] a, long[] b) {
        long[] res = new long[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    private void handleFlushNotification(Iterable<SSTableReader> added) {
        for (SSTableReader sstable : added) {
            this.compactionStrategyFor(sstable).addSSTable(sstable);
        }
    }

    private int getHolderIndex(SSTableReader sstable) {
        for (int i = 0; i < this.holders.size(); ++i) {
            if (!((AbstractStrategyHolder)this.holders.get(i)).managesSSTable(sstable)) continue;
            return i;
        }
        throw new IllegalStateException("No holder claimed " + sstable);
    }

    private AbstractStrategyHolder getHolder(SSTableReader sstable) {
        for (AbstractStrategyHolder holder : this.holders) {
            if (!holder.managesSSTable(sstable)) continue;
            return holder;
        }
        throw new IllegalStateException("No holder claimed " + sstable);
    }

    private AbstractStrategyHolder getHolder(long repairedAt, TimeUUID pendingRepair, boolean isTransient) {
        return this.getHolder(repairedAt != 0L, pendingRepair != ActiveRepairService.NO_PENDING_REPAIR, isTransient);
    }

    @VisibleForTesting
    AbstractStrategyHolder getHolder(boolean isRepaired, boolean isPendingRepair, boolean isTransient) {
        for (AbstractStrategyHolder holder : this.holders) {
            if (!holder.managesRepairedGroup(isRepaired, isPendingRepair, isTransient)) continue;
            return holder;
        }
        throw new IllegalStateException(String.format("No holder claimed isPendingRepair: %s, isPendingRepair %s", isRepaired, isPendingRepair));
    }

    @VisibleForTesting
    ImmutableList<AbstractStrategyHolder> getHolders() {
        return this.holders;
    }

    public List<AbstractStrategyHolder.GroupedSSTableContainer> groupSSTables(Iterable<SSTableReader> sstables) {
        ArrayList<AbstractStrategyHolder.GroupedSSTableContainer> classified = new ArrayList<AbstractStrategyHolder.GroupedSSTableContainer>(this.holders.size());
        for (AbstractStrategyHolder holder : this.holders) {
            classified.add(holder.createGroupedSSTableContainer());
        }
        for (SSTableReader sstable : sstables) {
            ((AbstractStrategyHolder.GroupedSSTableContainer)classified.get(this.getHolderIndex(sstable))).add(sstable);
        }
        return classified;
    }

    private void handleListChangedNotification(Iterable<SSTableReader> added, Iterable<SSTableReader> removed) {
        List<AbstractStrategyHolder.GroupedSSTableContainer> addedGroups = this.groupSSTables(added);
        List<AbstractStrategyHolder.GroupedSSTableContainer> removedGroups = this.groupSSTables(removed);
        for (int i = 0; i < this.holders.size(); ++i) {
            ((AbstractStrategyHolder)this.holders.get(i)).replaceSSTables(removedGroups.get(i), addedGroups.get(i));
        }
    }

    private void handleRepairStatusChangedNotification(Iterable<SSTableReader> sstables) {
        List<AbstractStrategyHolder.GroupedSSTableContainer> groups = this.groupSSTables(sstables);
        for (int i = 0; i < this.holders.size(); ++i) {
            AbstractStrategyHolder.GroupedSSTableContainer group = groups.get(i);
            if (group.isEmpty()) continue;
            AbstractStrategyHolder dstHolder = (AbstractStrategyHolder)this.holders.get(i);
            for (AbstractStrategyHolder holder : this.holders) {
                if (holder == dstHolder) continue;
                holder.removeSSTables(group);
            }
            dstHolder.addSSTables(group);
        }
    }

    private void handleMetadataChangedNotification(SSTableReader sstable, StatsMetadata oldMetadata) {
        this.compactionStrategyFor(sstable).metadataChanged(oldMetadata, sstable);
    }

    private void handleDeletingNotification(SSTableReader deleted) {
        this.compactionStrategyFor(deleted).removeSSTable(deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(INotification notification, Object sender) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (notification instanceof SSTableAddedNotification) {
                SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
                this.handleFlushNotification(flushedNotification.added);
            } else if (notification instanceof SSTableListChangedNotification) {
                SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
                this.handleListChangedNotification(listChangedNotification.added, listChangedNotification.removed);
            } else if (notification instanceof SSTableRepairStatusChanged) {
                this.handleRepairStatusChangedNotification(((SSTableRepairStatusChanged)notification).sstables);
            } else if (notification instanceof SSTableDeletingNotification) {
                this.handleDeletingNotification(((SSTableDeletingNotification)notification).deleting);
            } else if (notification instanceof SSTableMetadataChanged) {
                SSTableMetadataChanged lcNotification = (SSTableMetadataChanged)notification;
                this.handleMetadataChangedNotification(lcNotification.sstable, lcNotification.oldMetadata);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enable() {
        this.writeLock.lock();
        try {
            this.enabled = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void disable() {
        this.writeLock.lock();
        try {
            this.enabled = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionStrategy.ScannerList maybeGetScanners(Collection<SSTableReader> sstables, Collection<Range<Token>> ranges) {
        this.maybeReloadDiskBoundaries();
        ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(sstables.size());
        this.readLock.lock();
        try {
            List<AbstractStrategyHolder.GroupedSSTableContainer> sstableGroups = this.groupSSTables(sstables);
            for (int i = 0; i < this.holders.size(); ++i) {
                AbstractStrategyHolder holder = (AbstractStrategyHolder)this.holders.get(i);
                AbstractStrategyHolder.GroupedSSTableContainer group = sstableGroups.get(i);
                scanners.addAll(holder.getScanners(group, ranges));
            }
        }
        catch (PendingRepairManager.IllegalSSTableArgumentException e) {
            ISSTableScanner.closeAllAndPropagate(scanners, new ConcurrentModificationException(e));
        }
        finally {
            this.readLock.unlock();
        }
        return new AbstractCompactionStrategy.ScannerList(scanners);
    }

    public AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables, Collection<Range<Token>> ranges) {
        while (true) {
            try {
                return this.maybeGetScanners(sstables, ranges);
            }
            catch (ConcurrentModificationException e) {
                logger.debug("SSTable repairedAt/pendingRepaired values changed while getting scanners");
                continue;
            }
            break;
        }
    }

    public AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables) {
        return this.getScanners(sstables, null);
    }

    public Collection<Collection<SSTableReader>> groupSSTablesForAntiCompaction(Collection<SSTableReader> sstablesToGroup) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            Collection<Collection<SSTableReader>> collection = this.unrepaired.groupForAnticompaction(sstablesToGroup);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getMaxSSTableBytes() {
        return this.maxSSTableSizeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionTask getCompactionTask(LifecycleTransaction txn, int gcBefore, long maxSSTableBytes) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            this.validateForCompaction(txn.originals());
            AbstractCompactionTask abstractCompactionTask = this.compactionStrategyFor(txn.originals().iterator().next()).getCompactionTask(txn, gcBefore, maxSSTableBytes);
            return abstractCompactionTask;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateForCompaction(Iterable<SSTableReader> input) {
        this.readLock.lock();
        try {
            SSTableReader firstSSTable = (SSTableReader)Iterables.getFirst(input, null);
            assert (firstSSTable != null);
            boolean repaired = firstSSTable.isRepaired();
            int firstIndex = this.compactionStrategyIndexFor(firstSSTable);
            boolean isPending = firstSSTable.isPendingRepair();
            TimeUUID pendingRepair = firstSSTable.getSSTableMetadata().pendingRepair;
            for (SSTableReader sstable : input) {
                if (sstable.isRepaired() != repaired) {
                    throw new UnsupportedOperationException("You can't mix repaired and unrepaired data in a compaction");
                }
                if (firstIndex != this.compactionStrategyIndexFor(sstable)) {
                    throw new UnsupportedOperationException("You can't mix sstables from different directories in a compaction");
                }
                if (!isPending || pendingRepair.equals(sstable.getSSTableMetadata().pendingRepair)) continue;
                throw new UnsupportedOperationException("You can't compact sstables from different pending repair sessions");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public CompactionTasks getMaximalTasks(int gcBefore, boolean splitOutput) {
        this.maybeReloadDiskBoundaries();
        return this.cfs.runWithCompactionsDisabled(() -> {
            ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
            this.readLock.lock();
            try {
                for (AbstractStrategyHolder holder : this.holders) {
                    tasks.addAll(holder.getMaximalTasks(gcBefore, splitOutput));
                }
            }
            finally {
                this.readLock.unlock();
            }
            return CompactionTasks.create(tasks);
        }, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionTasks getUserDefinedTasks(Collection<SSTableReader> sstables, int gcBefore) {
        this.maybeReloadDiskBoundaries();
        ArrayList<AbstractCompactionTask> ret = new ArrayList<AbstractCompactionTask>();
        this.readLock.lock();
        try {
            List<AbstractStrategyHolder.GroupedSSTableContainer> groupedSSTables = this.groupSSTables(sstables);
            for (int i = 0; i < this.holders.size(); ++i) {
                ret.addAll(((AbstractStrategyHolder)this.holders.get(i)).getUserDefinedTasks(groupedSSTables.get(i), gcBefore));
            }
            CompactionTasks compactionTasks = CompactionTasks.create(ret);
            return compactionTasks;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEstimatedRemainingTasks() {
        this.maybeReloadDiskBoundaries();
        int tasks = 0;
        this.readLock.lock();
        try {
            for (AbstractCompactionStrategy strategy : this.getAllStrategies()) {
                tasks += strategy.getEstimatedRemainingTasks();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tasks;
    }

    public boolean shouldBeEnabled() {
        return this.params.isEnabled();
    }

    public String getName() {
        return this.name;
    }

    public List<List<AbstractCompactionStrategy>> getStrategies() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            List<List<AbstractCompactionStrategy>> list = Arrays.asList(Lists.newArrayList(this.repaired.allStrategies()), Lists.newArrayList(this.unrepaired.allStrategies()), Lists.newArrayList(this.pendingRepairs.allStrategies()));
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setNewLocalCompactionStrategy(CompactionParams params) {
        logger.info("Switching local compaction strategy from {} to {}}", (Object)this.params, (Object)params);
        this.writeLock.lock();
        try {
            this.setStrategy(params);
            if (this.shouldBeEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
            this.startup();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int getNumTokenPartitions() {
        return this.partitionSSTablesByTokenRange ? this.currentBoundaries.directories.size() : 1;
    }

    private void setStrategy(CompactionParams params) {
        int numPartitions = this.getNumTokenPartitions();
        for (AbstractStrategyHolder holder : this.holders) {
            holder.setStrategy(params, numPartitions);
        }
        this.params = params;
    }

    public CompactionParams getCompactionParams() {
        return this.params;
    }

    public boolean onlyPurgeRepairedTombstones() {
        return Boolean.parseBoolean(this.params.options().get("only_purge_repaired_tombstones"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, MetadataCollector collector, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        SSTable.validateRepairedMetadata(repairedAt, pendingRepair, isTransient);
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            SSTableMultiWriter sSTableMultiWriter = this.getHolder(repairedAt, pendingRepair, isTransient).createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, collector, header, indexes, lifecycleNewTracker);
            return sSTableMultiWriter;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRepaired(AbstractCompactionStrategy strategy) {
        return this.repaired.getStrategyIndex(strategy) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStrategyFolders(AbstractCompactionStrategy strategy) {
        this.readLock.lock();
        try {
            Directories.DataDirectory[] locations = this.cfs.getDirectories().getWriteableLocations();
            if (this.partitionSSTablesByTokenRange) {
                for (AbstractStrategyHolder holder : this.holders) {
                    int idx = holder.getStrategyIndex(strategy);
                    if (idx < 0) continue;
                    List<String> list = Collections.singletonList(locations[idx].location.absolutePath());
                    return list;
                }
            }
            ArrayList<String> folders = new ArrayList<String>(locations.length);
            for (Directories.DataDirectory location : locations) {
                folders.add(location.location.absolutePath());
            }
            Object object = folders;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean supportsEarlyOpen() {
        return this.supportsEarlyOpen;
    }

    @VisibleForTesting
    List<PendingRepairManager> getPendingRepairManagers() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            ArrayList arrayList = Lists.newArrayList(this.pendingRepairs.getManagers());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateRepaired(Collection<SSTableReader> sstables, long repairedAt, TimeUUID pendingRepair, boolean isTransient) throws IOException {
        HashSet<SSTableReader> changed = new HashSet<SSTableReader>();
        this.writeLock.lock();
        try {
            for (SSTableReader sstable : sstables) {
                sstable.mutateRepairedAndReload(repairedAt, pendingRepair, isTransient);
                CompactionStrategyManager.verifyMetadata(sstable, repairedAt, pendingRepair, isTransient);
                changed.add(sstable);
            }
        }
        finally {
            try {
                this.cfs.getTracker().notifySSTableRepairedStatusChanged(changed);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static void verifyMetadata(SSTableReader sstable, long repairedAt, TimeUUID pendingRepair, boolean isTransient) {
        if (!Objects.equals(pendingRepair, sstable.getPendingRepair())) {
            throw new IllegalStateException(String.format("Failed setting pending repair to %s on %s (pending repair is %s)", pendingRepair, sstable, sstable.getPendingRepair()));
        }
        if (repairedAt != sstable.getRepairedAt()) {
            throw new IllegalStateException(String.format("Failed setting repairedAt to %d on %s (repairedAt is %d)", repairedAt, sstable, sstable.getRepairedAt()));
        }
        if (isTransient != sstable.isTransient()) {
            throw new IllegalStateException(String.format("Failed setting isTransient to %b on %s (isTransient is %b)", isTransient, sstable, sstable.isTransient()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CleanupSummary releaseRepairData(Collection<TimeUUID> sessions) {
        ArrayList<PendingRepairManager.CleanupTask> cleanupTasks = new ArrayList<PendingRepairManager.CleanupTask>();
        this.readLock.lock();
        try {
            for (PendingRepairManager prm : Iterables.concat(this.pendingRepairs.getManagers(), this.transientRepairs.getManagers())) {
                cleanupTasks.add(prm.releaseSessionData(sessions));
            }
        }
        finally {
            this.readLock.unlock();
        }
        CleanupSummary summary = new CleanupSummary(this.cfs, Collections.emptySet(), Collections.emptySet());
        for (PendingRepairManager.CleanupTask task : cleanupTasks) {
            summary = CleanupSummary.add(summary, task.cleanup());
        }
        return summary;
    }
}

