/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.writetofile;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="WRITE_TO_FILE", name="i18n::ActionWriteToFile.Name", description="i18n::ActionWriteToFile.Description", image="WriteToFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionWriteToFile.keyword"}, documentationUrl="/workflow/actions/writetofile.html")
public class ActionWriteToFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWriteToFile.class;
    @HopMetadataProperty(key="filename")
    private String filename = null;
    @HopMetadataProperty(key="createParentFolder")
    private boolean createParentFolder = false;
    @HopMetadataProperty(key="appendFile")
    private boolean appendFile = false;
    @HopMetadataProperty(key="content")
    private String content = null;
    @HopMetadataProperty(key="encoding")
    private String encoding = null;

    public ActionWriteToFile(String n) {
        super(n, "");
    }

    public ActionWriteToFile() {
        this("");
    }

    public Object clone() {
        ActionWriteToFile je = (ActionWriteToFile)super.clone();
        return je;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        String realFilename = this.getRealFilename();
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            String content = this.resolve(this.getContent());
            String encoding = this.resolve(this.getEncoding());
            OutputStreamWriter osw = null;
            OutputStream os = null;
            try {
                this.createParentFolder(realFilename);
                os = HopVfs.getOutputStream((String)realFilename, (boolean)this.isAppendFile());
                if (Utils.isEmpty((CharSequence)encoding)) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Log.WritingToFile", (String[])new String[]{realFilename}));
                    }
                    osw = new OutputStreamWriter(os);
                } else {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Log.WritingToFileWithEncoding", (String[])new String[]{realFilename, encoding}));
                    }
                    osw = new OutputStreamWriter(os, encoding);
                }
                osw.write(content);
                result.setResult(true);
                result.setNrErrors(0L);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Error.WritingFile", (String[])new String[]{realFilename, e.getMessage()}));
            }
            finally {
                if (osw != null) {
                    try {
                        osw.flush();
                        osw.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Error.MissinfgFile", (String[])new String[0]));
        }
        return result;
    }

    private void createParentFolder(String realFilename) throws HopException {
        block13: {
            FileObject parent = null;
            try {
                parent = HopVfs.getFileObject((String)realFilename).getParent();
                if (parent.exists()) break block13;
                if (this.isCreateParentFolder()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Log.ParentFoldetNotExist", (String[])new String[]{parent.getName().toString()}));
                    }
                    parent.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Log.ParentFolderCreated", (String[])new String[]{parent.getName().toString()}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Log.ParentFoldetNotExist", (String[])new String[]{parent.getName().toString()}));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Error.CheckingParentFolder", (String[])new String[]{realFilename}), (Throwable)e);
            }
            finally {
                if (parent != null) {
                    try {
                        parent.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isAppendFile() {
        return this.appendFile;
    }

    public void setAppendFile(boolean appendFile) {
        this.appendFile = appendFile;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.getFilename())) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.getRealFilename(), ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

