/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.Configuration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class Constants {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final long TB = 0x10000000000L;
    public static final String HTTPS = "https";
    public static final String HTTPS_HTTP = "https,http";
    public static final String STREAM_CLOSED = "Stream is already closed.";
    public static final String ENUM_COULD_NOT_BE_PARSED_INVALID_VALUE = "%s could not be parsed from '%s' due to invalid value %s.";
    public static final DateTimeFormatter ISO_8601_UTC_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT).withZone(ZoneId.of("UTC"));
    public static final String BLOB_ALREADY_EXISTS = "Blob already exists. Specify overwrite to true to force update the blob.";
    public static final String FILE_ALREADY_EXISTS = "File already exists. Specify overwrite to true to force update the file.";
    public static final int BUFFER_COPY_LENGTH = 8192;
    public static final int MAX_INPUT_STREAM_CONVERTER_BUFFER_LENGTH = 0x4000000;
    public static final String STORAGE_SCOPE = "https://storage.azure.com/.default";
    public static final String STORAGE_LOG_STRING_TO_SIGN = "Azure-Storage-Log-String-To-Sign";
    public static final String PROPERTY_AZURE_STORAGE_SAS_SERVICE_VERSION = "AZURE_STORAGE_SAS_SERVICE_VERSION";
    public static final String SAS_SERVICE_VERSION = (String)Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", (Object)"2022-11-02");

    private Constants() {
    }

    public static final class UrlConstants {
        public static final String SNAPSHOT_QUERY_PARAMETER = "snapshot";
        public static final String VERSIONID_QUERY_PARAMETER = "versionid";
        public static final String DELETIONID_QUERY_PARAMETER = "deletionid";
        public static final String SAS_SERVICE_VERSION = "sv";
        public static final String SAS_SERVICES = "ss";
        public static final String SAS_RESOURCES_TYPES = "srt";
        public static final String SAS_PROTOCOL = "spr";
        public static final String SAS_START_TIME = "st";
        public static final String SAS_EXPIRY_TIME = "se";
        public static final String SAS_IP_RANGE = "sip";
        public static final String SAS_SIGNED_IDENTIFIER = "si";
        public static final String SAS_SIGNED_RESOURCE = "sr";
        public static final String SAS_SIGNED_PERMISSIONS = "sp";
        public static final String SAS_SIGNATURE = "sig";
        public static final String SAS_ENCRYPTION_SCOPE = "ses";
        public static final String SAS_CACHE_CONTROL = "rscc";
        public static final String SAS_CONTENT_DISPOSITION = "rscd";
        public static final String SAS_CONTENT_ENCODING = "rsce";
        public static final String SAS_CONTENT_LANGUAGE = "rscl";
        public static final String SAS_CONTENT_TYPE = "rsct";
        public static final String SAS_SIGNED_OBJECT_ID = "skoid";
        public static final String SAS_SIGNED_TENANT_ID = "sktid";
        public static final String SAS_SIGNED_KEY_START = "skt";
        public static final String SAS_SIGNED_KEY_EXPIRY = "ske";
        public static final String SAS_SIGNED_KEY_SERVICE = "sks";
        public static final String SAS_SIGNED_KEY_VERSION = "skv";
        public static final String SAS_PREAUTHORIZED_AGENT_OBJECT_ID = "saoid";
        public static final String SAS_AGENT_OBJECT_ID = "suoid";
        public static final String SAS_CORRELATION_ID = "scid";
        public static final String SAS_DIRECTORY_DEPTH = "sdd";
        public static final String SAS_QUEUE_CONSTANT = "q";

        private UrlConstants() {
        }
    }

    public static final class HeaderConstants {
        @Deprecated
        public static final String TARGET_STORAGE_VERSION = "2022-11-02";
        public static final String ERROR_CODE = "x-ms-error-code";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String CLIENT_REQUEST_ID = "x-ms-client-request-id";
        public static final String ENCRYPTION_KEY = "x-ms-encryption-key";
        public static final String ENCRYPTION_KEY_SHA256 = "x-ms-encryption-key-sha256";
        public static final String SERVER_ENCRYPTED = "x-ms-server-encrypted";
        public static final String REQUEST_SERVER_ENCRYPTED = "x-ms-request-server-encrypted";
        public static final String ETAG_WILDCARD = "*";
        public static final String DIRECTORY_METADATA_KEY = "hdi_isfolder";
        public static final String X_MS_META = "x-ms-meta";
        public static final String SMB_PROTOCOL = "SMB";
        public static final String NFS_PROTOCOL = "NFS";

        private HeaderConstants() {
        }
    }

    public static final class ConnectionStringConstants {
        public static final String ACCOUNT_NAME = "AccountName";
        public static final String ACCOUNT_KEY_NAME = "AccountKey";
        public static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
        public static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
        public static final String BLOB_SECONDARY_ENDPOINT_NAME = "BlobSecondaryEndpoint";
        public static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
        public static final String QUEUE_SECONDARY_ENDPOINT_NAME = "QueueSecondaryEndpoint";
        public static final String FILE_ENDPOINT_NAME = "FileEndpoint";
        public static final String FILE_SECONDARY_ENDPOINT_NAME = "FileSecondaryEndpoint";
        public static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
        public static final String TABLE_SECONDARY_ENDPOINT_NAME = "TableSecondaryEndpoint";
        public static final String ENDPOINT_SUFFIX_NAME = "EndpointSuffix";
        public static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
        public static final String USE_EMULATOR_STORAGE_NAME = "UseDevelopmentStorage";
        public static final String EMULATOR_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
        public static final String DEFAULT_DNS = "core.windows.net";
        public static final String EMULATOR_PRIMARY_ENDPOINT_FORMAT = "%s://%s:%s/devstoreaccount1";
        public static final String EMULATOR_SECONDARY_ENDPOINT_FORMAT = "%s://%s:%s/devstoreaccount1-secondary";
        public static final String EMULATOR_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
        public static final String EMULATOR_ACCOUNT_NAME = "devstoreaccount1";

        private ConnectionStringConstants() {
        }
    }
}

