/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.collect.ImmutableMap;
import com.google.spanner.admin.database.v1.DatabaseDialect;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum Dialect {
    GOOGLE_STANDARD_SQL{

        @Override
        public String createDatabaseStatementFor(String databaseName) {
            return "CREATE DATABASE `" + databaseName + "`";
        }

        @Override
        public DatabaseDialect toProto() {
            return DatabaseDialect.GOOGLE_STANDARD_SQL;
        }
    }
    ,
    POSTGRESQL{

        @Override
        public String createDatabaseStatementFor(String databaseName) {
            return "CREATE DATABASE \"" + databaseName + "\"";
        }

        @Override
        public DatabaseDialect toProto() {
            return DatabaseDialect.POSTGRESQL;
        }
    };

    private static final Map<DatabaseDialect, Dialect> protoToDialect;

    public abstract String createDatabaseStatementFor(String var1);

    public abstract DatabaseDialect toProto();

    public static Dialect fromProto(DatabaseDialect databaseDialect) {
        Dialect dialect = protoToDialect.get(databaseDialect);
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Invalid dialect: %s. Dialect must be one of [%s]", databaseDialect, protoToDialect.keySet().stream().map(Enum::name).collect(Collectors.joining(", "))));
        }
        return dialect;
    }

    public static Dialect fromName(String name) {
        try {
            return Dialect.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid dialect: %s. Dialect must be one of %s", name, Arrays.toString((Object[])Dialect.values())));
        }
    }

    static {
        protoToDialect = ImmutableMap.of((Object)DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED, (Object)((Object)GOOGLE_STANDARD_SQL), (Object)DatabaseDialect.GOOGLE_STANDARD_SQL, (Object)((Object)GOOGLE_STANDARD_SQL), (Object)DatabaseDialect.POSTGRESQL, (Object)((Object)POSTGRESQL));
    }
}

