/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.filerequests.FileRequestDeadline;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class CreateFileRequestArgs {
    protected final String title;
    protected final String destination;
    protected final FileRequestDeadline deadline;
    protected final boolean open;

    public CreateFileRequestArgs(String title, String destination, FileRequestDeadline deadline, boolean open) {
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        if (title.length() < 1) {
            throw new IllegalArgumentException("String 'title' is shorter than 1");
        }
        this.title = title;
        if (destination == null) {
            throw new IllegalArgumentException("Required value for 'destination' is null");
        }
        if (!Pattern.matches("/(.|[\\r\\n])*", destination)) {
            throw new IllegalArgumentException("String 'destination' does not match pattern");
        }
        this.destination = destination;
        this.deadline = deadline;
        this.open = open;
    }

    public CreateFileRequestArgs(String title, String destination) {
        this(title, destination, null, true);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDestination() {
        return this.destination;
    }

    public FileRequestDeadline getDeadline() {
        return this.deadline;
    }

    public boolean getOpen() {
        return this.open;
    }

    public static Builder newBuilder(String title, String destination) {
        return new Builder(title, destination);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.title, this.destination, this.deadline, this.open});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CreateFileRequestArgs other = (CreateFileRequestArgs)obj;
            return !(this.title != other.title && !this.title.equals(other.title) || this.destination != other.destination && !this.destination.equals(other.destination) || this.deadline != other.deadline && (this.deadline == null || !this.deadline.equals(other.deadline)) || this.open != other.open);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<CreateFileRequestArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CreateFileRequestArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            g.writeFieldName("destination");
            StoneSerializers.string().serialize(value.destination, g);
            if (value.deadline != null) {
                g.writeFieldName("deadline");
                StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).serialize(value.deadline, g);
            }
            g.writeFieldName("open");
            StoneSerializers.boolean_().serialize((Boolean)value.open, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public CreateFileRequestArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_open;
            FileRequestDeadline f_deadline;
            String f_destination;
            String f_title;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_title = null;
                f_destination = null;
                f_deadline = null;
                f_open = true;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("destination".equals(field)) {
                        f_destination = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("deadline".equals(field)) {
                        f_deadline = StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("open".equals(field)) {
                        f_open = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_title == null) {
                    throw new JsonParseException(p, "Required field \"title\" missing.");
                }
                if (f_destination == null) {
                    throw new JsonParseException(p, "Required field \"destination\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            CreateFileRequestArgs value = new CreateFileRequestArgs(f_title, f_destination, f_deadline, f_open);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String title;
        protected final String destination;
        protected FileRequestDeadline deadline;
        protected boolean open;

        protected Builder(String title, String destination) {
            if (title == null) {
                throw new IllegalArgumentException("Required value for 'title' is null");
            }
            if (title.length() < 1) {
                throw new IllegalArgumentException("String 'title' is shorter than 1");
            }
            this.title = title;
            if (destination == null) {
                throw new IllegalArgumentException("Required value for 'destination' is null");
            }
            if (!Pattern.matches("/(.|[\\r\\n])*", destination)) {
                throw new IllegalArgumentException("String 'destination' does not match pattern");
            }
            this.destination = destination;
            this.deadline = null;
            this.open = true;
        }

        public Builder withDeadline(FileRequestDeadline deadline) {
            this.deadline = deadline;
            return this;
        }

        public Builder withOpen(Boolean open) {
            this.open = open != null ? open : true;
            return this;
        }

        public CreateFileRequestArgs build() {
            return new CreateFileRequestArgs(this.title, this.destination, this.deadline, this.open);
        }
    }
}

