/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.filerequests.UpdateFileRequestDeadline;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class UpdateFileRequestArgs {
    protected final String id;
    protected final String title;
    protected final String destination;
    protected final UpdateFileRequestDeadline deadline;
    protected final Boolean open;

    public UpdateFileRequestArgs(String id, String title, String destination, UpdateFileRequestDeadline deadline, Boolean open) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z]+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        if (title != null && title.length() < 1) {
            throw new IllegalArgumentException("String 'title' is shorter than 1");
        }
        this.title = title;
        if (destination != null && !Pattern.matches("/(.|[\\r\\n])*", destination)) {
            throw new IllegalArgumentException("String 'destination' does not match pattern");
        }
        this.destination = destination;
        if (deadline == null) {
            throw new IllegalArgumentException("Required value for 'deadline' is null");
        }
        this.deadline = deadline;
        this.open = open;
    }

    public UpdateFileRequestArgs(String id) {
        this(id, null, null, UpdateFileRequestDeadline.NO_UPDATE, null);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDestination() {
        return this.destination;
    }

    public UpdateFileRequestDeadline getDeadline() {
        return this.deadline;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public static Builder newBuilder(String id) {
        return new Builder(id);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.title, this.destination, this.deadline, this.open});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateFileRequestArgs other = (UpdateFileRequestArgs)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.title != other.title && (this.title == null || !this.title.equals(other.title)) || this.destination != other.destination && (this.destination == null || !this.destination.equals(other.destination)) || this.deadline != other.deadline && !this.deadline.equals(other.deadline) || this.open != other.open && (this.open == null || !this.open.equals(other.open)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UpdateFileRequestArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdateFileRequestArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            if (value.title != null) {
                g.writeFieldName("title");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.title, g);
            }
            if (value.destination != null) {
                g.writeFieldName("destination");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.destination, g);
            }
            g.writeFieldName("deadline");
            UpdateFileRequestDeadline.Serializer.INSTANCE.serialize(value.deadline, g);
            if (value.open != null) {
                g.writeFieldName("open");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.open, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdateFileRequestArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_open;
            UpdateFileRequestDeadline f_deadline;
            String f_destination;
            String f_title;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_title = null;
                f_destination = null;
                f_deadline = UpdateFileRequestDeadline.NO_UPDATE;
                f_open = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("destination".equals(field)) {
                        f_destination = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("deadline".equals(field)) {
                        f_deadline = UpdateFileRequestDeadline.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("open".equals(field)) {
                        f_open = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdateFileRequestArgs value = new UpdateFileRequestArgs(f_id, f_title, f_destination, f_deadline, f_open);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String id;
        protected String title;
        protected String destination;
        protected UpdateFileRequestDeadline deadline;
        protected Boolean open;

        protected Builder(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            this.title = null;
            this.destination = null;
            this.deadline = UpdateFileRequestDeadline.NO_UPDATE;
            this.open = null;
        }

        public Builder withTitle(String title) {
            if (title != null && title.length() < 1) {
                throw new IllegalArgumentException("String 'title' is shorter than 1");
            }
            this.title = title;
            return this;
        }

        public Builder withDestination(String destination) {
            if (destination != null && !Pattern.matches("/(.|[\\r\\n])*", destination)) {
                throw new IllegalArgumentException("String 'destination' does not match pattern");
            }
            this.destination = destination;
            return this;
        }

        public Builder withDeadline(UpdateFileRequestDeadline deadline) {
            this.deadline = deadline != null ? deadline : UpdateFileRequestDeadline.NO_UPDATE;
            return this;
        }

        public Builder withOpen(Boolean open) {
            this.open = open;
            return this;
        }

        public UpdateFileRequestArgs build() {
            return new UpdateFileRequestArgs(this.id, this.title, this.destination, this.deadline, this.open);
        }
    }
}

