/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnStatsTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.IndexUpdater;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.DefaultFetchFormatter;
import org.apache.hadoop.hive.serde2.NoOpFetchFormatter;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskCompiler {
    protected final Logger LOG = LoggerFactory.getLogger(TaskCompiler.class);
    protected Hive db;
    protected SessionState.LogHelper console;
    protected QueryState queryState;
    protected HiveConf conf;

    public void init(QueryState queryState, SessionState.LogHelper console, Hive db) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.db = db;
        this.console = console;
    }

    /*
     * WARNING - void declaration
     */
    public void compile(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = pCtx.getQueryProperties().isAnalyzeRewrite();
        int outerQueryLimit = pCtx.getQueryProperties().getOuterQueryLimit();
        if (pCtx.getFetchTask() != null) {
            if (pCtx.getFetchTask().getTblDesc() == null) {
                return;
            }
            ((FetchWork)pCtx.getFetchTask().getWork()).setHiveServerQuery(SessionState.get().isHiveServerQuery());
            TableDesc resultTab = pCtx.getFetchTask().getTblDesc();
            if (!resultTab.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                if (SessionState.get().isHiveServerQuery()) {
                    this.conf.set("list.sink.output.formatter", ThriftFormatter.class.getName());
                } else {
                    String string = this.conf.get("list.sink.output.formatter");
                    if (string == null || string.isEmpty()) {
                        this.conf.set("list.sink.output.formatter", DefaultFetchFormatter.class.getName());
                    }
                }
            }
            return;
        }
        this.optimizeOperatorPlan(pCtx, inputs, outputs);
        if (pCtx.getQueryProperties().isQuery() && !isCStats) {
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.INVALID_LOAD_TABLE_FILE_WORK.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String string = loadFileDesc.getColumns();
            String string2 = loadFileDesc.getColumnTypes();
            TableDesc resultTab = pCtx.getFetchTableDesc();
            if (resultTab == null) {
                String resFileFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                if (SessionState.get().getIsUsingThriftJDBCBinarySerDe() && resFileFormat.equalsIgnoreCase("SequenceFile")) {
                    resultTab = PlanUtils.getDefaultQueryOutputTableDesc(string, string2, resFileFormat, ThriftJDBCBinarySerDe.class);
                    this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
                } else {
                    resultTab = PlanUtils.getDefaultQueryOutputTableDesc(string, string2, resFileFormat, LazySimpleSerDe.class);
                }
            } else if (resultTab.getProperties().getProperty("serialization.lib").equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
            }
            FetchWork fetch = new FetchWork(loadFileDesc.getSourcePath(), resultTab, outerQueryLimit);
            boolean bl = SessionState.get().isHiveServerQuery();
            fetch.setHiveServerQuery(bl);
            fetch.setSource(pCtx.getFetchSource());
            fetch.setSink(pCtx.getFetchSink());
            if (bl && null != resultTab && resultTab.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName()) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
                fetch.setIsUsingThriftJDBCBinarySerDe(true);
            } else {
                fetch.setIsUsingThriftJDBCBinarySerDe(false);
            }
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]));
            int fetchLimit = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVELIMITOPTMAXFETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > fetchLimit) {
                this.LOG.info("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + fetchLimit + ". Doesn't qualify limit optimization.");
                globalLimitCtx.disableOpt();
            }
            if (outerQueryLimit == 0) {
                this.LOG.info("Limit 0. No query execution needed.");
                return;
            }
        } else if (!isCStats) {
            for (LoadTableDesc loadTableDesc : loadTableWork) {
                Task<MoveWork> task = TaskFactory.get(new MoveWork(null, null, loadTableDesc, null, false), this.conf, new Task[0]);
                mvTask.add(task);
                if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEINDEXAUTOUPDATE)) continue;
                IndexUpdater indexUpdater = new IndexUpdater(loadTableWork, inputs, (Configuration)this.conf);
                try {
                    List<Task<? extends Serializable>> indexUpdateTasks = indexUpdater.generateUpdateTasks();
                    for (Task task2 : indexUpdateTasks) {
                        task.addDependentTask(task2);
                    }
                }
                catch (HiveException e) {
                    this.console.printInfo("WARNING: could not auto-update stale indexes, which are not in sync");
                }
            }
            boolean oneLoadFile = true;
            for (LoadFileDesc loadFileDesc : loadFileWork) {
                if (pCtx.getQueryProperties().isCTAS() || pCtx.getQueryProperties().isMaterializedView()) {
                    Path location;
                    String loc;
                    assert (oneLoadFile);
                    String string = loc = pCtx.getQueryProperties().isCTAS() ? pCtx.getCreateTable().getLocation() : pCtx.getCreateViewDesc().getLocation();
                    if (loc == null) {
                        Path targetPath;
                        try {
                            void var18_60;
                            Object var18_57 = null;
                            if (pCtx.getQueryProperties().isCTAS()) {
                                String string3 = pCtx.getCreateTable().getTableName();
                            } else if (pCtx.getQueryProperties().isMaterializedView()) {
                                String string4 = pCtx.getCreateViewDesc().getViewName();
                            }
                            String[] names = Utilities.getDbTableName((String)var18_60);
                            if (!this.db.databaseExists(names[0])) {
                                throw new SemanticException("ERROR: The database " + names[0] + " does not exist.");
                            }
                            Warehouse wh = new Warehouse((Configuration)this.conf);
                            targetPath = wh.getDefaultTablePath(this.db.getDatabase(names[0]), names[1]);
                        }
                        catch (HiveException hiveException) {
                            throw new SemanticException(hiveException);
                        }
                        catch (MetaException metaException) {
                            throw new SemanticException(metaException);
                        }
                        location = targetPath;
                    } else {
                        location = new Path(loc);
                    }
                    loadFileDesc.setTargetDir(location);
                    oneLoadFile = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(null, null, null, loadFileDesc, false), this.conf, new Task[0]));
            }
        }
        this.generateTaskTree(rootTasks, pCtx, mvTask, inputs, outputs);
        for (Task<? extends Serializable> task : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(task);
        }
        for (Task<? extends Serializable> task : rootTasks) {
            this.setInputFormat(task);
        }
        this.optimizeTaskPlan(rootTasks, pCtx, ctx);
        if (isCStats || !pCtx.getColumnStatsAutoGatherContexts().isEmpty()) {
            LinkedHashSet<Task<? extends Serializable>> leafTasks = new LinkedHashSet<Task<? extends Serializable>>();
            this.getLeafTasks(rootTasks, leafTasks);
            if (isCStats) {
                this.genColumnStatsTask(pCtx.getAnalyzeRewrite(), loadFileWork, leafTasks, outerQueryLimit, 0);
            } else {
                for (ColumnStatsAutoGatherContext columnStatsAutoGatherContext : pCtx.getColumnStatsAutoGatherContexts()) {
                    int numBitVector;
                    if (!columnStatsAutoGatherContext.isInsertInto()) {
                        this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), leafTasks, outerQueryLimit, 0);
                        continue;
                    }
                    try {
                        numBitVector = HiveStatsUtils.getNumBitVectorsForNDVEstimation((Configuration)this.conf);
                    }
                    catch (Exception e) {
                        throw new SemanticException(e.getMessage());
                    }
                    this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), leafTasks, outerQueryLimit, numBitVector);
                }
            }
        }
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (pCtx.getQueryProperties().isCTAS() && !pCtx.getCreateTable().isMaterialization()) {
            CreateTableDesc crtTblDesc = pCtx.getCreateTable();
            crtTblDesc.validate(this.conf);
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc), this.conf, new Task[0]);
            this.patchUpAfterCTASorMaterializedView(rootTasks, outputs, task);
        } else if (pCtx.getQueryProperties().isMaterializedView()) {
            CreateViewDesc viewDesc = pCtx.getCreateViewDesc();
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, viewDesc), this.conf, new Task[0]);
            this.patchUpAfterCTASorMaterializedView(rootTasks, outputs, task);
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit());
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit());
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(rootTasks);
            for (ExecDriver execDriver : mrTasks) {
                execDriver.setRetryCmdWhenFail(true);
            }
            List<SparkTask> list = Utilities.getSparkTasks(rootTasks);
            for (SparkTask sparkTask : list) {
                sparkTask.setRetryCmdWhenFail(true);
            }
        }
        Interner interner = Interners.newStrongInterner();
        for (Task<? extends Serializable> task : rootTasks) {
            GenMapRedUtils.internTableDesc(task, (Interner<TableDesc>)interner);
            GenMapRedUtils.deriveFinalExplainAttributes(task, (Configuration)pCtx.getConf());
        }
    }

    private void patchUpAfterCTASorMaterializedView(List<Task<? extends Serializable>> rootTasks, HashSet<WriteEntity> outputs, Task<? extends Serializable> createTask) {
        Iterator<WriteEntity> outIter = outputs.iterator();
        block3: while (outIter.hasNext()) {
            switch (outIter.next().getType()) {
                case DFS_DIR: 
                case LOCAL_DIR: {
                    outIter.remove();
                    continue block3;
                }
            }
        }
        LinkedHashSet<Task<? extends Serializable>> leaves = new LinkedHashSet<Task<? extends Serializable>>();
        this.getLeafTasks(rootTasks, leaves);
        assert (leaves.size() > 0);
        for (Task task : leaves) {
            if (task instanceof StatsTask) {
                for (Task<Serializable> parentOfStatsTask : task.getParentTasks()) {
                    parentOfStatsTask.addDependentTask(createTask);
                }
                for (Task<Serializable> parentOfCrtTblTask : createTask.getParentTasks()) {
                    parentOfCrtTblTask.removeDependentTask(task);
                }
                createTask.addDependentTask(task);
                continue;
            }
            task.addDependentTask(createTask);
        }
    }

    protected void genColumnStatsTask(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite, List<LoadFileDesc> loadFileWork, Set<Task<? extends Serializable>> leafTasks, int outerQueryLimit, int numBitVector) {
        TableDesc resultTab;
        String resFileFormat;
        ColumnStatsTask cStatsTask = null;
        ColumnStatsWork cStatsWork = null;
        FetchWork fetch = null;
        String tableName = analyzeRewrite.getTableName();
        List<String> colName = analyzeRewrite.getColName();
        List<String> colType = analyzeRewrite.getColType();
        boolean isTblLevel = analyzeRewrite.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        if (SessionState.get().isHiveServerQuery() && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
            resFileFormat = "SequenceFile";
            resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat, ThriftJDBCBinarySerDe.class);
        } else {
            resFileFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
            resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat, LazySimpleSerDe.class);
        }
        fetch = new FetchWork(loadFileWork.get(0).getSourcePath(), resultTab, outerQueryLimit);
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, colName, colType, isTblLevel, numBitVector);
        cStatsWork = new ColumnStatsWork(fetch, cStatsDesc);
        cStatsTask = (ColumnStatsTask)TaskFactory.get(cStatsWork, this.conf, new Task[0]);
        for (Task<? extends Serializable> tsk : leafTasks) {
            tsk.addDependentTask(cStatsTask);
        }
    }

    protected void getLeafTasks(List<Task<? extends Serializable>> rootTasks, Set<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, Set<Task<? extends Serializable>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    protected abstract void decideExecMode(List<Task<? extends Serializable>> var1, Context var2, GlobalLimitCtx var3) throws SemanticException;

    protected void optimizeOperatorPlan(ParseContext pCtxSet, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
    }

    protected abstract void optimizeTaskPlan(List<Task<? extends Serializable>> var1, ParseContext var2, Context var3) throws SemanticException;

    protected abstract void setInputFormat(Task<? extends Serializable> var1);

    protected abstract void generateTaskTree(List<Task<? extends Serializable>> var1, ParseContext var2, List<Task<MoveWork>> var3, Set<ReadEntity> var4, Set<WriteEntity> var5) throws SemanticException;

    public ParseContext getParseContext(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks) {
        ParseContext clone = new ParseContext(this.queryState, pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getJoinOps(), pCtx.getSmbMapJoinOps(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getColumnStatsAutoGatherContexts(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getPrunedPartitions(), pCtx.getTabNameToTabObject(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getAnalyzeRewrite(), pCtx.getCreateTable(), pCtx.getCreateViewDesc(), pCtx.getQueryProperties(), pCtx.getViewProjectToTableSchema(), pCtx.getAcidSinks());
        clone.setFetchTask(pCtx.getFetchTask());
        clone.setLineageInfo(pCtx.getLineageInfo());
        clone.setMapJoinOps(pCtx.getMapJoinOps());
        clone.setRsToRuntimeValuesInfoMap(pCtx.getRsToRuntimeValuesInfoMap());
        clone.setRsOpToTsOpMap(pCtx.getRsOpToTsOpMap());
        return clone;
    }
}

