/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpencryptstream;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgpencryptstream.PGPEncryptStreamData;
import org.apache.hop.pipeline.transforms.pgpencryptstream.PGPEncryptStreamMeta;
import org.apache.hop.workflow.actions.pgpencryptfiles.GPG;

public class PGPEncryptStream
extends BaseTransform<PGPEncryptStreamMeta, PGPEncryptStreamData> {
    private static final Class<?> PKG = PGPEncryptStreamMeta.class;

    public PGPEncryptStream(TransformMeta transformMeta, PGPEncryptStreamMeta meta, PGPEncryptStreamData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                String dataToEncrypt;
                if (this.first) {
                    this.first = false;
                    ((PGPEncryptStreamData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                    ((PGPEncryptStreamData)this.data).NrPrevFields = ((PGPEncryptStreamData)this.data).previousRowMeta.size();
                    ((PGPEncryptStreamData)this.data).outputRowMeta = ((PGPEncryptStreamData)this.data).previousRowMeta;
                    ((PGPEncryptStreamMeta)this.meta).getFields(((PGPEncryptStreamData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    if (Utils.isEmpty((CharSequence)((PGPEncryptStreamMeta)this.meta).getStreamField())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.DataStreamFieldMissing", (String[])new String[0]));
                    }
                    if (((PGPEncryptStreamMeta)this.meta).isKeynameInField()) {
                        String keyField = ((PGPEncryptStreamMeta)this.meta).getKeynameFieldName();
                        if (Utils.isEmpty((CharSequence)keyField)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameFieldMissing", (String[])new String[0]));
                        }
                        ((PGPEncryptStreamData)this.data).indexOfKeyName = ((PGPEncryptStreamData)this.data).previousRowMeta.indexOfValue(keyField);
                        if (((PGPEncryptStreamData)this.data).indexOfKeyName < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Exception.CouldnotFindField", (String[])new String[]{((PGPEncryptStreamMeta)this.meta).getStreamField()}));
                        }
                    } else {
                        ((PGPEncryptStreamData)this.data).keyName = this.resolve(((PGPEncryptStreamMeta)this.meta).getKeyName());
                        if (Utils.isEmpty((CharSequence)((PGPEncryptStreamData)this.data).keyName)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameMissing", (String[])new String[0]));
                        }
                    }
                    if (((PGPEncryptStreamData)this.data).indexOfField < 0) {
                        ((PGPEncryptStreamData)this.data).indexOfField = ((PGPEncryptStreamData)this.data).previousRowMeta.indexOfValue(((PGPEncryptStreamMeta)this.meta).getStreamField());
                        if (((PGPEncryptStreamData)this.data).indexOfField < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Exception.CouldnotFindField", (String[])new String[]{((PGPEncryptStreamMeta)this.meta).getStreamField()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)((PGPEncryptStreamData)this.data).outputRowMeta.size());
                for (int i = 0; i < ((PGPEncryptStreamData)this.data).NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                if (((PGPEncryptStreamMeta)this.meta).isKeynameInField()) {
                    ((PGPEncryptStreamData)this.data).keyName = ((PGPEncryptStreamData)this.data).previousRowMeta.getString(r, ((PGPEncryptStreamData)this.data).indexOfKeyName);
                    if (Utils.isEmpty((CharSequence)((PGPEncryptStreamData)this.data).keyName)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.KeyNameMissing", (String[])new String[0]));
                    }
                }
                if (Utils.isEmpty((CharSequence)(dataToEncrypt = ((PGPEncryptStreamData)this.data).previousRowMeta.getString(r, ((PGPEncryptStreamData)this.data).indexOfField)))) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.DataToEncryptEmpty", (String[])new String[0]));
                }
                String encryptedData = ((PGPEncryptStreamData)this.data).gpg.encrypt(dataToEncrypt, ((PGPEncryptStreamData)this.data).keyName);
                outputRow[((PGPEncryptStreamData)this.data).NrPrevFields] = encryptedData;
                this.putRow(((PGPEncryptStreamData)this.data).outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"PGPEncryptStream.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((PGPEncryptStreamMeta)this.meta).getResultFieldName(), "PGPEncryptStreamO01");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((PGPEncryptStreamMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            try {
                ((PGPEncryptStreamData)this.data).gpg = new GPG(this.resolve(((PGPEncryptStreamMeta)this.meta).getGPGLocation()), this.log);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPEncryptStream.Init.Error", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }
}

