/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.CommonCredentialsProvider;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazonaws.services.ssooidc.AWSSSOOIDC;
import com.amazonaws.services.ssooidc.AWSSSOOIDCClientBuilder;
import com.amazonaws.services.ssooidc.model.AccessDeniedException;
import com.amazonaws.services.ssooidc.model.AuthorizationPendingException;
import com.amazonaws.services.ssooidc.model.CreateTokenRequest;
import com.amazonaws.services.ssooidc.model.CreateTokenResult;
import com.amazonaws.services.ssooidc.model.InternalServerException;
import com.amazonaws.services.ssooidc.model.RegisterClientRequest;
import com.amazonaws.services.ssooidc.model.RegisterClientResult;
import com.amazonaws.services.ssooidc.model.SlowDownException;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationRequest;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationResult;
import com.amazonaws.util.StringUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BrowserIdcAuthPlugin
extends CommonCredentialsProvider {
    private static final String KEY_START_URL = "start_url";
    private static final String KEY_IDC_CLIENT_DISPLAY_NAME = "idc_client_display_name";
    private static final String KEY_IDC_REGION = "idc_region";
    private static final String KEY_IDC_RESPONSE_TIMEOUT = "idc_response_timeout";
    private static final String M_CLIENT_TYPE = "public";
    private static final String M_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:device_code";
    private static final String M_SCOPE = "redshift:connect";
    private static final Map<String, RegisterClientResult> m_register_client_cache = new HashMap<String, RegisterClientResult>();
    public final int REQUEST_CREATE_TOKEN_DEFAULT_INTERVAL = 1;
    public final int DEFAULT_IDC_TOKEN_EXPIRY_IN_SEC = 900;
    protected AWSSSOOIDC m_sdk_client;
    private String m_idcRegion;
    private String m_startUrl;
    private String m_idcClientDisplayName = RedshiftProperty.IDC_CLIENT_DISPLAY_NAME.getDefaultValue();
    private int m_idcResponseTimeout = 120;

    public BrowserIdcAuthPlugin() {
    }

    public BrowserIdcAuthPlugin(AWSSSOOIDC client) {
        this.m_sdk_client = client;
    }

    @Override
    public void addParameter(String key, String value) {
        switch (key) {
            case "start_url": {
                this.m_startUrl = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting start_url: {0}", this.m_startUrl);
                break;
            }
            case "idc_region": {
                this.m_idcRegion = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting idc_region: {0}", this.m_idcRegion);
                break;
            }
            case "idc_client_display_name": {
                if (!StringUtils.isNullOrEmpty((String)value)) {
                    this.m_idcClientDisplayName = value;
                }
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting idc_client_display_name: {0}", this.m_idcClientDisplayName);
                break;
            }
            case "idc_response_timeout": {
                if (StringUtils.isNullOrEmpty((String)value)) break;
                int timeout = Integer.parseInt(value);
                if (timeout > 10) {
                    this.m_idcResponseTimeout = timeout;
                    if (!RedshiftLogger.isEnable()) break;
                    this.m_log.logDebug("Setting idc_response_timeout: {0}", this.m_idcResponseTimeout);
                    break;
                }
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting idc_response_timeout={0}; provided value={1}", this.m_idcResponseTimeout, timeout);
                break;
            }
            default: {
                super.addParameter(key, value);
            }
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_startUrl != null ? this.m_startUrl : "";
    }

    @Override
    protected NativeTokenHolder getAuthToken() throws IOException {
        return this.getIdcToken();
    }

    protected NativeTokenHolder getIdcToken() throws IOException {
        try {
            this.checkRequiredParameters();
            this.m_sdk_client = (AWSSSOOIDC)((AWSSSOOIDCClientBuilder)AWSSSOOIDCClientBuilder.standard().withRegion(this.m_idcRegion)).build();
            RegisterClientResult registerClientResult = this.getRegisterClientResult(this.m_idcClientDisplayName, M_CLIENT_TYPE);
            StartDeviceAuthorizationResult startDeviceAuthorizationResult = this.getStartDeviceAuthorizationResult(registerClientResult.getClientId(), registerClientResult.getClientSecret(), this.m_startUrl);
            this.openBrowser(startDeviceAuthorizationResult.getVerificationUriComplete());
            CreateTokenResult createTokenResult = this.fetchTokenResult(registerClientResult, startDeviceAuthorizationResult, M_GRANT_TYPE, M_SCOPE);
            return this.processCreateTokenResult(createTokenResult);
        }
        catch (InternalPluginException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "InternalPluginException in getIdcToken", new Object[0]);
            }
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private void checkRequiredParameters() throws InternalPluginException {
        if (StringUtils.isNullOrEmpty((String)this.m_startUrl)) {
            this.m_log.logDebug("IdC authentication failed: start_url needs to be provided in connection params", new Object[0]);
            throw new InternalPluginException("IdC authentication failed: The start URL must be included in the connection parameters.");
        }
        if (StringUtils.isNullOrEmpty((String)this.m_idcRegion)) {
            this.m_log.logDebug("IdC authentication failed: idc_region needs to be provided in connection params", new Object[0]);
            throw new InternalPluginException("IdC authentication failed: The IdC region must be included in the connection parameters.");
        }
    }

    protected RegisterClientResult getRegisterClientResult(String clientName, String clientType) throws IOException {
        String registerClientCacheKey = clientName + ":" + this.m_idcRegion;
        RegisterClientResult cachedRegisterClientResult = m_register_client_cache.get(registerClientCacheKey);
        if (this.isCachedRegisterClientResultValid(cachedRegisterClientResult)) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Using cached register client result", new Object[0]);
            }
            return cachedRegisterClientResult;
        }
        RegisterClientRequest registerClientRequest = new RegisterClientRequest();
        registerClientRequest.withClientName(clientName);
        registerClientRequest.withClientType(clientType);
        registerClientRequest.withScopes(new String[]{M_SCOPE});
        RegisterClientResult registerClientResult = null;
        try {
            registerClientResult = this.m_sdk_client.registerClient(registerClientRequest);
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("registerClient response code: {0}", registerClientResult.getSdkHttpMetadata().getHttpStatusCode());
            }
        }
        catch (InternalServerException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected server error while registering client;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : An error occurred during the request.", ex);
        }
        catch (Exception ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected register client error;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : There was an error during authentication.", ex);
        }
        m_register_client_cache.put(registerClientCacheKey, registerClientResult);
        return registerClientResult;
    }

    private boolean isCachedRegisterClientResultValid(RegisterClientResult cachedRegisterClientResult) {
        if (cachedRegisterClientResult == null || cachedRegisterClientResult.getClientSecretExpiresAt() == null) {
            return false;
        }
        return System.currentTimeMillis() < cachedRegisterClientResult.getClientSecretExpiresAt() * 1000L;
    }

    protected StartDeviceAuthorizationResult getStartDeviceAuthorizationResult(String clientId, String clientSecret, String startUrl) throws IOException {
        StartDeviceAuthorizationRequest startDeviceAuthorizationRequest = new StartDeviceAuthorizationRequest();
        startDeviceAuthorizationRequest.withClientId(clientId);
        startDeviceAuthorizationRequest.withClientSecret(clientSecret);
        startDeviceAuthorizationRequest.withStartUrl(startUrl);
        StartDeviceAuthorizationResult startDeviceAuthorizationResult = null;
        try {
            startDeviceAuthorizationResult = this.m_sdk_client.startDeviceAuthorization(startDeviceAuthorizationRequest);
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("startDeviceAuthorization response code: {0}", startDeviceAuthorizationResult.getSdkHttpMetadata().getHttpStatusCode());
            }
        }
        catch (SlowDownException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Too frequent requests made by client;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : Requests to the IdC service are too frequent.", ex);
        }
        catch (InternalServerException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Server error in start device authorization;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : An error occurred during the request.", ex);
        }
        catch (Exception ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected error in start device authorization;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : There was an error during authentication.", ex);
        }
        return startDeviceAuthorizationResult;
    }

    protected void openBrowser(String verificationUri) throws IOException {
        this.validateURL(verificationUri);
        Desktop.getDesktop().browse(URI.create(verificationUri));
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Authorization code request URI: \n%s", verificationUri), new Object[0]);
        }
    }

    protected CreateTokenResult getCreateTokenResult(String clientId, String clientSecret, String deviceCode, String grantType, String ... scope) {
        CreateTokenRequest createTokenRequest = new CreateTokenRequest();
        createTokenRequest.withClientId(clientId);
        createTokenRequest.withClientSecret(clientSecret);
        createTokenRequest.withDeviceCode(deviceCode);
        createTokenRequest.withGrantType(grantType);
        createTokenRequest.withScope(scope);
        return this.m_sdk_client.createToken(createTokenRequest);
    }

    protected CreateTokenResult fetchTokenResult(RegisterClientResult registerClientResult, StartDeviceAuthorizationResult startDeviceAuthorizationResult, String grantType, String scope) throws IOException {
        long pollingEndTime = System.currentTimeMillis() + (long)this.m_idcResponseTimeout * 1000L;
        int pollingIntervalInSec = 1;
        if (startDeviceAuthorizationResult.getInterval() != null && startDeviceAuthorizationResult.getInterval() > 0) {
            pollingIntervalInSec = startDeviceAuthorizationResult.getInterval();
        }
        while (System.currentTimeMillis() < pollingEndTime) {
            try {
                CreateTokenResult createTokenResult = this.getCreateTokenResult(registerClientResult.getClientId(), registerClientResult.getClientSecret(), startDeviceAuthorizationResult.getDeviceCode(), grantType, scope);
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("createToken response code: {0}", createTokenResult.getSdkHttpMetadata().getHttpStatusCode());
                }
                if (createTokenResult != null && createTokenResult.getAccessToken() != null) {
                    return createTokenResult;
                }
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logError("Failed to fetch an IdC access token", new Object[0]);
                }
                throw new IOException("IdC authentication failed : The credential token couldn't be created.");
            }
            catch (AuthorizationPendingException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("Browser authorization pending from user", new Object[0]);
                }
            }
            catch (SlowDownException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Too frequent createToken requests made by client;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : Requests to the IdC service are too frequent.", ex);
            }
            catch (AccessDeniedException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Access denied, please ensure app assignment is done for the user;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : You don't have sufficient permission to perform the action.", ex);
            }
            catch (InternalServerException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Server error in creating token;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : An error occurred during the request.", ex);
            }
            catch (Exception ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected error in create token;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : There was an error during authentication.", ex);
            }
            try {
                Thread.sleep((long)pollingIntervalInSec * 1000L);
            }
            catch (InterruptedException ex) {
                if (!RedshiftLogger.isEnable()) continue;
                this.m_log.log(LogLevel.ERROR, ex, "Thread interrupted during sleep", new Object[0]);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.logError("Error: Request timed out while waiting for user authentication in the browser", new Object[0]);
        }
        throw new IOException("IdC authentication failed : The request timed out. Authentication wasn't completed.");
    }

    protected NativeTokenHolder processCreateTokenResult(CreateTokenResult createTokenResult) throws IOException {
        String idcToken = createTokenResult.getAccessToken();
        int expiresInSecs = createTokenResult.getExpiresIn() != null && createTokenResult.getExpiresIn() > 0 ? createTokenResult.getExpiresIn() : 900;
        Date expiration = new Date(System.currentTimeMillis() + (long)expiresInSecs * 1000L);
        return NativeTokenHolder.newInstance(idcToken, expiration);
    }
}

