/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExecutableStageTranslation {
    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload getExecutableStagePayload(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedTransform) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.PTransform transform = PTransformTranslation.toProto(appliedTransform, SdkComponents.create(appliedTransform.getPipeline().getOptions()));
        Preconditions.checkArgument((boolean)"beam:runner:executable_stage:v1".equals(transform.getSpec().getUrn()));
        return RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getSpec().getPayload());
    }

    public static @UnknownKeyFor @NonNull @Initialized String generateNameFromStagePayload(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload) {
        StringBuilder sb = new StringBuilder();
        RunnerApi.Components components = stagePayload.getComponents();
        int transformsCount = stagePayload.getTransformsCount();
        sb.append("[").append(transformsCount).append("]");
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < transformsCount; ++i) {
            String name = components.getTransformsOrThrow(stagePayload.getTransforms(i)).getUniqueName();
            name = name.replaceFirst("/ParMultiDo\\(Anonymous\\)$", "");
            names.add(name);
        }
        sb.append(ExecutableStageTranslation.generateNameFromTransformNames(names, true));
        return sb.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String generateNameFromTransformNames(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> names, @UnknownKeyFor @NonNull @Initialized boolean truncateSiblingComposites) {
        LinkedHashMultimap groupByOuter = LinkedHashMultimap.create();
        for (String name : names) {
            int index = name.indexOf(47);
            if (index == -1) {
                groupByOuter.put((Object)name, (Object)"");
                continue;
            }
            groupByOuter.put((Object)name.substring(0, index), (Object)name.substring(index + 1));
        }
        if (groupByOuter.keySet().size() == 1) {
            Map.Entry outer2 = (Map.Entry)Iterables.getOnlyElement(groupByOuter.asMap().entrySet());
            if (((Collection)outer2.getValue()).size() == 1 && ((Collection)outer2.getValue()).contains("")) {
                return (String)outer2.getKey();
            }
            return String.format("%s/%s", outer2.getKey(), ExecutableStageTranslation.generateNameFromTransformNames((Collection)outer2.getValue(), truncateSiblingComposites));
        }
        Collection parts = truncateSiblingComposites ? groupByOuter.keySet() : (Collection)groupByOuter.asMap().entrySet().stream().map(outer -> String.format("%s/%s", outer.getKey(), ExecutableStageTranslation.generateNameFromTransformNames((Collection)outer.getValue(), truncateSiblingComposites)).replaceAll("/$", "")).collect(Collectors.toList());
        return String.format("{%s}", Joiner.on((String)", ").join((Iterable)parts));
    }
}

