/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.ImmutableListBundleFactory;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

class CloningBundleFactory
implements BundleFactory {
    private static final @UnknownKeyFor @NonNull @Initialized CloningBundleFactory INSTANCE = new CloningBundleFactory();
    private final @UnknownKeyFor @NonNull @Initialized ImmutableListBundleFactory underlying = ImmutableListBundleFactory.create();

    public static @UnknownKeyFor @NonNull @Initialized CloningBundleFactory create() {
        return INSTANCE;
    }

    private CloningBundleFactory() {
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createRootBundle() {
        return this.underlying.createRootBundle();
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createBundle(@UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return new CloningBundle(this.underlying.createBundle(output));
    }

    @Override
    public <K, T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createKeyedBundle(@UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return new CloningBundle(this.underlying.createKeyedBundle(key, output));
    }

    private static class CloningBundle<@UnknownKeyFor T>
    implements UncommittedBundle<T> {
        private final @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> underlying;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        private CloningBundle(@UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> underlying) {
            this.underlying = underlying;
            this.coder = underlying.getPCollection().getCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> getPCollection() {
            return this.underlying.getPCollection();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> add(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
            try {
                WindowedValue clone = element.withValue(CoderUtils.clone(this.coder, (Object)element.getValue()));
                this.underlying.add(clone);
            }
            catch (CoderException e) {
                throw UserCodeException.wrap((Throwable)e);
            }
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> commit(@UnknownKeyFor @NonNull @Initialized Instant synchronizedProcessingTime) {
            return this.underlying.commit(synchronizedProcessingTime);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Data", (Object)this.underlying.toString()).add("Coder", (Object)this.coder.toString()).toString();
        }
    }
}

