/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLHeading
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4715727576328707163L;
    private int level_;
    private String text_;
    private String align_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;

    public HTMLHeading() {
        this.setLevel(1);
    }

    public HTMLHeading(int level) {
        this.setLevel(level);
    }

    public HTMLHeading(int level, String text) {
        this.setLevel(level);
        this.setText(text);
    }

    public HTMLHeading(int level, String text, String align) {
        this.setLevel(level);
        this.setText(text);
        this.setAlign(align);
    }

    public String getAlign() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getLevel() {
        return this.level_;
    }

    public String getText() {
        return this.text_;
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.text_ == null) {
            Trace.log(2, "Attempting to get tag before setting heading text.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer s = new StringBuffer("<h" + Integer.toString(this.level_));
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                s.append(" align=\"left\"");
            } else if (this.align_.equals("right")) {
                s.append(" align=\"right\"");
            } else if (this.align_.equals("center")) {
                s.append(" align=\"center\"");
            }
        }
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">" + this.text_ + "</h");
        if (this.level_ > 0) {
            s.append(Integer.toString(this.level_));
        }
        s.append(">");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (this.text_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting heading text.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer s = new StringBuffer("<fo:block-container");
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        s.append("<fo:block");
        switch (this.level_) {
            case 1: {
                s.append(" font-size='25pt'");
                break;
            }
            case 2: {
                s.append(" font-size='20pt'");
                break;
            }
            case 3: {
                s.append(" font-size='15pt'");
                break;
            }
            case 4: {
                s.append(" font-size='13pt'");
                break;
            }
            case 5: {
                s.append(" font-size='11pt'");
                break;
            }
            case 6: {
                s.append(" font-size='9pt'");
            }
        }
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                s.append(" text-align='start'");
            } else if (this.align_.equals("right")) {
                s.append(" text-align='end'");
            } else if (this.align_.equals("center")) {
                s.append(" text-align='center'");
            }
        }
        s.append(">");
        s.append(this.text_);
        s.append("</fo:block>\n");
        s.append("</fo:block-container>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setAlign(String align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (!(align.equals("left") || align.equals("right") || align.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String old = this.align_;
        this.align_ = align;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", old, align);
        }
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setLevel(int level) {
        if (level < 1 || level > 6) {
            throw new ExtendedIllegalArgumentException("level", 4);
        }
        int old = this.level_;
        this.level_ = level;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("level", (Object)old, (Object)level);
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String old = this.text_;
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

