/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.RadioFormInput;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class RadioFormInputGroup
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1787781415625086189L;
    private String name_;
    private Vector list_;
    private boolean useVertAlign_ = false;
    private boolean groupCheck_ = false;
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public RadioFormInputGroup() {
        this.list_ = new Vector();
    }

    public RadioFormInputGroup(String name) {
        try {
            this.setName(name);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.list_ = new Vector();
    }

    public void add(RadioFormInput radioButton) {
        if (radioButton == null) {
            throw new NullPointerException("radioButton");
        }
        if (this.name_ == null) {
            this.name_ = radioButton.getName();
        } else {
            try {
                radioButton.setName(this.name_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.groupCheck_ && radioButton.isChecked()) {
            Trace.log(2, "Previous RadioButton marked as 'checked'.");
            throw new ExtendedIllegalArgumentException("checked", 2);
        }
        if (!this.groupCheck_ && radioButton.isChecked()) {
            this.groupCheck_ = true;
        }
        this.list_.addElement(radioButton);
        this.fireElementEvent(0);
    }

    public RadioFormInput add(String name, String value, String label, boolean checked) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (label == null) {
            throw new NullPointerException("label");
        }
        RadioFormInput radioButton = new RadioFormInput(name, value, label, checked);
        if (this.name_ == null) {
            this.name_ = name;
        } else {
            try {
                radioButton.setName(this.name_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.groupCheck_ && radioButton.isChecked()) {
            Trace.log(2, "Previous RadioButton marked as 'checked'.");
            throw new ExtendedIllegalArgumentException("checked", 2);
        }
        if (!this.groupCheck_ && radioButton.isChecked()) {
            this.groupCheck_ = true;
        }
        this.list_.addElement(radioButton);
        this.fireElementEvent(0);
        return radioButton;
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getName() {
        return this.name_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A RadioFormInputGroup was here -->";
    }

    @Override
    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("");
        this.groupCheck_ = false;
        Properties eProp = null;
        Properties rgProp = this.getAttributes();
        for (int i = 0; i < this.list_.size(); ++i) {
            RadioFormInput r = (RadioFormInput)this.list_.elementAt(i);
            eProp = r.getAttributes();
            if (eProp == null && rgProp != null) {
                r.setAttributes(rgProp);
            }
            s.append(r.getTag());
            if (this.useVertAlign_) {
                s.append(" <br />");
            }
            s.append("\n");
        }
        return s.toString();
    }

    public boolean isAlignmentVertical() {
        return this.useVertAlign_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void remove(RadioFormInput radioButton) {
        if (radioButton == null) {
            throw new NullPointerException("radioButton");
        }
        if (radioButton.isChecked()) {
            this.groupCheck_ = false;
        }
        if (this.list_.removeElement(radioButton)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name);
        }
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setVerticalAlignment(boolean verticalAlignment) throws PropertyVetoException {
        boolean oldAlign = this.useVertAlign_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("verticalAlignment", (Object)oldAlign, (Object)verticalAlignment);
        }
        this.useVertAlign_ = verticalAlignment;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("verticalAlignment", (Object)oldAlign, (Object)verticalAlignment);
        }
    }
}

